---
name: api-tester
description: Perform structured HTTP/HTTPS requests (GET, POST, PUT, DELETE) with custom headers and JSON body support. Use for API testing, health checks, or interacting with REST services programmatically without relying on curl.
---

# API Tester

A lightweight, dependency-free HTTP client for OpenClaw.

## Usage

### Basic GET Request

```javascript
const api = require('skills/api-tester');
const result = await api.request('GET', 'https://api.example.com/data');
console.log(result.status, result.data);
```

### POST Request with JSON Body

```javascript
const api = require('skills/api-tester');
const payload = { key: 'value' };
const headers = { 'Authorization': 'Bearer <token>' };
const result = await api.request('POST', 'https://api.example.com/submit', headers, payload);
```

### Return Format

The `request` function returns a Promise resolving to:

```javascript
{
  status: 200,          // HTTP status code
  headers: { ... },     // Response headers
  data: { ... },        // Parsed JSON body (if applicable) or raw string
  raw: "...",           // Raw response body string
  error: "..."          // Error message if request failed (network error, timeout)
}
```

## Features

- **Zero dependencies**: Uses Node.js built-in `http` and `https` modules.
- **Auto-JSON**: Automatically stringifies request body and parses response body if Content-Type matches.
- **Timeout support**: Default 10s timeout, configurable.
- **Error handling**: Returns structured error object instead of throwing, ensuring safe execution.
