# 🕷️ AnyCrawl

High-performance web scraping, crawling, and search API for OpenClaw.

## Features

- 🔍 **Google Search** - Structured SERP results
- 📄 **Single Page Scrape** - Convert any URL to markdown/html/json
- 🕸️ **Full Site Crawl** - Async crawling with depth control
- ⚡ **Multi-engine** - Cheerio (fast), Playwright/Puppeteer (JS rendering)

## Quick Start

```bash
# 1. Set API key (get at https://anycrawl.dev)
export ANYCRAWL_API_KEY="your-api-key"

# 2. Use it!
anycrawl_search({ query: "AI news", limit: 5 })
anycrawl_scrape({ url: "https://example.com" })
```

Or add to `~/.bashrc` to make it permanent:
```bash
echo 'export ANYCRAWL_API_KEY="your-api-key"' >> ~/.bashrc
source ~/.bashrc
```

## API Functions

| Function | Description |
|----------|-------------|
| `anycrawl_search` | Google search with structured results |
| `anycrawl_scrape` | Scrape single URL to markdown/html |
| `anycrawl_crawl_start` | Start async website crawl |
| `anycrawl_crawl_status` | Check crawl progress |
| `anycrawl_crawl_results` | Get crawled pages |
| `anycrawl_search_and_scrape` | Search + auto-scrape top results |

## Docs

Full documentation in [SKILL.md](./SKILL.md)
