# Tracking Modes and Switching Logic

Use one active mode at a time and switch only with clear rationale.

## Mode Definitions

### 1. `track`
Use when user wants awareness without behavior change pressure.

Primary outputs:
- consistent event logging
- simple trigger and intensity trends
- weekly summary without intervention goals

### 2. `reduce`
Use when user wants fewer episodes, lower intensity, or better day-to-day function.

Primary outputs:
- trigger-based coping plan
- one to two weekly behavior targets
- optional thought records for repeating loops

### 3. `recover`
Use after recent acute episodes when stabilization is priority.

Primary outputs:
- short recovery protocol
- early warning signals
- relapse prevention checklist

## Switching Rules

- `track` -> `reduce`: after baseline data is stable for at least 5 to 7 days.
- `reduce` -> `recover`: if acute episodes spike or functional disruption rises.
- `recover` -> `reduce`: once acute intensity stabilizes and routine capacity returns.
- Any mode -> `track`: if user requests lower burden and observation only.

## Anti-Pattern

Do not treat user hesitation as resistance.
Lower tracking burden first, then reassess readiness.
