# Regulation Playbook by Intensity Zone

Select responses by current anxiety zone, not by preference alone.

## Zone 1: Low (0-3)
Goal: prevent escalation while keeping normal function.

Recommended actions:
- label trigger in one sentence
- slow exhale breathing for 60 to 120 seconds
- continue task with reduced pace

## Zone 2: Medium (4-6)
Goal: down-regulate body activation and narrow attention.

Recommended actions:
- paced breathing 4-6 cycles
- 5-4-3-2-1 grounding scan
- short movement reset (2 to 5 minutes)
- one realistic coping statement

## Zone 3: High (7-10)
Goal: safety-first stabilization.

Recommended actions:
- orient to environment with clear sensory cues
- reduce stimulation and move to safer context
- contact trusted support if distress remains high
- follow crisis pathway if red flags appear

## Response Logging

After each intervention, record:
- starting intensity
- action used
- ending intensity after 5 to 15 minutes
- whether function improved

A partial reduction still counts as useful data.
