---
name: anxiety-relief
description: Manage anxiety with grounding exercises, breathing techniques, and thought reframing
author: clawd-team
version: 1.0.0
triggers:
  - "feeling anxious"
  - "anxiety help"
  - "calm me down"
  - "panic attack"
  - "anxiety relief"
---

# Anxiety Relief

Manage anxiety in the moment with evidence-based grounding, breathing, and reframing techniques.

## What it does

- **Grounding Exercises** - Anchor yourself to the present using sensory techniques
- **Breathing Techniques** - Activate your parasympathetic nervous system with structured patterns
- **Thought Reframing** - Challenge anxious thoughts with cognitive tools
- **Anxiety Logging** - Track patterns, triggers, and what helps over time

## Usage

### Quick Relief
Fastest tools when you need immediate calm.
- *4-7-8 breathing* - 2 minutes, very effective
- *5-4-3-2-1 grounding* - Engages all senses, breaks the cycle
- *Box breathing* - Military-grade calming technique

### Breathing Exercises
Structured patterns that signal safety to your nervous system.
- Slow, deep breathing activates the vagus nerve
- Rhythm matters more than depth
- 5-10 minutes typical duration

### Ground Me
Sensory anchoring to pull you out of anxious thoughts.
- Physical grounding (feet on floor, ice cube in hand)
- Sensory grounding (name what you see, hear, feel)
- Environmental grounding (movement, cold water)

### Log Anxiety
Track episodes to identify patterns.
- When it started and what triggered it
- Intensity (1-10 scale)
- What helped and how long recovery took
- Physical symptoms (heart racing, sweating, tension)

### Pattern Review
Weekly or monthly check-in to spot trends.
- Which techniques work best for you
- Common triggers and early warning signs
- Time of day, stress levels, sleep quality
- What reduces frequency over time

## Techniques

### 4-7-8 Breathing
The most powerful single technique. Works in 2 minutes.

1. Breathe in through your nose for 4 counts
2. Hold for 7 counts
3. Exhale through your mouth for 8 counts
4. Repeat 4 cycles

*Why it works:* Extended exhale activates parasympathetic nervous system. Your body can't stay anxious when exhales are longer than inhales.

### Box Breathing
Used by Navy SEALs and emergency responders.

1. Breathe in for 4 counts
2. Hold for 4 counts
3. Breathe out for 4 counts
4. Hold for 4 counts
5. Repeat 5-10 cycles

*Why it works:* Perfect balance signals your nervous system that you're safe. Predictable rhythm is calming.

### 5-4-3-2-1 Grounding
Full sensory reset in 3-5 minutes.

Name 5 things you **see**, 4 things you can **touch**, 3 things you **hear**, 2 things you **smell**, 1 thing you **taste**.

*Why it works:* Floods your prefrontal cortex with sensory data, crowding out anxious thoughts. Forces present-moment awareness.

### Body Scan
Progressive muscle relaxation to release tension.

1. Start at your toes. Notice any tension without judgment.
2. Move slowly up through your body: feet, legs, stomach, chest, arms, neck, head.
3. Breathe into any tight areas. Consciously relax on exhale.
4. Total time: 5-10 minutes

*Why it works:* Anxiety lives in your body. Scanning releases trapped tension and breaks the anxiety→tension→more anxiety loop.

## Tips

1. **Practice before you need it.** Use these techniques when calm so your nervous system recognizes them as safe. Then they work instantly when anxiety hits.

2. **Consistency beats intensity.** 5 minutes daily is better than one 30-minute session. Build the habit so it's automatic when panic strikes.

3. **Find your anchor.** Different techniques work for different people. Try all of them, then pick 2-3 that feel most natural. Use those as your go-to toolkit.

4. **Track what works.** Not every technique helps every time. Log which one ended the episode and how long it took. Your own data is your best guide.

5. **All data stays local on your machine.** Your anxiety logs, triggers, and patterns never leave your device. No cloud sync, no third-party access.

## If You're in Crisis

This skill is not a substitute for professional help.

- **988** (Suicide & Crisis Lifeline) - Call or text 988 anytime, 24/7
- **Text HOME to 741741** (Crisis Text Line) - Free crisis support via text

If you're having thoughts of self-harm, please reach out to one of these resources immediately.
