---
name: social-draft
description: "Draft Twitter and LinkedIn posts in one go. Use when user wants to create social media content for announcements, achievements, or updates. Combines tweet-writer and linkedin-writer skills for platform-optimized content."
---

# Social Draft

Create platform-optimized Twitter and LinkedIn posts in one workflow.

## Trigger
User asks to "draft a post", "write social content", or mentions both Twitter/LinkedIn.

## Workflow

### 1. Gather Context
Ask the user for:
- **Topic** - What's the announcement/achievement/update?
- **Key details** - Numbers, results, specific outcomes
- **Tone** - Casual, professional, or thought-leader
- **Goal** - Engagement, awareness, leads?

### 2. Draft Twitter Post (X)

**Hook Rules:**
- First 7 words must stop the scroll
- Use specific numbers/results
- Under 110 characters for single tweets
- Signal thread with "🧵" if needed

**Format Options:**
- **Bold Statement**: "Unpopular opinion: [take]"
- **Specific Result**: "I [result] in [timeframe]. Here's how:"
- **List Promise**: "[Number] things that [benefit]:"

**Twitter Best Practices:**
- No external links in main tweet
- No "Like and RT!" begging
- End with question to drive replies
- Post during peak hours (9-11 AM / 7-9 PM EST)

### 3. Draft LinkedIn Post

**Hook Rules:**
- First 2 lines determine if they click "see more"
- Bold or counterintuitive opening
- Professional but conversational

**Format Options:**
- **Story Post**: Hook → Story → Lesson → Question
- **Contrarian Take**: Challenge conventional wisdom
- **List Post**: Hook → Numbered list → Closer
- **Lesson Learned**: "I used to think X. Now I think Z."

**LinkedIn Best Practices:**
- Short paragraphs (1-2 sentences)
- Line breaks between paragraphs
- 3-5 hashtags at bottom only
- No buzzwords: "synergy", "leverage", "ecosystem"
- End with question to drive comments
- Under 1300 characters

### 4. Deliver Both Drafts

Present both drafts clearly labeled:

```
## 🐦 Twitter Draft
[Single tweet or thread]

---

## 💼 LinkedIn Draft
[LinkedIn post with proper formatting]
```

## Platform Differences

| Element | Twitter | LinkedIn |
|---------|---------|----------|
| Max length | 280 chars | 3000 chars (1300 optimal) |
| Paragraphs | N/A | 1-2 sentences max |
| Hashtags | 1-2 inline | 3-5 at bottom only |
| Links | In reply, not main | OK in post |
| Emojis | OK, don't overdo | One max |
| Voice | Snappy, punchy | Conversational, professional |

## Example

**Input:** "PMS Bug Addition skill success - automated bug reporting workflow"

**Output:**

### 🐦 Twitter Draft
```
Just shipped a new skill for my AI assistant. 🚀

Now I can say "PMS Bug addition" and it:
✅ Creates GitHub issue
✅ Updates task tracker
✅ Logs to daily sheet

All automated. Zero manual work.

What's your favorite automation hack?
```

### 💼 LinkedIn Draft
```
I built something that saves me 15 minutes per bug report.

The old workflow:
1. Create GitHub issue manually
2. Copy details to task tracker sheet
3. Log in daily update sheet
4. Repeat for every bug

The new workflow:
Say "PMS Bug addition" + details. Done.

My AI assistant (Anukar) handles:
- Issue creation with proper formatting
- Sheet updates across 2 different tabs
- Real-time dashboard logging

It's not about being lazy. It's about removing friction from repetitive tasks so I can focus on actual problem-solving.

What repetitive task would you automate if you could?

#Automation #Productivity #AI #OpenClaw
```

## Quality Checklist

Before delivering, verify:

**Twitter:**
- [ ] Hook stops scroll (bold/specific/curious)
- [ ] Under 280 characters (110 optimal)
- [ ] No external links in main tweet
- [ ] Has engagement driver (question)

**LinkedIn:**
- [ ] First 2 lines compelling
- [ ] Short paragraphs with line breaks
- [ ] No buzzwords or cringe phrases
- [ ] Specific numbers/details included
- [ ] Ends with question
- [ ] 3-5 hashtags at bottom
