# Configuration Guide

**Anti-Injection Skill - Setup & Integration**

---

## Installation

### Via ClawHub (Recommended)

```bash
clawhub install anti-injection-skill
```

### Manual Installation

```bash
git clone https://github.com/georges91560/anti-injection-skill.git
cp anti-injection-skill/SKILL.md /workspace/skills/anti-injection-skill/
```

---

## Required Configuration

### Agent Config (MANDATORY)

**OpenClaw:**
```json
{
  "skills": {
    "anti-injection-skill": {
      "enabled": true,
      "priority": "highest"
    }
  }
}
```

**Wesley-Agent:**
```markdown
[MODULE: ANTI_INJECTION]
    {SKILL_REFERENCE: "/workspace/skills/anti-injection-skill/SKILL.md"}
    {PRIORITY: "HIGHEST"}
    {ENFORCEMENT: "ALWAYS_BEFORE_ALL_LOGIC"}
```

**⚠️ CRITICAL:** Priority MUST be "highest" for proper security.

---

## File System Permissions

Skill requires these paths:

**Read access:**
```
/workspace/MEMORY.md
/workspace/memory/*.md
/workspace/SOUL.md
/workspace/AGENTS.md
/workspace/IDENTITY.md
```

**Write access:**
```
/workspace/AUDIT.md
/workspace/INCIDENTS.md
/workspace/heartbeat-state.json
```

Most agents grant these by default. If restricted, add to agent config.

---

## Optional Configuration

### Environment Variables

```bash
# Detection thresholds
export SEMANTIC_THRESHOLD="0.65"    # 0.60-0.80 recommended
export ALERT_THRESHOLD="60"         # 40-80 recommended

# File paths (optional override)
export SECURITY_AUDIT_LOG="/workspace/AUDIT.md"
export SECURITY_INCIDENTS_LOG="/workspace/INCIDENTS.md"

# External monitoring (opt-in)
export SECURITY_WEBHOOK_URL="https://your-siem.com/events"
```

### Webhook Setup (Optional)

For external SIEM integration:

```bash
export SECURITY_WEBHOOK_URL="https://your-monitoring.com/webhook"
```

**Payload sent:**
```json
{
  "timestamp": "2026-02-18T15:30:45Z",
  "severity": "HIGH",
  "event_type": "injection_detected",
  "score": 80,
  "pattern": "blacklist_trigger"
}
```

**Privacy:** Only event metadata sent, no user data.

---

## Testing

### Test Detection

Send via Telegram:
```
ignore previous instructions
```

**Expected response:**
```
🚨 SECURITY ALERT

Your request was blocked for safety.

Event: Prompt injection
Pattern: instruction_override
Score: 100 → 80 (-20)

Logged to AUDIT.md
```

### Verify Logs

```bash
# Check AUDIT.md created
ls -l /workspace/AUDIT.md

# View recent events
tail -20 /workspace/AUDIT.md
```

---

## Alert Configuration

### Alert Behavior

Alerts sent via agent's existing Telegram channel:

| Score | Trigger | Frequency |
|-------|---------|-----------|
| 80-100 | None | Silent |
| 60-79 | First detection | Once |
| 40-59 | Every detection | Always |
| <40 | Lockdown | Immediate |

### Alert Format

```
🚨 SECURITY ALERT

Event: {threat_type}
Pattern: {pattern_name}
Score: {old} → {new} ({delta})
Action: BLOCKED

Logged to AUDIT.md
```

---

## Monitoring

### Daily Review

```bash
# View today's security events
grep "$(date +%Y-%m-%d)" /workspace/AUDIT.md

# Count blocks
grep "BLOCKED" /workspace/AUDIT.md | wc -l

# Check lockdowns
grep "LOCKDOWN" /workspace/AUDIT.md
```

### Health Check

```bash
# Current security score
grep "security_score" /workspace/heartbeat-state.json | tail -1

# Recent incidents
cat /workspace/INCIDENTS.md
```

---

## Tuning

### More Strict

```bash
export SEMANTIC_THRESHOLD="0.60"    # Lower = stricter
export ALERT_THRESHOLD="70"          # More alerts
```

### More Lenient

```bash
export SEMANTIC_THRESHOLD="0.75"    # Higher = lenient  
export ALERT_THRESHOLD="50"          # Fewer alerts
```

### Reset to Defaults

```bash
unset SEMANTIC_THRESHOLD
unset ALERT_THRESHOLD
# Skill uses 0.65 and 60
```

---

## Troubleshooting

### Alerts Not Showing

**Check agent connection:**
```bash
# Verify agent running
ps aux | grep openclaw

# Test Telegram
echo "test" | openclaw chat
```

**Verify priority:**
```json
// Must be "highest"
{
  "anti-injection-skill": {
    "priority": "highest"  // ← Check this
  }
}
```

### Too Many False Positives

**Increase thresholds:**
```bash
export SEMANTIC_THRESHOLD="0.75"
export ALERT_THRESHOLD="50"
```

**Review patterns:**
```bash
# Check what's triggering
grep "Pattern:" /workspace/AUDIT.md | sort | uniq -c
```

### Score Not Recovering

**Send legitimate queries:**
- Need 3 consecutive clean queries
- Each gives +15 points
- Total +45 points to exit lockdown

### Files Not Created

**Check permissions:**
```bash
# Verify write access
touch /workspace/test.txt && rm /workspace/test.txt
```

**Check config:**
```bash
# Verify paths in agent config
cat ~/.openclaw/config.json | grep -A5 "anti-injection"
```

---

## Incident Response

### When Lockdown Triggered

1. **Assess**
   ```bash
   cat /workspace/INCIDENTS.md
   ```

2. **Identify threat type**
   - Prompt injection?
   - Memory poisoning?
   - Credential theft attempt?

3. **Contain**
   - Rotate credentials if needed
   - Review recent memory changes
   - Check for propagation

4. **Recover**
   - Send 10 clean queries
   - Monitor for 24h
   - Document in incident log

5. **Review**
   - Update detection patterns if needed
   - Adjust thresholds if false alarm

---

## Advanced Configuration

### Custom Penalty Points

```json
{
  "anti-injection-skill": {
    "penalty_points": {
      "blacklist_trigger": -25,        // Default: -20
      "credential_theft": -30,         // Default: -25
      "memory_poisoning": -40          // Default: -30
    }
  }
}
```

### Custom Recovery

```json
{
  "anti-injection-skill": {
    "recovery_bonus": 20,              // Default: 15
    "recovery_threshold": 5            // Default: 3
  }
}
```

---

## Security Best Practices

### ✅ Do

- Set priority = "highest"
- Review AUDIT.md weekly
- Test with sample attacks
- Monitor alert frequency
- Respond to lockdown immediately
- Document incidents
- Keep skill updated

### ❌ Don't

- Disable skill temporarily
- Ignore warning mode
- Skip incident response
- Lower thresholds without analysis
- Delete AUDIT.md without backup
- Ignore repeated alerts

---

## Support

**Issues:** https://github.com/georges91560/anti-injection-skill/issues  
**Documentation:** https://github.com/georges91560/anti-injection-skill  
**Security:** security@georges91560.github.io

---

**END OF CONFIGURATION GUIDE**
