# Ant Design 组件库 (antd)

## 描述
为 AI 助手提供 Ant Design 组件库的使用能力。AI 可以在任何 React 项目中使用 Ant Design 的基础组件来构建 UI，包括按钮、表单、表格、模态框、布局等所有官方组件。

## 位置
`~/.openclaw/workspace/skills/antd`

## 功能
- 提供 Ant Design 所有基础组件的使用知识
- 支持在任意 React 项目中使用 Ant Design
- 提供组件属性、用法、最佳实践
- 支持 Ant Design 5.x 的所有特性
- 提供主题定制、国际化等高级用法

## 核心组件

### 通用组件
Button, Icon, Typography, Layout, Space, Divider, etc.

### 导航组件
Menu, Tabs, Breadcrumb, Dropdown, Pagination, Steps, etc.

### 数据录入组件
Form, Input, Select, Radio, Checkbox, DatePicker, Upload, etc.

### 数据展示组件
Table, Card, List, Tree, Transfer, Timeline, Badge, etc.

### 反馈组件
Modal, Message, Notification, Result, Progress, Spin, etc.

### 布局组件
Grid, Layout, Space, Divider, etc.

## 使用方法

### 在 OpenClaw 中使用
```
用 Ant Design 创建一个按钮
帮我做一个表单，包含输入框和选择器
用 Table 组件展示用户数据
添加一个 Modal 确认对话框
```

## 依赖
- React 18+
- Ant Design 5+
- @ant-design/icons

## 作者
batype

## 版本
1.0.0
