---
name: animation-ateliers
description: "Conception et animation d'ateliers collaboratifs professionnels (renoncement, modélisation de processus, diagnostic d'équipe, cartographie des flux, priorisation, rétrospectives). Utiliser cette compétence pour (1) Préparer un atelier (fiche de cadrage, déroulé, convocations), (2) Créer des supports d'animation (slides PowerPoint, canvas Klaxoon, exercices), (3) Rédiger des comptes-rendus et synthèses post-atelier, (4) Élaborer des plans d'action et suivis. Couvre toutes les phases - préparation, animation, post-atelier."
---

# Animation d'Ateliers Collaboratifs

Compétence pour concevoir, préparer et animer des ateliers professionnels dans un contexte de transformation et d'amélioration continue.

## Workflow Principal

### Phase 1 : Cadrage de l'atelier

1. **Identifier le type d'atelier** parmi les types documentés dans `references/types-ateliers.md`
2. **Définir les paramètres clés** :
   - Objectif précis et livrable attendu
   - Participants (nombre, profils, rôles)
   - Durée et format (présentiel/distanciel/hybride)
   - Outils disponibles (Klaxoon, PPT, post-its, tableau blanc)
3. **Produire la fiche de cadrage** selon le template dans `references/templates-livrables.md`

### Phase 2 : Conception du déroulé

1. **Structurer les séquences** :
   - Accueil et ice-breaker (5-15 min)
   - Cadrage et règles du jeu (5-10 min)
   - Exercice(s) principal(aux) (variable selon atelier)
   - Restitution et synthèse (15-20 min)
   - Clôture et prochaines étapes (5-10 min)

2. **Sélectionner les techniques** adaptées dans `references/techniques-animation.md`

3. **Créer les supports** :
   - Pour PowerPoint : utiliser le skill `pptx` avec structure épurée, visuelle
   - Pour Klaxoon : décrire les boards et activités à créer
   - Pour post-its/tableau : préparer les consignes et matrices

### Phase 3 : Post-atelier

1. **Rédiger le compte-rendu** : synthèse structurée, décisions, points clés
2. **Formaliser le plan d'action** : actions, responsables, échéances
3. **Planifier le suivi** : jalons, prochaine réunion

## Règles de conception

- **Rythme** : alterner phases collectives et individuelles, éviter les séquences > 45 min sans pause
- **Participation** : prévoir des mécanismes pour faire parler tout le monde (tour de table, vote silencieux, post-its)
- **Visualisation** : toujours avoir un support visuel pour ancrer les discussions
- **Time-boxing** : chronométrer chaque séquence, prévoir des tampons

## Fichiers de référence

| Fichier | Contenu | Quand le consulter |
|---------|---------|-------------------|
| `references/types-ateliers.md` | Fiches détaillées par type d'atelier | Pour choisir et adapter le format |
| `references/techniques-animation.md` | Ice-breakers, exercices, techniques de facilitation | Pour construire le déroulé |
| `references/templates-livrables.md` | Modèles de fiche de cadrage, CR, plan d'action | Pour produire les livrables |

## Adaptation au contexte

- **Présentiel** : privilégier post-its, déplacements, sous-groupes physiques
- **Distanciel** : utiliser Klaxoon/Miro, prévoir plus de pauses, séquences plus courtes
- **Hybride** : désigner un facilitateur pour les distants, dupliquer les supports
