# Animated Financial Display

Patterns for animating financial numbers with spring physics, formatting, and visual feedback. Covers animated counters, price tickers, percentage changes, and value flash effects for trading dashboards and financial UIs.

## What's Inside

- Spring-animated number components (react-spring)
- Value flash effects on price changes (up/down color feedback)
- Financial number formatting (currency, percentage, compact notation)
- Price ticker component with live change display
- Metric card with animated values and trend indicators
- CSS value flash animations with glow effects
- Typography patterns for tabular numbers

## When to Use

- Building trading dashboards with live prices
- Showing portfolio values that update in real-time
- Displaying metrics that need attention on change
- Any financial UI that benefits from motion

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/design-systems/animated-financial-display
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/design-systems/animated-financial-display .cursor/skills/animated-financial-display
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/design-systems/animated-financial-display ~/.cursor/skills/animated-financial-display
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/design-systems/animated-financial-display .claude/skills/animated-financial-display
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/design-systems/animated-financial-display ~/.claude/skills/animated-financial-display
```

## Related Skills

- [financial-data-visualization](../financial-data-visualization/) — Chart theming and data visualization
- [design-system-creation](../../meta/design-system-creation/) — Complete design system workflow
- [realtime-react-hooks](../../realtime/realtime-react-hooks/) — Real-time data hooks for live updates

---

Part of the [Design Systems](..) skill category.
