---
name: android
description: Android build system and deployment patterns
---

# Android Build & Deploy

## ADB Essentials

```bash
# Debug builds require -t flag (agents forget this)
adb install -r -t app-debug.apk

# Filter logcat for app + errors only
adb logcat -s "YourApp:*" "*:E"
```

## Gradle Critical Fixes

```gradle
android {
    compileSdk 35
    defaultConfig {
        targetSdk 35  // MUST match or Play Console rejects
        multiDexEnabled true  // Required for 64K+ methods
    }
}

dependencies {
    // BOM prevents Compose version conflicts
    implementation platform('androidx.compose:compose-bom:2024.12.01')
}
```

## Compose State Errors

```kotlin
// WRONG - recomputed every recomposition
val filtered = items.filter { it.isValid }

// CORRECT - remember expensive operations  
val filtered = remember(items) { items.filter { it.isValid } }

// WRONG - state resets on recomposition
var count by mutableStateOf(0)

// CORRECT - remember state
var count by remember { mutableStateOf(0) }
```

## AndroidManifest Pitfall

```xml
<!-- Declare camera optional or Play Console auto-requires it -->
<uses-feature android:name="android.hardware.camera" android:required="false" />
```