# Shortcuts — Android Studio

## Navigation

| Action | macOS | Windows/Linux |
|--------|-------|---------------|
| Search Everywhere | Double Shift | Double Shift |
| Find Action | Cmd+Shift+A | Ctrl+Shift+A |
| Recent Files | Cmd+E | Ctrl+E |
| Recent Locations | Cmd+Shift+E | Ctrl+Shift+E |
| Navigate to Class | Cmd+O | Ctrl+N |
| Navigate to File | Cmd+Shift+O | Ctrl+Shift+N |
| Navigate to Symbol | Cmd+Alt+O | Ctrl+Alt+Shift+N |
| Go to Declaration | Cmd+B | Ctrl+B |
| Go to Implementation | Cmd+Alt+B | Ctrl+Alt+B |
| Go to Super Method | Cmd+U | Ctrl+U |
| File Structure | Cmd+F12 | Ctrl+F12 |
| Type Hierarchy | Ctrl+H | Ctrl+H |
| Call Hierarchy | Ctrl+Alt+H | Ctrl+Alt+H |
| Next/Prev Method | Ctrl+Down/Up | Alt+Down/Up |
| Back/Forward | Cmd+[/] | Ctrl+Alt+Left/Right |

## Editing

| Action | macOS | Windows/Linux |
|--------|-------|---------------|
| Basic Completion | Ctrl+Space | Ctrl+Space |
| Smart Completion | Ctrl+Shift+Space | Ctrl+Shift+Space |
| Complete Statement | Cmd+Shift+Enter | Ctrl+Shift+Enter |
| Quick Documentation | F1 | Ctrl+Q |
| Parameter Info | Cmd+P | Ctrl+P |
| Generate Code | Cmd+N | Alt+Insert |
| Override Methods | Ctrl+O | Ctrl+O |
| Implement Methods | Ctrl+I | Ctrl+I |
| Surround With | Cmd+Alt+T | Ctrl+Alt+T |
| Comment Line | Cmd+/ | Ctrl+/ |
| Comment Block | Cmd+Alt+/ | Ctrl+Shift+/ |
| Duplicate Line | Cmd+D | Ctrl+D |
| Delete Line | Cmd+Backspace | Ctrl+Y |
| Join Lines | Ctrl+Shift+J | Ctrl+Shift+J |
| Move Line Up/Down | Alt+Shift+Up/Down | Alt+Shift+Up/Down |
| Extend/Shrink Selection | Alt+Up/Down | Ctrl+W / Ctrl+Shift+W |

## Refactoring

| Action | macOS | Windows/Linux |
|--------|-------|---------------|
| Refactor This | Ctrl+T | Ctrl+Alt+Shift+T |
| Rename | Shift+F6 | Shift+F6 |
| Extract Method | Cmd+Alt+M | Ctrl+Alt+M |
| Extract Variable | Cmd+Alt+V | Ctrl+Alt+V |
| Extract Field | Cmd+Alt+F | Ctrl+Alt+F |
| Extract Constant | Cmd+Alt+C | Ctrl+Alt+C |
| Extract Parameter | Cmd+Alt+P | Ctrl+Alt+P |
| Inline | Cmd+Alt+N | Ctrl+Alt+N |
| Move | F6 | F6 |
| Copy | F5 | F5 |
| Safe Delete | Cmd+Delete | Alt+Delete |
| Change Signature | Cmd+F6 | Ctrl+F6 |

## Find and Replace

| Action | macOS | Windows/Linux |
|--------|-------|---------------|
| Find | Cmd+F | Ctrl+F |
| Replace | Cmd+R | Ctrl+R |
| Find in Path | Cmd+Shift+F | Ctrl+Shift+F |
| Replace in Path | Cmd+Shift+R | Ctrl+Shift+R |
| Find Usages | Alt+F7 | Alt+F7 |
| Show Usages | Cmd+Alt+F7 | Ctrl+Alt+F7 |
| Highlight Usages | Cmd+Shift+F7 | Ctrl+Shift+F7 |

## Running and Debugging

| Action | macOS | Windows/Linux |
|--------|-------|---------------|
| Run | Ctrl+R | Shift+F10 |
| Debug | Ctrl+D | Shift+F9 |
| Run Context Config | Ctrl+Shift+R | Ctrl+Shift+F10 |
| Debug Context Config | Ctrl+Shift+D | Ctrl+Shift+F9 |
| Stop | Cmd+F2 | Ctrl+F2 |
| Resume | Cmd+Alt+R | F9 |
| Step Over | F8 | F8 |
| Step Into | F7 | F7 |
| Step Out | Shift+F8 | Shift+F8 |
| Evaluate Expression | Alt+F8 | Alt+F8 |
| Toggle Breakpoint | Cmd+F8 | Ctrl+F8 |
| View Breakpoints | Cmd+Shift+F8 | Ctrl+Shift+F8 |

## Build

| Action | macOS | Windows/Linux |
|--------|-------|---------------|
| Make Project | Cmd+F9 | Ctrl+F9 |
| Rebuild Project | Cmd+Shift+F9 | Ctrl+Shift+F9 |
| Build APK | Build menu | Build menu |
| Clean Project | Build menu | Build menu |
| Sync Gradle | File menu | File menu |

## Version Control

| Action | macOS | Windows/Linux |
|--------|-------|---------------|
| VCS Operations | Ctrl+V | Alt+` |
| Commit | Cmd+K | Ctrl+K |
| Push | Cmd+Shift+K | Ctrl+Shift+K |
| Update Project | Cmd+T | Ctrl+T |
| Show Diff | Cmd+D | Ctrl+D |
| Annotate | Ctrl+Alt+A | Ctrl+Alt+A |

## Tool Windows

| Action | macOS | Windows/Linux |
|--------|-------|---------------|
| Project | Cmd+1 | Alt+1 |
| Favorites | Cmd+2 | Alt+2 |
| Run | Cmd+4 | Alt+4 |
| Debug | Cmd+5 | Alt+5 |
| Logcat | Cmd+6 | Alt+6 |
| Structure | Cmd+7 | Alt+7 |
| Version Control | Cmd+9 | Alt+9 |
| Terminal | Alt+F12 | Alt+F12 |
| Hide All Windows | Cmd+Shift+F12 | Ctrl+Shift+F12 |
