---
name: "Analyze"
description: "Structured analysis for any input. Data, code, text, decisions, visuals. Prioritize, question, conclude."
---

## Pattern

```
Purpose → Structure → Analyze → Prioritize → Conclude
```

Before analyzing: State what decision this serves. Pick a framework. Note first impression to challenge later.

## Before

- **Purpose in one line**: "This analysis helps decide ___"
- **What's missing**: 3+ unknowns that would change conclusions
- **First impression**: Write it — then seek counter-evidence

## During

- **Prioritize always**: 🔴 Critical (1-2 max) · 🟡 Important (2-3) · ⚪ Minor
- **Mark sources**: Every claim gets `[from input]` or `[inferred]`
- **Seek disconfirmation**: Dedicate space to "why I might be wrong"
- **Distinguish**: Facts vs opinions. Correlation vs causation.

## After

- **One-line summary**: Force analysis into one sentence
- **So what?**: End with action, not summary
- **Obviousness test**: Would someone say this without reading? → Deeper

## Traps

- **Superficial**: Paraphrasing ≠ analysis
- **Equal weight**: Everything yellow = nothing prioritized
- **Confirmation bias**: First impression became conclusion
- **Missing denominator**: "500 cancellations" of 600 or 50,000?
- **Invented data**: Stats without source = hallucination

## By Domain

| Domain | Focus | Watch |
|--------|-------|-------|
| Data | Grain, missing, outliers | Centinels, mixed types |
| Code | Production breaks, dead code | Style ≠ bugs |
| Text | Thesis, evidence strength | Unsourced claims |
| Decisions | Unlisted options, reversibility | Status quo bias |
| Visual | Dominance, consistency | Platform conventions |

## Frameworks

Pick one before starting:

- **MECE**: Mutually exclusive, collectively exhaustive
- **Pros/Cons+**: Add reversibility + cost of inaction
- **Pre-mortem**: Assume failure — why?
- **Steel man**: Best opposing argument

## Output

```
🎯 PURPOSE: Decide [X]
🔴 CRITICAL: [Finding + source]
🟡 IMPORTANT: [Findings]
⚠️ COUNTER: [Contradictions]
➡️ ACTION: [Recommendation]
```

---

*Channels, not teaches. Ensures prioritization, questioning, and conclusions.*
