# Analyze Pool

Analyze a specific Uniswap pool's performance, liquidity depth, fee APY, and risk factors.

→ **[SKILL.md](SKILL.md)** — Full skill specification and workflow.

## Installation

Install into Claude Code or Cursor with:

```bash
npx skills add https://github.com/wpank/Agentic-Uniswap/tree/main/.ai/skills/analyze-pool
```

Or via Clawhub:

```bash
npx clawhub@latest install analyze-pool
```

## When to use

Use this skill when:

- You want to **evaluate a single pool** before LPing or trading heavy size.
- You need to understand **liquidity depth, historical volume, and fee APY**.
- You care about **risk factors** like volatility, concentration of liquidity, and protocol-specific risks.

## Example prompts

- "Analyze the WETH/USDC 0.3% pool on Arbitrum—TVL, volume, fee APY, and risk profile."
- "Is the USDC/OP pool on Optimism a good place to LP right now?"
- "Show me the liquidity distribution and typical fee APY for the WBTC/ETH pool on mainnet."
