# Analyze Burn Economics

Comprehensive analysis of Uniswap Firepit burn economics: historical P&L, fee accumulation trends, fee source breakdown, competitive dynamics, and profitability projections for future burns.

→ **[SKILL.md](SKILL.md)** — Full skill specification and workflow.

## Installation

Install into Claude Code or Cursor with:

```bash
npx skills add https://github.com/wpank/Agentic-Uniswap/tree/main/.ai/skills/analyze-burn-economics
```

Or via Clawhub:

```bash
npx clawhub@latest install analyze-burn-economics
```

## When to use

Use this skill when:

- You want a **governance-grade report** on historical Firepit burns and protocol fee capture.
- You need to understand **how often burns are profitable**, and by how much.
- You want a breakdown of **which pools and chains contribute most** to protocol fees.
- You need **forward-looking projections** for future burn economics under different scenarios.

## Example prompts

- "Analyze Uniswap Firepit burn economics over the last year, including average profit per burn."
- "Break down TokenJar fees by source and show which chains and pools drive most revenue."
- "Project the profitability of Firepit burns if volume increases 25% over the next 6 months."
