# Template : Matrice RACI

## Définition des Rôles

| Lettre | Rôle | Description |
|--------|------|-------------|
| **R** | Responsible (Réalise) | Exécute la tâche. Peut être partagé entre plusieurs personnes. |
| **A** | Accountable (Approuve) | Responsable final, rend des comptes. **Un seul A par ligne.** |
| **C** | Consulted (Consulté) | Donne un avis, expertise. Communication bidirectionnelle. |
| **I** | Informed (Informé) | Tenu au courant des avancées. Communication unidirectionnelle. |

---

## Matrice RACI - Mission [NOM]

### Version simple (par action)

| Action / Livrable | Sponsor | Manager Service | Équipe | Chef Projet Transfo | SI | Autres |
|-------------------|---------|-----------------|--------|---------------------|-----|--------|
| Note de cadrage | A | C | I | R | I | |
| Interviews | I | C | R | R | I | |
| Observations terrain | I | C | C | R | I | |
| Rapport diagnostic | A | C | I | R | I | |
| Plan d'actions | A | R | C | R | C | |
| Flash projet hebdo | I | I | I | R | I | |
| Comité pilotage | A | R | I | R | I | |
| Mise en œuvre actions | I | A | R | C | R | |
| Bilan de mission | A | C | I | R | I | |

---

### Version détaillée (par phase et tâche)

#### Phase 1 : Cadrage

| Tâche | Sponsor | Manager | Équipe | Transfo | SI |
|-------|---------|---------|--------|---------|-----|
| Définir périmètre | A | R | C | R | I |
| Fixer objectifs/KPIs | A | R | I | C | I |
| Valider planning | A | C | I | R | I |
| Identifier risques | C | R | C | R | I |
| Valider note cadrage | A | C | I | R | I |

#### Phase 2 : Analyse

| Tâche | Sponsor | Manager | Équipe | Transfo | SI |
|-------|---------|---------|--------|---------|-----|
| Planifier interviews | I | C | C | R | I |
| Conduire interviews | I | I | R | R | I |
| Observer terrain | I | C | C | R | I |
| Collecter données | I | C | C | R | R |
| Cartographier processus | I | C | C | R | C |

#### Phase 3 : Diagnostic

| Tâche | Sponsor | Manager | Équipe | Transfo | SI |
|-------|---------|---------|--------|---------|-----|
| Analyser constats | I | C | I | R | C |
| Identifier quick wins | I | C | C | R | I |
| Rédiger rapport | I | C | I | R | I |
| Présenter diagnostic | A | R | I | R | I |
| Valider diagnostic | A | R | C | C | I |

#### Phase 4 : Plan d'actions

| Tâche | Sponsor | Manager | Équipe | Transfo | SI |
|-------|---------|---------|--------|---------|-----|
| Co-construire actions | I | R | R | R | C |
| Prioriser (impact/effort) | A | R | C | R | C |
| Définir sprints | I | A | C | R | I |
| Valider feuille route | A | R | I | R | I |

#### Phase 5 : Suivi

| Tâche | Sponsor | Manager | Équipe | Transfo | SI |
|-------|---------|---------|--------|---------|-----|
| Animer sprints | I | A | R | C | C |
| Produire flash projet | I | I | I | R | I |
| Lever les blocages | A | R | C | C | C |
| Mesurer KPIs | I | R | C | C | R |
| Conduire rétrospectives | I | R | R | R | I |

---

## Règles d'Or

1. **Un seul A par ligne** : Si tout le monde est responsable, personne ne l'est
2. **R sans A = risque** : Toujours un décideur final identifié
3. **Trop de C = lenteur** : Limiter les consultations au strict nécessaire
4. **I bien dosé** : Informer les bonnes personnes, pas tout le monde
5. **Valider avec les parties prenantes** : Chacun doit connaître son rôle

---

## Exemple de Lecture

> "Pour la tâche **Rapport diagnostic** : le **Chef Projet Transfo** réalise (R), le **Sponsor** valide/approuve (A), le **Manager** est consulté pour avis (C), l'**Équipe** et le **SI** sont informés (I)."

---

## RACI Vierge à Compléter

| Action / Tâche | [Rôle 1] | [Rôle 2] | [Rôle 3] | [Rôle 4] | [Rôle 5] |
|----------------|----------|----------|----------|----------|----------|
| | | | | | |
| | | | | | |
| | | | | | |
| | | | | | |
| | | | | | |
