# Amsterdam Visitor Tips & Day Trips

> Practical advice and excursions beyond the city center.

---

##  Essential Visitor Tips

### Before You Go

| Task | Details |
|------|---------|
| Book Anne Frank House | 8 weeks ahead, exactly when tickets release |
| Book Van Gogh Museum | At least 3 days ahead |
| Get travel insurance | Healthcare for non-EU visitors is expensive |
| Download apps | 9292, Google Maps, Tikkie |
| Check weather | Pack rain gear regardless of forecast |
| Exchange currency | Cards work everywhere; get EUR 50 cash for markets |

### At the Airport (Schiphol)

- **Train to Centraal:** EUR 5.50, every 10 min, 15 min ride
- **Buy OV-chipkaart:** At ticket machines (EUR 7.50 + credit)
- **Skip taxis:** EUR 45-60 for what costs EUR 5 by train
- **Luggage:** Lockers at Centraal if arriving before check-in

### Getting Around

| Tip | Why |
|-----|-----|
| Rent a bike immediately | Fastest way to see the city |
| Use Google Maps cycling mode | Best routes |
| Don't walk on bike paths | Cyclists won't stop |
| Stand right on escalators | Left side for walking |
| Tap in/out with OV-chipkaart | Avoid fines |

---

##  Cycling Safety

### Rules to Know

1. **Stay right, pass left** - Same as cars
2. **Use hand signals** - Point where you're going
3. **No phone use** - EUR 140 fine
4. **Lights required at night** - Police do ticket
5. **Lock properly** - Frame + wheel, to fixed object
6. **Ring bell** - Warn pedestrians politely

### Common Mistakes

| Mistake | Consequence |
|---------|-------------|
| Walking in bike lane | Near collision |
| Stopping suddenly | Rear-ended |
| Not looking behind | Dangerous turns |
| Umbrella while cycling | Wind catches it |
| Headphones | Can't hear traffic |

---

##  Money Tips

### Currency & Payments

| Method | Where It Works |
|--------|----------------|
| Debit/Credit card | Almost everywhere |
| Maestro | Preferred over Visa/MC at some places |
| Cash | Markets, small shops, tips |
| Apple/Google Pay | Most places |

### Tipping Guide

| Service | Tip |
|---------|-----|
| Restaurant | Round up or 5-10% for excellent service |
| Cafe/bar | Round up to nearest euro |
| Taxi | Round up |
| Hotel | EUR 1-2/bag if helped |

**Note:** Tipping is NOT expected in Netherlands. Service charge is included.

### Avoiding Tourist Prices

1. **Skip Leidseplein/Rembrandtplein restaurants** - 30% more expensive
2. **Eat where locals eat** - Side streets, not canal-facing
3. **Markets for lunch** - Albert Cuyp, Foodhallen
4. **Happy hours** - 17:00-19:00 at many bars
5. **Supermarket snacks** - AH To Go for quick meals

---

##  Safety Tips

### Amsterdam is Very Safe, But...

| Concern | Advice |
|---------|--------|
| Pickpockets | Tourist areas, trams, watch bags |
| Bike theft | TWO locks, never leave unlocked |
| Scams | Fake flower sellers, CD signers |
| Drugs | Only buy from coffeeshops, never street |
| Canals | Fences are low; watch when drinking |

### Emergency Numbers

| Service | Number |
|---------|--------|
| Emergency | 112 |
| Police (non-emergency) | 0900-8844 |
| Tourist Assistance | 088-710 0600 |

---

##  Weather Preparation

### Pack These Always

| Item | Why |
|------|-----|
| Rain jacket | Rain comes suddenly |
| Layers | Temperature swings 10C in a day |
| Comfortable shoes | Cobblestones are uneven |
| Small umbrella | Backup (though wind is brutal) |
| Sunglasses | Sunny days do happen |

### Seasonal Reality

| Season | Reality |
|--------|---------|
| **Spring** | 10-18C, unpredictable, tulips |
| **Summer** | 17-25C, occasional 30C+, long days |
| **Fall** | 8-16C, rain increases |
| **Winter** | 2-8C, short days, occasional snow |

---

##  Day Trips

### Within 1 Hour

| Destination | Travel | Why Go |
|-------------|--------|--------|
| **Keukenhof** | 40 min bus | Tulips (March-May only) |
| **Zaanse Schans** | 20 min train | Windmills, cheese, clogs |
| **Haarlem** | 15 min train | Beautiful, less touristy |
| **Utrecht** | 30 min train | Unique canals, old town |
| **Volendam/Marken** | 30 min bus | Fishing villages |
| **Muiden Castle** | 20 min bus | Medieval castle |

### Worth Half Day

| Destination | Travel | Highlight |
|-------------|--------|-----------|
| **Kinderdijk** | 1.5h train+bus | UNESCO windmills |
| **Delft** | 1h train | Blue pottery, old town |
| **The Hague** | 50 min train | Mauritshuis, government |
| **Leiden** | 35 min train | University town, canals |

### Full Day

| Destination | Travel | Highlight |
|-------------|--------|-----------|
| **Rotterdam** | 40 min train | Modern architecture |
| **Giethoorn** | 2h train+bus | "Venice of Netherlands" |
| **Bruges (Belgium)** | 3h train | Medieval city |

---

##  Keukenhof Guide

### Basics

| Detail | Info |
|--------|------|
| Open | Mid-March to mid-May |
| Ticket | EUR 20 + EUR 11 bus |
| Duration | 4-6 hours |
| Best time | Mid-April (peak bloom) |
| Arrive | Opening time (8:00) to avoid crowds |

### Tips

1. Book ticket + transport combo online
2. Weekdays less crowded than weekends
3. Bring layers - outdoor gardens
4. Food is expensive inside - bring snacks
5. Bike option available from Leiden

---

##  Free Activities

| Activity | Details |
|----------|---------|
| Canal walking | Best at golden hour |
| Markets | Albert Cuyp, Dapper, Noordermarkt |
| Vondelpark | People-watching, free concerts summer |
| NEMO rooftop | Free access, great views |
| Ferry to Noord | Scenic, free, fun |
| Street art | NDSM, Spuistraat |
| Library rooftop | OBA, panoramic views |

---

##  What to Buy

### Good Souvenirs

| Item | Where |
|------|-------|
| Cheese | Markets, Henri Willig |
| Stroopwafels | Markets (fresh), Albert Heijn |
| Tulip bulbs | Markets (certified for export) |
| Dutch design | Droog, Frozen Fountain |
| Delftware | De Blauwe Tulp (authentic) |
| Jenever | Wynand Fockink |

### Skip These

| Item | Why |
|------|-----|
| Clogs | Novelty, won't use |
| Fake Delftware | Touristy, made in China |
| Overpriced "I  Amsterdam" | Generic |
| Tulip bulbs (uncertified) | Won't pass customs |

### Shopping Hours

| Day | Hours |
|-----|-------|
| Mon | 11:00-18:00 |
| Tue-Sat | 10:00-18:00 |
| Thursday | Until 21:00 |
| Sunday | 12:00-18:00 |

---

##  Quick Food Guide

### Dutch Must-Try

| Food | Where |
|------|-------|
| Stroopwafel | Markets (fresh) |
| Bitterballen | Any brown cafe |
| Kibbeling | Fish stalls |
| Poffertjes | Markets, Cafe de Prins |
| Herring | Stubbe's Haring |
| Apple pie | Cafe Winkel 43 |

### Best Cheap Eats

| Type | Where |
|------|-------|
| Indonesian | Warung Mini, Blauw (more $) |
| Surinamese | Roopram Roti, Spang Makandra |
| Falafel | Maoz |
| Pizza | La Perla |
| Fries | Vleminckx |

---

##  Useful Apps

| App | Purpose |
|-----|---------|
| **9292** | All Dutch public transport |
| **GVB** | Amsterdam transport |
| **Google Maps** | Navigation, bike routes |
| **Tikkie** | Dutch payment (splitting bills) |
| **Buienradar** | Rain radar (essential) |
| **iAmsterdam** | City guide, events |

---

##  Common Mistakes

1. **Walking in bike lanes** - Dangerous and annoying
2. **Not booking museums** - Stuck in lines
3. **Taking taxis** - Expensive, slower than biking
4. **Eating on Damrak** - Tourist trap food
5. **Skipping Noord** - Missing creative Amsterdam
6. **Photography in Red Light District** - Forbidden, fined
7. **Buying drugs on street** - Dangerous, illegal
8. **Umbrella in wind** - Use rain jacket instead
9. **Overplanning** - Best moments are unplanned
10. **Just doing center** - Neighborhoods are better

---

##  Local Secrets

| Secret | Details |
|--------|---------|
| Best view | A'DAM Lookout or OBA Library (free) |
| Best coffee | Lot Sixty One, Screaming Beans |
| Best terrace | 't Blauwe Theehuis in Vondelpark |
| Best market | Noordermarkt (Sat morning) |
| Best neighborhood | Jordaan at Sunday morning |
| Best sunset | NDSM or Houthavens |
| Best pancakes | Pancakes! Amsterdam |
| Best canal view | Brouwersgracht |

---

*The best Amsterdam experiences come from wandering off the tourist path. Get lost, explore, and don't rush.*
