# Amsterdam Itineraries - 1, 3, and 7 Day Plans

> Optimized routes to see the best of Amsterdam based on your available time.

---

##  One Day in Amsterdam

*For those with limited time - hit the highlights.*

### Morning (9:00-13:00)

| Time | Activity |
|------|----------|
| **9:00** | Start at **Rijksmuseum** (pre-booked ticket) |
| **12:00** | Walk through **Museumplein** |
| **12:15** | Quick lunch at **Foodhallen** or grab stroopwafel |

### Afternoon (13:00-18:00)

| Time | Activity |
|------|----------|
| **13:00** | Walk to **Jordaan** via Vondelpark |
| **14:00** | Explore **Nine Streets** (Negen Straatjes) |
| **15:30** | Walk along **Prinsengracht** canal |
| **16:30** | **Anne Frank House** area (exterior if no tickets) |
| **17:30** | Drink at waterfront cafe |

### Evening (18:00+)

| Time | Activity |
|------|----------|
| **18:30** | Dinner in **Jordaan** (local pick: De Reiger) |
| **20:30** | Evening canal walk (magical at night) |
| **21:30** | Drinks at **Cafe 't Smalle** or similar |

### One Day Priorities

 Must do:
- Rijksmuseum (even if rushed)
- Canal walk
- Jordaan neighborhood
- Dutch food experience

 Skip:
- Red Light District (not worth limited time)
- Multiple museums (pick one)
- Boat tours (too much time for one day)

---

##  Three Days in Amsterdam

*The ideal first visit - comprehensive without rushing.*

### Day 1: Museums & Culture

| Time | Activity |
|------|----------|
| **9:00** | **Rijksmuseum** (3 hours) |
| **12:30** | Lunch at museum cafe or Museumplein area |
| **14:00** | **Van Gogh Museum** (2.5 hours) |
| **17:00** | Walk through **Vondelpark** |
| **18:30** | Dinner in **Oud-Zuid** (upscale) or **De Pijp** |
| **21:00** | Evening stroll along canals |

### Day 2: Historic Amsterdam

| Time | Activity |
|------|----------|
| **9:00** | **Anne Frank House** (pre-booked) |
| **11:00** | Explore **Jordaan** neighborhood |
| **12:30** | Lunch at **Cafe Winkel 43** (best apple pie) |
| **14:00** | Walk to **Dam Square** |
| **14:30** | **Royal Palace** (1 hour) |
| **16:00** | **Begijnhof** hidden courtyard |
| **17:00** | Shopping on **Kalverstraat** or **Nine Streets** |
| **19:00** | Dinner in **De Pijp** |
| **21:00** | Drinks at **Brouwerij 't IJ** (windmill brewery) |

### Day 3: Local Amsterdam

| Time | Activity |
|------|----------|
| **9:00** | Rent a bike for the day |
| **9:30** | Cycle to **Albert Cuyp Market** |
| **11:00** | Explore **De Pijp** on bike |
| **12:30** | Indonesian lunch (rijsttafel) |
| **14:00** | Ferry to **Amsterdam Noord** |
| **14:30** | **NDSM Wharf** (industrial/creative) |
| **16:00** | **A'DAM Lookout** or **EYE Film Museum** |
| **18:00** | Ferry back, sunset views |
| **19:00** | Final dinner in **Jordaan** |
| **21:30** | Red Light District walk (if curious) |

---

##  Seven Days in Amsterdam

*Deep dive into the city and surroundings.*

### Day 1-3: Core Amsterdam

Follow the 3-day itinerary above.

### Day 4: Day Trip - Keukenhof or Zaanse Schans

**Option A: Keukenhof (March-May only)**
| Time | Activity |
|------|----------|
| **8:30** | Bus from Amsterdam (book combo ticket) |
| **10:00** | Arrive **Keukenhof** - tulip gardens |
| **15:00** | Return to Amsterdam |
| **16:30** | Relax at **Vondelpark** |
| **19:00** | Dinner in **Oud-West** |

**Option B: Zaanse Schans (year-round)**
| Time | Activity |
|------|----------|
| **9:30** | Train to **Zaandijk Zaanse Schans** |
| **10:00** | Explore windmills, clogs, cheese |
| **14:00** | Return to Amsterdam |
| **15:00** | **Stedelijk Museum** (modern art) |
| **18:00** | Dinner at **Foodhallen** |

### Day 5: Day Trip - Haarlem or Utrecht

**Option A: Haarlem (20 min train)**
| Time | Activity |
|------|----------|
| **10:00** | Train to **Haarlem** |
| **10:30** | **Grote Markt** - beautiful square |
| **11:00** | **Frans Hals Museum** |
| **13:00** | Lunch in Haarlem |
| **14:30** | **Teylers Museum** (oldest in NL) |
| **16:00** | Wander Haarlem streets |
| **18:00** | Return to Amsterdam |

**Option B: Utrecht (30 min train)**
| Time | Activity |
|------|----------|
| **10:00** | Train to **Utrecht** |
| **10:30** | Walk along **Oudegracht** (wharf-level canals) |
| **12:00** | Lunch at canal-side terrace |
| **14:00** | **Railway Museum** or **Rietveld Schroder House** |
| **17:00** | Drinks in Utrecht |
| **19:00** | Return to Amsterdam |

### Day 6: Hidden Amsterdam

| Time | Activity |
|------|----------|
| **9:00** | **Begijnhof** (revisit in quiet) |
| **10:00** | **Our Lord in the Attic** (hidden church) |
| **11:30** | **Tropenmuseum** (if not visited) |
| **14:00** | Lunch at **Dappermarkt** |
| **15:30** | Cycle to **Amsterdamse Bos** (city forest) |
| **18:00** | Pancakes at **Boerderij Meerzicht** |
| **20:00** | Evening in **Westerpark** area |

### Day 7: Relaxed Final Day

| Time | Activity |
|------|----------|
| **10:00** | Sleep in, leisurely breakfast |
| **11:30** | **Flower Market** (buy seeds to take home) |
| **12:30** | Final canal walk - your favorite route |
| **14:00** | Lunch at favorite spot discovered during trip |
| **16:00** | Last-minute shopping (cheese, stroopwafels) |
| **18:00** | Farewell dinner |
| **21:00** | Final evening canal stroll |

---

##  Itinerary by Interest

### Art Lovers (3 days)

| Day | Focus |
|-----|-------|
| 1 | Rijksmuseum (full day) |
| 2 | Van Gogh + Stedelijk |
| 3 | Hermitage + smaller galleries |

### Foodies (3 days)

| Day | Focus |
|-----|-------|
| 1 | Albert Cuyp Market + Indonesian dinner |
| 2 | Foodhallen + De Pijp food tour |
| 3 | Food markets + canal boat lunch |

### History Buffs (3 days)

| Day | Focus |
|-----|-------|
| 1 | Anne Frank House + Jewish Quarter |
| 2 | Amsterdam Museum + Royal Palace |
| 3 | Resistance Museum + Our Lord in the Attic |

### Party/Nightlife (weekend)

| Day | Focus |
|-----|-------|
| Fri | Leidseplein bars -> club |
| Sat | Day recovery -> Rembrandtplein -> club |
| Sun | Brunch -> chill -> early night |

---

##  Time-Saving Tips

1. **Book Anne Frank House** - Exactly at release (8 weeks ahead)
2. **Start early** - Museums open at 9:00, fewer crowds
3. **Bike rental** - Cover more ground faster
4. **Skip long lunches** - Grab and go, maximize sights
5. **Evening museum hours** - Some stay open late Friday
6. **Ferry to Noord** - Faster than you'd think
7. **Combine nearby attractions** - Museumplein = 3 museums
8. **Skip the I Amsterdam sign hunt** - It moves around, wastes time

---

##  Rainy Day Alternatives

| Instead Of | Do This |
|------------|---------|
| Canal walk | **Rijksmuseum** or **Van Gogh** |
| Bike tour | **NEMO** or **Tropenmuseum** |
| Park time | **Foodhallen** or **De Hallen** |
| Market browsing | **Shopping center** or **museum cafe** |

---

##  Neighborhood Focus Days

### Jordaan Day
- Morning: Noordermarkt (Saturday)
- Lunch: Cafe Winkel 43
- Afternoon: Nine Streets, Anne Frank House
- Evening: Brown cafe hopping

### De Pijp Day
- Morning: Albert Cuyp Market
- Lunch: Surinamese roti
- Afternoon: Sarphatipark, craft beer
- Evening: Trendy restaurants

### Noord Day
- Ferry from Centraal
- NDSM industrial arts
- A'DAM Lookout
- Eye Film Museum
- Pllek for drinks

---

*Adjust based on museum schedules, weather, and energy levels. Amsterdam rewards wandering - build in time to get lost.*
