# Amsterdam Attractions - Must-See vs Skip Guide

> What's worth your time and what's a tourist trap.

---

##  Must-See Attractions

### Top Tier (Don't Miss)

| Attraction | Why Visit | Time Needed | Ticket |
|------------|-----------|-------------|--------|
| **Rijksmuseum** | Dutch Golden Age masterpieces, Rembrandt, Vermeer | 3-4 hours | EUR 22.50 |
| **Van Gogh Museum** | World's largest Van Gogh collection | 2-3 hours | EUR 22 |
| **Anne Frank House** | Powerful Holocaust history, the actual hiding place | 1.5 hours | EUR 16 |
| **Canal Ring (Grachtengordel)** | UNESCO heritage, quintessential Amsterdam | 2-3 hours walk | Free |
| **Vondelpark** | Amsterdam's Central Park, local life | 1-2 hours | Free |
| **Jordaan neighborhood** | Charming streets, cafes, boutiques | 2-3 hours | Free |

### Second Tier (Highly Recommended)

| Attraction | Why Visit | Time Needed | Ticket |
|------------|-----------|-------------|--------|
| **NEMO Science Museum** | Great for families, rooftop views | 2-3 hours | EUR 18.50 |
| **Royal Palace (Koninklijk Paleis)** | Dam Square landmark, grand interiors | 1-1.5 hours | EUR 12.50 |
| **Stedelijk Museum** | Modern and contemporary art | 2 hours | EUR 22.50 |
| **A'DAM Lookout** | Best city views, Over the Edge swing | 1 hour | EUR 16 (swing EUR 7 extra) |
| **Begijnhof** | Hidden medieval courtyard | 30 min | Free |
| **Albert Cuyp Market** | Amsterdam's biggest street market | 1-2 hours | Free |

### Worth Visiting If Time Permits

| Attraction | Type | Time | Ticket |
|------------|------|------|--------|
| **Heineken Experience** | Beer history, tasting | 2 hours | EUR 23 |
| **Amsterdam Museum** | City history | 2 hours | EUR 17.50 |
| **Hermitage Amsterdam** | Russian art branch | 2 hours | EUR 20 |
| **EYE Film Museum** | Film history, architecture | 2 hours | EUR 12.50 |
| **Artis Zoo** | Historic zoo | 3-4 hours | EUR 27 |
| **Hortus Botanicus** | Historic botanical garden | 1.5 hours | EUR 12 |

---

##  Skip or Approach With Caution

### Tourist Traps

| Attraction | Why Skip | Alternative |
|------------|----------|-------------|
| **Madame Tussauds** | Generic, overpriced, exists everywhere | Rijksmuseum |
| **Amsterdam Dungeon** | Touristy horror house | Amsterdam Museum |
| **Body Worlds** | Seen it once, seen it all | NEMO |
| **Boat tours (Lovers, etc.)** | Crowded, expensive | Rent a small boat, or walk canals |
| **I Amsterdam sign** | No longer exists in Museumplein | Take photos at canals instead |

### Overrated (Unless Specific Interest)

| Attraction | Reality | Consider If... |
|------------|---------|-----------------|
| **Red Light District** | Crowded, seedy, less "shocking" than expected | First time in Amsterdam, evening |
| **Coffeeshops** | Novelty, nothing cultural | You want to try cannabis |
| **Bloemenmarkt** | Mostly tourist shops, not a real flower market | Quick photo op |
| **Diamond factories** | Sales pitches disguised as tours | Actually buying diamonds |

---

##  Ticket Tips

### Book in Advance (Essential)

These sell out weeks ahead:
- **Anne Frank House** - Book exactly at release (8 weeks ahead, 10:00 CET)
- **Van Gogh Museum** - Book 2-3 days ahead minimum
- **Rijksmuseum** - Book 1-2 days ahead

### Save Money

| Option | Cost | Includes |
|--------|------|----------|
| **I amsterdam City Card** | EUR 60 (24h) to EUR 115 (96h) | Most museums + transport |
| **Museumkaart** | EUR 70/year | All Dutch museums (residents only) |
| **Student/youth** | Various | Most museums have discounts |
| **First Friday** | Free | Some museums free first Friday evening |

### Best Times to Visit

| Attraction | Best Time | Avoid |
|------------|-----------|-------|
| Rijksmuseum | Opening (9:00) or after 16:00 | Weekend afternoons |
| Van Gogh | Opening or evening slots | Weekend midday |
| Anne Frank | Evening slots | All times are crowded |
| Canals walk | Early morning or golden hour | Mid-afternoon heat |

---

##  Self-Guided Walking Routes

### Classic Amsterdam Walk (3 hours)

1. **Centraal Station** - Start point
2. **Damrak** -> **Dam Square** (10 min)
3. **Royal Palace** exterior
4. **Kalverstraat** shopping street
5. **Begijnhof** - Hidden courtyard (enter from Spui)
6. **Spui** - Square with bookstalls
7. **Flower Market (Bloemenmarkt)**
8. **Rembrandtplein**
9. **Along Amstel river** to **Magere Brug**
10. **Waterlooplein** (flea market)
11. **Nieuwmarkt** (back to center)

### Jordaan & Canal Belt Walk (2 hours)

1. Start at **Westerkerk** (Anne Frank area)
2. **Prinsengracht** canal walk
3. **9 Straatjes** (Nine Streets) - boutiques
4. **Keizersgracht** cross
5. **Herengracht** - Golden Bend (grand houses)
6. **Noordermarkt** (market on Saturday)
7. **Lindengracht** (market on Saturday)
8. **Haarlemmerstraat** - trendy shops
9. End at **Centraal Station**

---

##  Museum Deep Dives

### Rijksmuseum

**Must-See Works:**
- The Night Watch (Rembrandt)
- The Milkmaid (Vermeer)
- The Jewish Bride (Rembrandt)
- Self-Portrait (Van Gogh - yes, they have one)
- Delftware collection

**Tips:**
- Free cloakroom
- Garden is free (nice cafe)
- Audio guide included with ticket
- Restaurant has good views

### Van Gogh Museum

**Must-See Works:**
- The Bedroom
- Sunflowers
- Almond Blossom
- Self-Portraits series
- The Potato Eaters

**Tips:**
- Timed entry required
- Audio guide excellent
- Ground floor cafe
- Shop on ground floor (no re-entry)

### Anne Frank House

**What to Expect:**
- The actual hiding place (achterhuis)
- Anne's original diary pages
- Deeply moving, heavy atmosphere
- No photos inside

**Tips:**
- Book months ahead
- Allow processing time after
- Not recommended for young children

---

##  Free Activities

### Parks

| Park | Best For |
|------|----------|
| **Vondelpark** | People-watching, picnics |
| **Westerpark** | Events, creative spaces |
| **Oosterpark** | Local atmosphere |
| **Amsterdamse Bos** | Nature, escape city |
| **Flevopark** | Quiet, swimming |

### Markets (Free to Browse)

| Market | Days | Location |
|--------|------|----------|
| Albert Cuyp | Mon-Sat | De Pijp |
| Dappermarkt | Mon-Sat | Oost |
| Noordermarkt | Sat (farmers), Mon (flea) | Jordaan |
| Waterlooplein | Mon-Sat | Centrum |
| IJ-Hallen | Monthly | Noord |

### Free Museums

- **Schuttersgalerij** (Civic Guard Gallery)
- **OBA Central Library** (views from top floor)
- **Museum gardens** (Rijksmuseum, others)
- **Gassan Diamonds** (sales pitch but free)

---

##  Seasonal Considerations

### Spring (March-May)

- Tulip season (mid-April peak)
- Keukenhof day trip essential
- King's Day (April 27) - city-wide party
- Mild weather, fewer crowds before April

### Summer (June-August)

- Peak tourist season
- Best weather (18-25C)
- Outdoor festivals, terraces
- Very crowded, book everything early

### Fall (September-November)

- Fewer tourists
- Amsterdam Dance Event (October)
- Colorful leaves
- More rain

### Winter (December-February)

- Low season, fewest crowds
- Amsterdam Light Festival (Dec-Jan)
- Ice skating (if cold enough)
- Museums easier to access

---

##  Local Tips

1. **Skip the boat tours, rent your own** - Electric boat rentals from Mokumboot, Boaty
2. **Best views are free** - OBA library rooftop, NEMO rooftop (free), ferry to Noord
3. **Rent a bike** - See more than any tour
4. **Markets over shops** - Better prices, more authentic
5. **Avoid Leidseplein restaurants** - Tourist prices, mediocre food
6. **Jordaan Sunday morning** - Quiet, peaceful, locals only
7. **Golden hour canals** - Best photos at sunset
8. **Check for events** - Many museums do late-night openings

---

*Last updated: February 2026*
