# Netherlands Visa Guide 2025-2026

> Complete guide to Dutch visa options: Highly Skilled Migrant, 30% Ruling, Startup Visa, and more.

---

##  Visa Types Overview

| Visa Type | Duration | Sponsor Required | Min. Requirement | Processing |
|-----------|----------|------------------|------------------|------------|
| **Highly Skilled Migrant (HSM)** | Up to 5 years | Yes (Employer) | Salary threshold | 2-4 weeks |
| **EU Blue Card** | 4 years | Yes (Employer) | Higher salary threshold | 2-4 weeks |
| **Startup Visa** | 1 year | Yes (Facilitator) | Innovative startup | 8-12 weeks |
| **Self-Employment** | 2 years | No | Points system | 8-12 weeks |
| **Orientation Year (Zoekjaar)** | 1 year | No | Recent graduate | 4-8 weeks |
| **Intra-Company Transfer (ICT)** | 3 years | Yes (Company) | Existing employee | 2-4 weeks |
| **European** | Indefinite | No | EU/EEA/Swiss citizen | Registration only |

---

##  Highly Skilled Migrant (Kennismigrant) - Most Common

### Overview

The primary work visa for skilled professionals. Employer must be IND-recognized sponsor.

**Duration:** Up to 5 years (tied to employment contract)

### Salary Thresholds (2026)

| Category | Monthly Gross | Annual Gross |
|----------|---------------|--------------|
| **30 years and older** | EUR 5,688 | EUR 68,256 |
| **Under 30 years** | EUR 4,171 | EUR 50,052 |
| **Scientific researcher** | EUR 3,495 | EUR 41,940 |
| **Medical specialist/resident** | No threshold | - |
| **Recent graduate (within 3 years)** | EUR 4,171 | EUR 50,052 |

*Thresholds adjust annually (usually +2-4%)*

### Requirements

| Requirement | Details |
|-------------|---------|
| Salary | Must meet threshold for category |
| Employer | IND-recognized sponsor |
| Contract | Valid employment contract |
| Passport | Valid throughout stay |
| No criminal record | Clean history |
| Health | No TB certificate needed for most nationalities |

### Recognition as IND Sponsor

Your employer must be on the IND's recognized sponsor list. Most large companies already are. New/small companies:
- Application fee: ~EUR 3,200
- Processing: 4-8 weeks
- Requirements: KvK registration, valid business, sufficient finances

### Cost Breakdown

| Component | Cost | Paid By |
|-----------|------|---------|
| MVV (entry visa) | EUR 207 | Usually employer |
| Residence permit | EUR 350 | Usually employer |
| **Total** | **EUR 557** | **Usually employer** |

### Process & Timeline

| Step | Timeline | Notes |
|------|----------|-------|
| Job offer | - | Start |
| Employer applies to IND | Day 1 | Via IND portal |
| IND processing | 2-4 weeks | Usually fast |
| MVV issued (if needed) | 1-2 weeks | Pick up at embassy |
| Entry to Netherlands | - | Within 3 months of MVV |
| Residence permit pickup | 1-2 weeks | At IND |
| BSN registration | 1-2 weeks | At gemeente |
| **Total** | **6-12 weeks** | |

### MVV Requirement

**MVV needed:** Most non-EU citizens
**MVV not needed:** EU/EEA, Switzerland, USA, UK, Canada, Australia, New Zealand, Japan, South Korea, and some others

---

##  30% Ruling (Belastingregeling) - Critical Tax Benefit

### Overview

Tax benefit for qualifying highly skilled migrants: 30% of salary is tax-free (treated as expense reimbursement).

### Changes (2024-2026 Transition)

**For arrivals from January 2024:**
| Period | Tax-Free Percentage |
|--------|---------------------|
| Months 1-20 | 30% |
| Months 21-40 | 20% |
| Months 41-60 | 10% |

**For arrivals before January 2024:**
- May retain full 30% for 5 years (grandfathered)
- Check specific ruling on your approval

### Requirements

| Requirement | Details |
|-------------|---------|
| Recruited from abroad | Lived 150+ km from Dutch border for 16 of 24 months before arrival |
| Specific expertise | Not readily available in Dutch labor market |
| Salary threshold | Same as HSM thresholds + 30% gross-up |
| Employed by NL company | Dutch payroll |
| Applied within 4 months | Of starting employment |

### Salary Thresholds for 30% Ruling (2026)

| Category | Minimum Taxable Salary |
|----------|------------------------|
| General | EUR 46,660 |
| Under 30 with Master's | EUR 35,468 |
| Scientific researchers | EUR 35,468 |

### Value Calculation

| Annual Gross Salary | Annual Tax Savings (Year 1-20) | 5-Year Total (New Rules) |
|--------------------|-------------------------------|--------------------------|
| EUR 60,000 | ~EUR 7,200 | ~EUR 25,000 |
| EUR 80,000 | ~EUR 10,000 | ~EUR 35,000 |
| EUR 100,000 | ~EUR 12,500 | ~EUR 45,000 |
| EUR 120,000 | ~EUR 15,000 | ~EUR 55,000 |

*Approximate - actual depends on your specific tax situation*

### Additional Benefits

- **Driving license:** Can exchange foreign license without test (first 6 months)
- **Box 3 taxation:** Option to be treated as "partial non-resident" for wealth tax
- **Penalty-free departure:** No claw-back if you leave Netherlands

### Application Process

1. Employer applies with first payroll or shortly after
2. Tax authority (Belastingdienst) processes (8-12 weeks)
3. Retroactive if applied within 4 months
4. Applied through monthly payroll once approved

---

##  Startup Visa

### Overview

1-year visa to develop an innovative startup in the Netherlands.

**Duration:** 1 year (then convert to self-employment or HSM)

### Requirements

| Requirement | Details |
|-------------|---------|
| Facilitator | Must have approved Dutch facilitator |
| Innovation | Product/service must be innovative |
| Business plan | Detailed plan required |
| Finances | EUR 14,200 (annually) to support yourself |
| Registration | Register with KvK |

### Approved Facilitators

~35 approved facilitators including:
- Rockstart
- Startupbootcamp
- YES!Delft
- HighTechXL
- Spaces (incubator)

*Full list at IND website*

### Cost & Timeline

| Item | Cost |
|------|------|
| MVV | EUR 207 |
| Residence permit | EUR 350 |
| Facilitator fee | EUR 0-5,000 (varies) |
| **Total** | **EUR 557-5,500** |

**Timeline:** 8-12 weeks

### After Startup Visa

Options after 1 year:
1. **Self-employment visa** - If business is viable
2. **Highly Skilled Migrant** - If you hire yourself at threshold salary
3. **Investor/entrepreneur** - Other business pathways
4. **Return home** - If startup failed

---

##  EU Blue Card

### Overview

EU-wide work permit for highly qualified workers. More portable than national HSM.

### Salary Threshold (2026)

| Category | Monthly Gross | Annual Gross |
|----------|---------------|--------------|
| Standard | EUR 6,245 | EUR 74,940 |
| Shortage occupation | EUR 4,996 | EUR 59,952 |

*Higher than HSM but more EU mobility*

### Benefits Over HSM

- After 18 months, can move to other EU countries more easily
- Family members can work immediately
- Path to long-term EU residence

### When to Choose Blue Card

 **Choose Blue Card if:**
- Planning to work in multiple EU countries
- Want maximum EU mobility
- Salary exceeds Blue Card threshold anyway

 **Choose HSM if:**
- Salary below Blue Card threshold
- Planning to stay only in Netherlands
- Want faster processing

---

##  Orientation Year (Zoekjaar)

### Overview

1-year visa for recent graduates to find work or start a business in Netherlands.

### Eligibility

| Category | Requirement |
|----------|-------------|
| Dutch graduates | Within 3 years of graduation from Dutch university |
| Top-200 graduates | Within 3 years of Bachelor's/Master's from top-200 university |
| PhD researchers | Within 3 years of PhD from Dutch institution |
| Scientific researchers | Previously worked in NL as researcher |

### Cost

- Application fee: ~EUR 350
- No salary requirement
- Can work without restrictions during the year

### After Orientation Year

Options to stay:
1. Find HSM-qualifying job
2. Start a business (self-employment visa)
3. Start a startup (startup visa)
4. Leave if no path found

---

##  Self-Employment Visa

### Overview

For entrepreneurs wanting to run their own business in the Netherlands.

### Points System

Must score 90+ points across categories:
- Personal experience
- Business plan
- Value added to Netherlands

### Assessment Criteria

| Factor | Points Available |
|--------|------------------|
| Education | 0-35 |
| Experience | 0-35 |
| Business plan | 0-30 |
| Added value | 0-25 |

**Minimum needed:** 90 points total

### Not Recommended Because

- Very difficult to qualify without existing Dutch ties
- Points system is subjective
- Rejection rate high
- HSM or Startup visa usually better paths

---

##  Family Reunification

### For HSM Holders

**Spouse/Partner:**
- Can accompany from day 1
- Full work rights (no permit needed)
- Same residence validity as main permit

**Children (under 18):**
- Can accompany
- School enrollment required
- No work restrictions (if appropriate age)

### Costs

| Family Member | Application Cost |
|---------------|------------------|
| Spouse/partner | ~EUR 200 |
| Child | ~EUR 70 |

### Timeline

Can be processed simultaneously with main applicant (add 1-2 weeks)

---

##  Processing Times Comparison

| Visa Type | Standard | Fast-Track | Notes |
|-----------|----------|------------|-------|
| HSM | 2-4 weeks | 2 weeks | Recognized sponsors |
| Blue Card | 3-6 weeks | - | More documentation |
| Startup | 8-12 weeks | - | Facilitator dependent |
| Self-employment | 8-16 weeks | - | Complex assessment |
| Orientation Year | 4-8 weeks | - | Straightforward |
| Family | 2-4 weeks | - | With main application |

---

##  Changing Status

### HSM to Another Employer

- New employer must be recognized sponsor
- New application required (but faster since you're already here)
- Grace period: 3 months to find new job

### HSM to Self-Employment

- Apply for self-employment permit before HSM expires
- Must meet points requirements
- Consider startup visa as alternative

### To Permanent Residence

| Requirement | Details |
|-------------|---------|
| Time | 5 years continuous residence |
| Income | Sufficient (roughly HSM levels) |
| Integration | Civic integration exam (A2 Dutch) or diploma |
| No criminal record | Clean history |

### To Dutch Citizenship

| Requirement | Details |
|-------------|---------|
| Time | 5 years continuous residence |
| Integration | B1 Dutch language test required |
| Renunciation | Usually must give up other citizenship |
| Oath | Naturalization ceremony |

---

##  Decision Matrix

### For Employees

| Situation | Best Visa |
|-----------|-----------|
| Job offer from Dutch company | **HSM** |
| High salary (EUR 75k+) + EU mobility wanted | **Blue Card** |
| Recent top-200 graduate, no job yet | **Orientation Year** |
| Researcher position | **HSM (researcher category)** |

### For Entrepreneurs

| Situation | Best Visa |
|-----------|-----------|
| Tech startup, need funding | **Startup Visa** |
| Established business, relocating | **Self-Employment** (difficult) |
| Just graduated, want to start business | **Orientation Year** -> Startup |
| Can pay yourself HSM salary | **Start BV + HSM** (own company) |

---

##  Key Takeaways

1. **HSM is the standard path** - Fast, employer-sponsored, most benefits
2. **30% ruling is valuable** - Even with changes, significant tax savings
3. **Salary thresholds are strict** - No exceptions below minimum
4. **EU citizens just register** - No visa process needed
5. **Processing is fast** - Usually 2-4 weeks for HSM
6. **Family comes free** - Partners can work immediately
7. **Apply 30% ruling fast** - Within 4 months of arrival

---

*Last updated: February 2026*
*Sources: IND.nl, Belastingdienst, Government.nl*
