# Amsterdam Transport Guide 2025-2026

> Getting around the bike capital of the world: cycling, trams, metro, trains, and why you don't need a car.

---

## Overview

Amsterdam is Europe's most bike-friendly city, with excellent public transport as backup. Most residents don't own cars.

### Transport Mode Share

| Mode | Share |
|------|-------|
| **Cycling** | 44% |
| **Public transport** | 20% |
| **Walking** | 16% |
| **Car** | 17% |
| **Other** | 3% |

---

##  Cycling - The Amsterdam Way

### Why Cycling is Essential

- **880,000+ bikes** for 900,000 residents
- **400+ km** of dedicated bike paths
- **Fastest mode** for trips under 7km
- **Free** (after initial bike purchase)
- **Cultural norm** - not cycling is the exception

### Getting a Bike

| Option | Cost | Best For |
|--------|------|----------|
| Used bike (Marktplaats) | EUR 100-300 | Budget option |
| Used bike (shop) | EUR 200-500 | Quality guaranteed |
| New city bike | EUR 400-1,000 | Long-term |
| New e-bike | EUR 1,500-4,000 | Hills/distance |
| Swapfiets (subscription) | EUR 20/month | Flexibility |
| OV-fiets (rental) | EUR 4.55/24h | Occasional use |

### Bike Types

| Type | Best For | Price Range |
|------|----------|-------------|
| **Omafiets** (granny bike) | Most people | EUR 150-400 |
| **Stadsfiets** (city bike) | Commuters | EUR 300-700 |
| **Bakfiets** (cargo) | Families | EUR 1,500-5,000 |
| **E-bike** | Long distances | EUR 1,500-4,000 |

### Essential Gear

| Item | Cost | Why Essential |
|------|------|---------------|
| U-lock + chain lock | EUR 60-120 | TWO locks mandatory |
| Front + rear lights | EUR 20-50 | Legal requirement |
| Rain jacket | EUR 50-150 | Daily necessity |
| Rain pants | EUR 30-80 | Serious cyclists |
| Panniers/bags | EUR 30-100 | Carrying groceries |

### Bike Theft Reality

- **60,000-80,000 bikes** stolen annually in Amsterdam
- **Always use TWO locks** - one for frame, one for wheel
- Lock to fixed object, not just wheel
- Don't leave overnight in risky areas
- Consider bike insurance (EUR 5-15/month)
- Register bike serial number

### Cycling Rules

| Rule | Details |
|------|---------|
| Lights | Required after sunset |
| Phone use | Illegal while cycling (EUR 140 fine) |
| Direction | Use bike paths, ride on right |
| Right-hand priority | Give way to traffic from right (unless marked) |
| Hand signals | Required when turning |
| Helmet | Not required (but smart for e-bikes) |
| Drunk cycling | Technically illegal, rarely enforced |

### Where to Park

- **Bike racks** - everywhere on streets
- **Fietsenstallingen** - dedicated parking garages (often free)
- **Centraal Station** - 11,000 spaces underground (free 24h)
- **Your apartment** - inside if possible

---

##  Public Transport

### GVB (Amsterdam Transport)

Operates trams, metro, buses, and ferries within Amsterdam.

### Trams

| Details | |
|---------|---|
| Lines | 14 lines |
| Hours | ~6:00-00:30 |
| Frequency | Every 5-10 minutes |
| Key lines | 4, 5, 14 (central), 26 (IJburg) |

### Metro

| Line | Route | Useful For |
|------|-------|------------|
| **50 (Isolatorlijn)** | Gein-Isolatorweg | Zuidoost, Amstelveen |
| **51 (Amstelveenlijn)** | Isolatorweg-Amstelveen | Amstelveen, Buitenveldert |
| **52 (North-South)** | Noord-Zuid | Noord, Centrum, Zuid |
| **53 (Gaasperplaslijn)** | Centraal-Gaasperplas | Zuidoost |
| **54 (Geinlijn)** | Centraal-Gein | Zuidoost |

### Buses

- Cover areas trams/metro don't reach
- Night buses (Nachtbus) after midnight
- Regional buses to surrounding areas

### Ferries

- **Free** ferries from behind Centraal Station
- To Noord (Buiksloterweg) - 5 minutes, 24/7
- To NDSM - 15 minutes
- Very reliable, enjoyable in good weather

### Tickets & Passes

| Product | Price | Best For |
|---------|-------|----------|
| Single trip (1 hour) | EUR 3.20 | Occasional use |
| Day pass | EUR 9.50 | Tourists |
| GVB Monthly (Amsterdam) | EUR 99 | Daily commuters |
| Anonymous OV-chipkaart | EUR 7.50 (card) + EUR 3.20/trip | Occasional users |
| Personal OV-chipkaart | EUR 7.50 (card) + subscriptions | Regular users |

### OV-chipkaart

**The essential card for all Dutch public transport:**

1. **Anonymous** (green/yellow) - Buy at stations, load credit
2. **Personal** (blue) - Order online, links to subscriptions

**How it works:**
- Check in (scan) when boarding
- Check out (scan) when leaving
- Minimum balance: EUR 4 (GVB) to EUR 20 (trains)

---

##  NS Trains (National Rail)

### For Regional/National Travel

| Destination | From Centraal | Price (one-way) |
|-------------|---------------|-----------------|
| Schiphol Airport | 15 min | EUR 5.50 |
| Utrecht | 27 min | EUR 10 |
| Rotterdam | 40 min | EUR 17 |
| The Hague | 50 min | EUR 14 |
| Eindhoven | 1h 20m | EUR 25 |

### Subscriptions

| Product | Cost | Benefit |
|---------|------|---------|
| **Dal Voordeel** | EUR 5.40/month | 40% off outside peak |
| **Altijd Voordeel** | EUR 29/month | 40% off always |
| **Weekend Voordeel** | EUR 3.40/month | 40% off weekends |
| **NS Flex** | EUR 40/month | 50% off + no card needed |
| **Traject Vrij** | Variable | Unlimited specific route |

### Tips

- Peak hours: 6:30-9:00 and 16:00-18:30 weekdays
- Dal Voordeel is excellent value for most
- Book international trains early via NS International

---

##  Driving & Car Ownership

### Why Most Don't Own Cars

| Factor | Reality |
|--------|---------|
| Parking permits | Waitlists up to years; EUR 500-600/year |
| Street parking | EUR 5-8/hour in center |
| Traffic | Congested, not faster than bike |
| Costs | Insurance, tax, fuel, parking |
| Bike culture | Everything is faster by bike |

### If You Need a Car

| Expense | Annual Cost |
|---------|-------------|
| Insurance | EUR 500-1,200 |
| Road tax | EUR 300-600 |
| Parking permit (if available) | EUR 400-600 |
| Maintenance | EUR 500-1,000 |
| Fuel | EUR 2/liter x usage |

### Car Sharing Options

| Service | Price | Best For |
|---------|-------|----------|
| **Greenwheels** | EUR 4/hour + EUR 0.27/km | Quick errands |
| **MyWheels** | EUR 3-6/hour + km | Local trips |
| **Sixt Share** | EUR 0.29/min | Short trips |
| **Snappcar** | P2P pricing | Longer rentals |

### Parking

| Type | Cost |
|------|------|
| Street (center) | EUR 5-8/hour |
| Street (outer) | EUR 2-4/hour |
| P+R (Park & Ride) | EUR 1-8/24h |
| Garages | EUR 3-5/hour |

**P+R stations** - Park outside, take transit in:
- P+R Sloterdijk
- P+R Zeeburg
- P+R Arena (Zuidoost)
- P+R Noord

---

##  Schiphol Airport

### Getting There

| Method | Time | Cost |
|--------|------|------|
| **Train** | 15-20 min | EUR 5.50 |
| **Taxi** | 25-40 min | EUR 40-60 |
| **Uber** | 25-40 min | EUR 30-50 |
| **Bus 397** | 30-40 min | EUR 6.50 |

**Recommendation:** Train is fastest and cheapest.

### Airport Tips

- Trains run 24/7 (reduced frequency at night)
- Check in online, arrive 2h before EU flights
- Schiphol is huge - allow time for walking
- Lounges bookable via Priority Pass or airline status

---

##  Taxis & Ride-Hailing

### Taxi Rates

| Component | Rate |
|-----------|------|
| Base fare | EUR 4.15 |
| Per km | EUR 3.00 |
| Per hour (waiting) | EUR 40 |

### Apps

| App | Coverage | Notes |
|-----|----------|-------|
| **Uber** | Good | Usually cheapest |
| **Bolt** | Good | Competitive |
| **TCA** | Excellent | Local, reliable |
| **Taxi.eu** | Good | European network |

### When to Use

- Late night when transit stops
- Heavy luggage
- Rain when you don't have bike
- Groups of 3+ (cost-effective)

---

##  Scooters & Alternatives

### E-Scooter Sharing

| Service | Price | Notes |
|---------|-------|-------|
| **Felyx** (e-mopeds) | EUR 0.30/min | Faster, requires license |
| **Check** (e-mopeds) | EUR 0.29/min | Similar to Felyx |
| **Tier/Dott** (kick scooters) | Banned in Amsterdam | Not available |

**Note:** Electric kick scooters are **banned** on public roads in Netherlands.

### Electric Mopeds (Snorfiets)

- Popular for commutes >5km
- Can use bike paths (blue plate, max 25km/h)
- Sharing services available

---

##  Essential Apps

| App | Purpose |
|-----|---------|
| **9292** | All Dutch public transport planning |
| **NS** | Train tickets and planning |
| **GVB** | Amsterdam transport info |
| **Google Maps** | Cycling + transit routes |
| **Swapfiets** | Bike subscription |
| **Uber/Bolt** | Ride-hailing |
| **Greenwheels** | Car sharing |

---

##  Typical Commute Times (by Bike)

| From -> To | Time |
|-----------|------|
| Jordaan -> Centrum | 5 min |
| De Pijp -> Centrum | 10 min |
| Oud-West -> Centrum | 10 min |
| Oost -> Centrum | 15 min |
| Noord -> Centrum | 15 min + ferry |
| Amstelveen -> Centrum | 30 min |
| IJburg -> Centrum | 25 min |

---

##  Transport Tips

1. **Get a bike immediately** - First priority upon arrival
2. **Two locks, always** - Frame + wheel
3. **OV-chipkaart** - Get one for backup transport
4. **Dal Voordeel** - Worth it for any train travel
5. **Ferries are free** - Use them to explore Noord
6. **Avoid taxis for short trips** - Usually slower than bike
7. **P+R for visitors with cars** - Don't drive into center
8. **Night buses exist** - Check 9292 for routes
9. **Bike lights are mandatory** - Police do ticket
10. **Rain gear always** - Weather changes quickly

---

##  Common Mistakes

1. **Taking taxis everywhere** - Expensive, often slower
2. **Not locking bike properly** - Guaranteed theft
3. **Driving into center** - Parking nightmare, congestion
4. **Forgetting to check out** - Full fare charged
5. **Peak train travel without subscription** - Very expensive
6. **Using umbrella while cycling** - Wind makes it dangerous; use rain gear
7. **Walking everywhere** - Much slower than biking
8. **Taking metro for short distances** - Bike is faster

---

*Last updated: February 2026*
*Sources: GVB, NS, 9292, CBS Statistics Netherlands*
