# Amsterdam Tech Scene Guide 2025-2026

> Comprehensive guide to working in tech in Amsterdam: salaries, companies, startup ecosystem, and career paths.

---

##  Tech Salaries in Amsterdam (2025-2026)

### Software Engineering

| Role | Annual Gross (EUR) | Annual Net* | Equivalent USD |
|------|-------------------|-------------|----------------|
| Junior (0-2 yrs) | EUR 40,000-55,000 | EUR 32,000-42,000 | $44K-61K |
| Mid-Level (3-5 yrs) | EUR 55,000-80,000 | EUR 42,000-56,000 | $61K-88K |
| Senior (5-8 yrs) | EUR 80,000-110,000 | EUR 56,000-72,000 | $88K-121K |
| Staff/Principal (8+ yrs) | EUR 100,000-150,000 | EUR 68,000-92,000 | $110K-165K |
| Engineering Manager | EUR 110,000-150,000 | EUR 72,000-92,000 | $121K-165K |

**Median Senior SWE:** ~EUR 95,000 gross (~$105K USD)

*Net assumes single, no 30% ruling. With 30% ruling, add ~15-20% to net.

### Data & AI/ML

| Role | Annual Gross (EUR) |
|------|-------------------|
| Data Analyst | EUR 45,000-70,000 |
| Data Engineer | EUR 60,000-95,000 |
| Data Scientist (Mid) | EUR 65,000-95,000 |
| Senior Data Scientist | EUR 85,000-120,000 |
| ML Engineer | EUR 75,000-120,000 |
| AI/ML Lead | EUR 100,000-150,000 |

### Other Tech Roles

| Role | Annual Range (EUR) |
|------|-------------------|
| Product Manager | EUR 65,000-120,000 |
| DevOps/SRE | EUR 65,000-110,000 |
| Cloud Architect | EUR 90,000-140,000 |
| Security Engineer | EUR 70,000-110,000 |
| QA Engineer | EUR 45,000-75,000 |
| UX Designer | EUR 50,000-85,000 |
| Tech Lead | EUR 90,000-130,000 |
| CTO/VP Engineering | EUR 150,000-250,000+ |

### Real Salary Examples (2025-2026)

From industry data:
- **Booking.com - Senior SWE:** EUR 90K-120K base + 10-20% bonus
- **Adyen - Senior SWE:** EUR 100K-130K base + equity + bonus
- **Optiver - Quant Developer:** EUR 120K-180K+ base + substantial bonus
- **MessageBird - Senior SWE:** EUR 80K-100K + equity
- **Picnic - Senior SWE:** EUR 75K-95K
- **Mollie - Senior SWE:** EUR 85K-110K + equity

### Salary vs Cost of Living

| Expense | Monthly Cost (EUR) |
|---------|-------------------|
| Rent (1BR, center) | EUR 1,800-2,500 |
| Rent (1BR, outside) | EUR 1,400-1,800 |
| Utilities | EUR 150-250 |
| Health insurance | EUR 140-180 |
| Groceries | EUR 250-400 |
| Transport | EUR 50-100 (bike) / EUR 100 (GVB) |
| Dining/Entertainment | EUR 300-600 |
| **Total (comfortable)** | **EUR 3,000-4,500** |

**Recommendation:** Target salary of EUR 70K+/year for comfortable single living; EUR 120K+ for family.

---

##  Major Tech Companies in Amsterdam

### Dutch Tech Giants

| Company | Employees | Focus | Notable For |
|---------|-----------|-------|-------------|
| **Booking.com** | 6,000+ (NL) | Travel | Amsterdam HQ, massive eng team |
| **Adyen** | 2,500+ | Payments | Dutch unicorn, high salaries |
| **Optiver** | 1,500+ | Trading | Quant focus, top compensation |
| **Picnic** | 1,000+ | Grocery delivery | Tech-driven operations |
| **Mollie** | 800+ | Payments | Growing fast, startup feel |
| **MessageBird** | 500+ | Communications | B2B comms platform |
| **TomTom** | 3,500+ | Navigation/Maps | Automotive tech |
| **bol.com** | 2,500+ | E-commerce | Dutch Amazon |

### Global Tech in Amsterdam

| Company | Presence | Focus |
|---------|----------|-------|
| **Uber** | EU HQ | Rides, Eats, Freight |
| **Netflix** | EMEA HQ | Streaming |
| **Tesla** | EU HQ | Automotive |
| **Salesforce** | Office | Enterprise software |
| **Microsoft** | Office | Cloud, enterprise |
| **Google** | Small office | Sales, cloud |
| **Meta** | Small office | Mostly policy |
| **Databricks** | Engineering hub | Data platform |
| **Elastic** | Distributed | Search |
| **GitLab** | Remote-first | DevOps |

### Fintech & Payments

| Company | Type | Focus |
|---------|------|-------|
| **Adyen** | Payments | Global payment processing |
| **Mollie** | Payments | European payment gateway |
| **Bunq** | Neobank | Mobile banking |
| **ABN AMRO** | Bank | Digital transformation |
| **ING** | Bank | Tech-forward banking |
| **Flow Traders** | Trading | High-frequency trading |
| **IMC** | Trading | Market making |
| **Optiver** | Trading | Options trading |
| **Bux** | Fintech | Investment app |

### Travel & Hospitality Tech

| Company | Focus |
|---------|-------|
| **Booking.com** | Accommodation, travel |
| **TravelPerk** | Business travel |
| **Mews** | Hotel management |
| **Hotelchamp** | Hotel conversion |

---

##  Amsterdam Startup Ecosystem

### Key Statistics (2025-2026)

- **1,000+ active startups** in Amsterdam
- **EUR 2.5B+ annual VC investment** in Netherlands
- **4th largest European tech hub** (after London, Berlin, Paris)
- **200+ coworking spaces**

### Notable Recent Startups & Scale-ups

| Company | Stage | Focus |
|---------|-------|-------|
| **Remote** | Series C | HR/remote work |
| **Sendcloud** | Unicorn | Shipping |
| **Messagebird** | Unicorn | Communications |
| **Mollie** | Unicorn | Payments |
| **Bunq** | Scale-up | Banking |
| **Catawiki** | Scale-up | Auctions |
| **Picnic** | Scale-up | Grocery |
| **Miro** | Unicorn | Collaboration |

### Accelerators & Incubators

| Program | Focus | Key Benefits |
|---------|-------|--------------|
| **Rockstart** | Energy, AgriFood, Health | Investment, network |
| **Startupbootcamp** | Various tracks | Intensive 3-month program |
| **HighTechXL** | Deep tech | Eindhoven-based, hardware |
| **YES!Delft** | Tech startups | TU Delft connection |
| **ACE Incubator** | UvA students | University support |
| **Techleap.nl** | Government initiative | Ecosystem support |

### Top VCs Active in Amsterdam

| VC Firm | Stage | Notable |
|---------|-------|---------|
| **Northzone** | Series A-B | Nordic/EU focus |
| **Atomico** | Growth | Skype founders |
| **Accel** | All stages | Global reach |
| **Balderton** | Series A-C | European focus |
| **Keen Venture Partners** | Seed-A | Dutch-focused |
| **Peak Capital** | Seed-A | Local |
| **Newion** | Seed-A | Dutch early-stage |
| **SET Ventures** | Series A-B | Deep tech |

### Government Support

| Program | Type | Details |
|---------|------|---------|
| **WBSO** | R&D tax credit | Reduces wage tax on R&D |
| **Innovatiebox** | Tax benefit | 9% tax on IP income |
| **Startup visa** | Immigration | 1-year visa for founders |
| **STAK** | Investment facilitation | Startup legal structure |

---

##  Remote Work & Digital Nomads

### Remote Work Culture

Amsterdam is among Europe's most remote-friendly cities:
- Many companies offer hybrid (2-3 days office)
- Some fully remote (GitLab, Remote, etc.)
- Excellent coworking infrastructure
- Strong digital nomad community

### Working Arrangements

| Type | Prevalence |
|------|------------|
| Full office | ~20% |
| Hybrid (2-3 days) | ~60% |
| Remote-first | ~15% |
| Fully remote | ~5% |

### Coworking Spaces

| Space | Location | Price (Monthly) | Best For |
|-------|----------|-----------------|----------|
| **WeWork** | Multiple | EUR 400-800 | Corporate feel |
| **Spaces** | Multiple | EUR 350-600 | Premium, flexible |
| **B. Amsterdam** | Zuidoost | EUR 200-400 | Startup community |
| **TQ** | Centrum | EUR 300-500 | Tech/startup |
| **A Lab** | Noord | EUR 250-400 | Creative tech |
| **Mindspace** | Centrum | EUR 400-700 | Premium |

### For Digital Nomads

**Options:**
1. **Tourist visa (90 days)** - Can't legally work for Dutch clients
2. **Freelance visa** - Self-employment, difficult to obtain
3. **Startup visa** - If building a company
4. **EU passport** - Just register and work

**Practical advice:**
- Working remotely for non-Dutch employer in tourist status is grey area
- Many do it; technically requires registration if staying long
- Consider Portugal/Spain for formal digital nomad visas

---

##  Networking & Community

### Major Tech Events

| Event | When | Focus |
|-------|------|-------|
| **TNW Conference** | June | Europe's largest tech festival |
| **TechConnect** | Various | Industry networking |
| **Startup Amsterdam Week** | October | Startup ecosystem |
| **Amsterdam Tech Week** | October | Tech industry |
| **DevConf** | Various | Developer conference |

### Regular Meetups & Communities

| Community | Focus | Platform |
|-----------|-------|----------|
| **Amsterdam.rb** | Ruby | Meetup |
| **AmsterdamJS** | JavaScript | Meetup |
| **PyAmsterdam** | Python | Meetup |
| **DevOps Amsterdam** | DevOps | Meetup |
| **Women in Tech NL** | Diversity | Community |
| **Startup Grind Amsterdam** | Founders | Events |
| **Product Tank Amsterdam** | Product | Meetup |

### Online Communities

| Platform | Community |
|----------|-----------|
| **Slack** | Amsterdam Startups |
| **LinkedIn** | Amsterdam Tech Network |
| **Discord** | Various language-specific |
| **Twitter/X** | #AmsterdamTech |

---

##  Career Paths & Progression

### Typical Progression

| Level | Years Experience | Typical Salary |
|-------|------------------|----------------|
| Junior | 0-2 | EUR 40-55K |
| Mid | 2-5 | EUR 55-75K |
| Senior | 5-8 | EUR 75-110K |
| Staff/Lead | 8-12 | EUR 100-140K |
| Principal/Director | 12+ | EUR 140-200K |

### IC vs Management Track

| Track | Senior Level | Top Level |
|-------|--------------|-----------|
| **Individual Contributor** | Senior -> Staff -> Principal | Distinguished/Fellow |
| **Management** | Team Lead -> EM -> Director | VP/CTO |

### Switching to Management

| Factor | Netherlands Reality |
|--------|---------------------|
| Timing | Usually after Senior (5-8 years) |
| Salary impact | Initially similar, diverges at Director+ |
| Common path | Tech Lead -> Engineering Manager |
| Alternative | Stay IC, top out higher in trading firms |

---

##  Amsterdam vs Other Tech Hubs

### Salary Comparison (Senior SWE, Gross)

| City | Annual Salary | Take-Home % | Net Salary |
|------|---------------|-------------|------------|
| **Amsterdam** | EUR 95,000 | ~58% | EUR 55,000 |
| **Amsterdam (30% ruling)** | EUR 95,000 | ~70% | EUR 66,500 |
| **London** | GBP 90,000 | ~65% | GBP 58,500 |
| **Berlin** | EUR 85,000 | ~55% | EUR 47,000 |
| **Dublin** | EUR 90,000 | ~60% | EUR 54,000 |
| **Zurich** | CHF 140,000 | ~75% | CHF 105,000 |

### Ecosystem Comparison

| Factor | Amsterdam | London | Berlin | Dublin |
|--------|-----------|--------|--------|--------|
| **Jobs Volume** | Medium | Very High | High | Medium |
| **Startup Scene** | Strong | Very Strong | Very Strong | Growing |
| **Tax Efficiency** | Good (30% ruling) | Average | Good | Good |
| **Cost of Living** | High | Very High | Medium | High |
| **Quality of Life** | Very High | High | High | High |
| **English Sufficiency** | Excellent | Native | Good | Native |
| **Visa Ease** | Good | Medium | Good | Good |

### When to Choose Amsterdam

 **Choose Amsterdam if:**
- Quality of life matters (bike culture, work-life balance)
- Want 30% ruling tax benefit
- Fintech/payments interest
- English-only is fine (Dutch not required for work)
- Prefer smaller, focused community
- Value work-life balance

 **Consider elsewhere if:**
- Need maximum job options (London better)
- Startup founder wanting largest ecosystem (London/Berlin)
- Cost-sensitive (Berlin cheaper)
- Want mega-tech (FAANG) engineering (London, Dublin, Zurich)

---

##  Key Takeaways

1. **Salaries are solid** - EUR 80-120K+ for senior roles
2. **30% ruling is huge** - Can mean EUR 15-20K more net annually
3. **Booking.com & Adyen** - Largest employers, good training grounds
4. **Fintech/payments is hot** - Amsterdam's specialty
5. **Work-life balance** - Taken seriously, 40-hour weeks normal
6. **English is enough** - For work; Dutch helps socially
7. **Competition is moderate** - Less than London, more than Berlin
8. **Quality of life** - Main reason people choose Amsterdam

### Job Search Tips

1. **Use LinkedIn** - Primary channel for Dutch tech
2. **Apply directly** - Company career pages
3. **Recruiters** - Many tech-focused agencies
4. **Network** - Meetups and events help
5. **Timing** - Spring hiring peak (March-May)
6. **Visa mention** - Be upfront about needing sponsorship

### Negotiation Tips

- Know the 30% ruling before negotiating
- Total compensation = base + bonus + equity + pension
- Dutch employers generally offer fair first offers
- Negotiate on benefits if salary is firm (WFH, training budget, vacation)

---

*Last updated: February 2026*
*Sources: Levels.fyi, Glassdoor, LinkedIn, company data, community surveys*
