# Amsterdam Startup Ecosystem

> Starting, funding, and growing a startup in the Netherlands.

---

##  Ecosystem Overview

### Key Stats (2025-2026)

| Metric | Number |
|--------|--------|
| Active startups (Amsterdam) | ~1,000 |
| Annual VC investment (NL) | EUR 2.5B+ |
| Unicorns from NL | 10+ |
| European tech hub ranking | #4 |

### Notable Dutch Tech Companies

| Company | Status | Sector |
|---------|--------|--------|
| **Adyen** | Public (EUR 50B+) | Payments |
| **Booking.com** | Public | Travel |
| **Mollie** | Unicorn | Payments |
| **Messagebird** | Unicorn | Communications |
| **Picnic** | Scale-up | Grocery |
| **Bunq** | Scale-up | Banking |
| **Catawiki** | Scale-up | Auctions |
| **Miro** | Unicorn | Collaboration |

---

##  Starting a Startup

### Legal Structure

**BV** (Private Limited Company) is standard for startups:
- Limited liability
- Share issuance for investors
- Tax advantages at scale
- Required for most investors

### Initial Costs

| Item | Cost |
|------|------|
| BV incorporation | EUR 800-2,000 |
| KvK registration | EUR 75 |
| Initial legal | EUR 1,000-3,000 |
| Accounting setup | EUR 500-1,000 |
| **Total** | EUR 2,500-6,000 |

### Founder Considerations

| Factor | Dutch Reality |
|--------|---------------|
| **Co-founders** | Can easily set up with multiple |
| **Vesting** | Common, 4-year standard |
| **IP assignment** | Transfer to company |
| **Founder salary** | Lower early stage OK |

---

##  Funding Landscape

### Funding Stages

| Stage | Amount | Dutch Sources |
|-------|--------|---------------|
| **Pre-seed** | EUR 50K-500K | Angels, early VCs |
| **Seed** | EUR 500K-2M | Dutch VCs, international |
| **Series A** | EUR 2M-10M | Growth VCs |
| **Series B+** | EUR 10M+ | International VCs |

### Active VCs in Netherlands

| VC | Stage | Focus |
|----|-------|-------|
| **Keen Venture Partners** | Seed-A | Dutch-focused |
| **Peak Capital** | Seed-A | B2B, SaaS |
| **Newion** | Seed-A | Early-stage |
| **SET Ventures** | A-B | Sustainability |
| **Northzone** | A-B | European |
| **Atomico** | Growth | European |
| **Balderton** | A-C | European |
| **Accel** | All | Global |
| **Inkef Capital** | B+ | Growth |

### Angel Networks

| Network | Focus |
|---------|-------|
| **Leapfunder** | Platform for angels |
| **TIIN Capital** | Angel fund |
| **Maia Capital** | Female founders |
| **Side Capital** | Tech angels |

### Government Funding

| Program | Type | Amount |
|---------|------|--------|
| **Innovation Credit** | Loan | Up to EUR 10M |
| **WBSO** | R&D tax credit | Salary cost reduction |
| **Seed Capital** | Co-investment | Match angel/VC |
| **MIT** | SME grant | Various |
| **Horizon Europe** | EU grants | Various |

---

##  Accelerators & Incubators

### Amsterdam-Based

| Program | Focus | Duration |
|---------|-------|----------|
| **Rockstart** | Various tracks | 6 months |
| **Startupbootcamp** | Various tracks | 3 months |
| **ACE Incubator** | UvA startups | 1 year |
| **HighTechXL** | Deep tech | 6 months |
| **STARTUP VILLAGE** | Early stage | Ongoing |

### National Programs

| Program | Focus |
|---------|-------|
| **YES!Delft** | Tech (TU Delft) |
| **UtrechtInc** | Various |
| **Techleap.nl** | Ecosystem support |

### Government Support

| Initiative | Purpose |
|------------|---------|
| **StartupDelta** | National coordination |
| **Techleap.nl** | Ecosystem development |
| **RVO** | Innovation agency |

---

##  Startup Visa

### Overview

1-year visa to develop an innovative startup in Netherlands.

### Requirements

| Requirement | Details |
|-------------|---------|
| **Facilitator** | Approved Dutch facilitator |
| **Innovation** | Product/service must be new |
| **Business plan** | Detailed plan required |
| **Funds** | EUR 14,200/year to support yourself |

### Approved Facilitators

~35 approved organizations including:
- Rockstart
- Startupbootcamp
- YES!Delft
- HighTechXL
- Various others

### Process

| Step | Timeline |
|------|----------|
| Find facilitator | 1-3 months |
| Application | 8-12 weeks |
| Year 1 | Build, validate |
| After Year 1 | Convert to self-employment or BV/HSM |

### After Startup Visa

Options:
1. **Self-employment visa** - If business viable
2. **BV + HSM visa** - Pay yourself HSM salary
3. **Pivot** - New direction
4. **Return home** - If not working

---

##  Workspace Options

### Co-working

| Space | Location | Monthly |
|-------|----------|---------|
| **B. Amsterdam** | Zuidoost | EUR 200-400 |
| **TQ** | Centrum | EUR 300-500 |
| **A Lab** | Noord | EUR 250-400 |
| **WeWork** | Various | EUR 400-800 |
| **Spaces** | Various | EUR 350-600 |
| **Zoku** | Oost | EUR 400-600 |

### Incubator Space

Often included in accelerator programs:
- Subsidized rates
- Community
- Mentorship

### Dedicated Office

| Area | EUR /desk/month |
|------|--------------|
| Centrum | EUR 350-500 |
| Zuid | EUR 300-450 |
| Zuidoost | EUR 200-350 |
| Noord | EUR 200-300 |

---

##  Building a Team

### Hiring in NL

| Aspect | Reality |
|--------|---------|
| **Talent pool** | Good, competitive |
| **English** | Works for most roles |
| **Salaries** | See `tech.md` |
| **Employee protections** | Strong |
| **Flexibility** | Part-time common |

### Hiring Internationally

| Option | Process |
|--------|---------|
| **EU citizens** | Just hire |
| **Non-EU** | HSM visa (company must be recognized sponsor) |
| **Remote** | Possible but complex tax |

### Becoming IND Sponsor

| Requirement | Details |
|-------------|---------|
| **Application** | Online at IND |
| **Cost** | ~EUR 3,200 |
| **Time** | 4-8 weeks |
| **Requirements** | Valid business, financial stability |

---

##  Legal & Tax

### Key Considerations

| Area | Note |
|------|------|
| **Incorporation** | BV with standard articles |
| **Shareholder agreement** | Essential for co-founders |
| **IP assignment** | Transfer to company |
| **ESOP/options** | Possible but complex |
| **R&D (WBSO)** | Apply for tax credit |

### Innovatiebox

| Benefit | Details |
|---------|---------|
| Rate | 9% tax on qualifying IP income |
| Requirement | WBSO certification + patents |
| Value | Significant for IP-heavy companies |

### Startup Tax Advantages

| Advantage | Details |
|-----------|---------|
| **WBSO** | R&D salary tax credit |
| **Innovatiebox** | 9% tax on IP |
| **30% ruling** | For hired talent |
| **Startup stock options** | Favorable treatment |

---

##  Community & Networking

### Major Events

| Event | When | Type |
|-------|------|------|
| **TNW Conference** | June | Tech festival |
| **TechConnect** | Various | Networking |
| **Startup Amsterdam Week** | October | Ecosystem |
| **Demo days** | Quarterly | Pitch events |

### Regular Meetups

| Community | Focus |
|-----------|-------|
| **Startup Grind Amsterdam** | Founders |
| **Product Tank** | Product |
| **AmsterdamJS/Python/etc.** | Tech |
| **Women in Tech** | Diversity |

### Online Communities

| Platform | Community |
|----------|-----------|
| **Slack** | Amsterdam Startups |
| **LinkedIn** | Various groups |
| **Discord** | Tech communities |

---

##  Dutch Startup Strengths

### Advantages

| Factor | Why It Matters |
|--------|----------------|
| **English proficiency** | International from day 1 |
| **EU access** | 500M market |
| **Infrastructure** | Digital, physical |
| **Quality of life** | Attract talent |
| **Government support** | Various programs |
| **Stable economy** | Predictable |

### Strong Sectors

| Sector | Examples |
|--------|----------|
| **Fintech/Payments** | Adyen, Mollie, Bunq |
| **Travel** | Booking.com, TravelPerk |
| **E-commerce** | Bol.com, Picnic |
| **Agtech** | Strong in Netherlands |
| **Sustainability** | Growing sector |
| **Health tech** | Philips ecosystem |

---

##  Challenges

### Dutch Startup Realities

| Challenge | Reality |
|-----------|---------|
| **Smaller pool than US/UK** | Limited local market |
| **Conservative investors** | Less risk appetite |
| **Talent competition** | Big companies pay well |
| **Later stage funding** | Often go international |
| **Housing for team** | Amsterdam is expensive |

### Mitigations

| Challenge | Strategy |
|-----------|----------|
| Small market | Think EU from day 1 |
| Conservative VCs | Target international VCs |
| Talent | 30% ruling, quality of life |
| Late stage | International expansion |

---

##  Typical Path

### Year 1

| Activity | Details |
|----------|---------|
| Incorporate | BV setup |
| Build MVP | Product development |
| First customers | Validation |
| Pre-seed/seed | Angel or early VC |

### Year 2-3

| Activity | Details |
|----------|---------|
| Product-market fit | Iterate |
| Team building | 5-15 people |
| Seed/Series A | EUR 1-5M raise |
| EU expansion | Beyond NL |

### Year 3-5

| Activity | Details |
|----------|---------|
| Scale | 20-100 people |
| Series A/B | EUR 5-20M+ |
| International | US, UK expansion |

---

##  Resources

### Organizations

| Resource | Purpose |
|----------|---------|
| **Techleap.nl** | Ecosystem support |
| **RVO** | Government innovation |
| **KvK** | Business registration |
| **ACCESS** | Expat support |

### Must-Follow

| Who | Why |
|-----|-----|
| **Techleap** | Ecosystem news |
| **Silicon Canals** | Dutch startup news |
| **Sprout** | Dutch startup media |
| **The Next Web** | Amsterdam-based tech |

---

*Amsterdam offers a strong startup ecosystem with EU access, good talent, and supportive infrastructure. Think internationally from day one and leverage Dutch advantages.*
