# Amsterdam Safety & Laws Guide

> What you need to know about safety, legal matters, and staying out of trouble.

---

##  Overall Safety

### Amsterdam is Very Safe

| Safety Metric | Rating |
|---------------|--------|
| **Violent crime** | Very low |
| **Petty theft** | Moderate (tourists targeted) |
| **Women's safety** | Very high |
| **LGBTQ+ safety** | Very high |
| **Night safety** | High (most areas) |

### Common Sense Rules

1. Watch belongings in tourist areas
2. Don't leave bikes unlocked (ever)
3. Avoid dark alleys late at night
4. Don't buy drugs from street dealers
5. Beware of canal edges when drinking

---

##  Emergency Contacts

| Service | Number |
|---------|--------|
| **Emergency (fire, police, ambulance)** | 112 |
| **Police (non-emergency)** | 0900-8844 |
| **Tourist Police** | 0900-8844 |
| **Victim Support** | 0900-0101 |
| **Poison Control** | 088-7558000 |

---

##  Cannabis Laws

### Legal Status

| What | Legal Status |
|------|--------------|
| **Buying in coffeeshop** | Legal (18+) |
| **Possessing (up to 5g)** | Tolerated |
| **Smoking in coffeeshop** | Legal |
| **Smoking in public** | Illegal (fine) |
| **Growing (1-5 plants)** | Tolerated (grey area) |
| **Selling/dealing** | Illegal |
| **Driving under influence** | Illegal |

### Coffeeshop Rules

| Rule | Details |
|------|---------|
| Age | 18+ (ID required) |
| Purchase limit | 5 grams per transaction |
| Consumption | Inside coffeeshop only |
| Alcohol | Not sold in coffeeshops |
| Photography | Usually not allowed |
| Behavior | Be respectful, quiet |

### Where NOT to Smoke

- Streets and public spaces (EUR 100 fine)
- Parks (some allow, many don't)
- Hotels (unless specifically allowed)
- Public transport
- Near schools
- Most restaurants and bars

### Important Distinction

- **Coffee shop** (two words) = Normal cafe
- **Coffeeshop** (one word) = Cannabis shop

---

##  Other Substances

### Legal Status

| Substance | Status |
|-----------|--------|
| **Magic mushrooms** | Illegal (since 2008) |
| **Magic truffles** | Legal (sold in smart shops) |
| **Cocaine** | Illegal |
| **MDMA/Ecstasy** | Illegal |
| **Heroin** | Illegal |
| **LSD** | Illegal |
| **Ketamine** | Illegal |

### Important Warning

Despite Amsterdam's reputation:
- Hard drugs are **illegal** and carry serious penalties
- Street dealers sell dangerous substances
- Police do enforce drug laws
- Tourists are not exempt

---

##  Alcohol Laws

| Rule | Details |
|------|---------|
| Legal age | 18+ for all alcohol |
| Where to drink | Bars, restaurants, home |
| Public drinking | Banned in designated zones |
| Drunk & disorderly | Can be fined/arrested |
| Driving limit | 0.5% (0.2% new drivers) |
| DUI consequences | Heavy fines, license suspension |

### Public Drinking Zones

Check for "Alcoholverbod" signs in:
- Public transport
- Parks (varies)
- Some squares
- Near schools

---

##  Red Light District (De Wallen)

### Legal Status

Prostitution is **legal and regulated** in Netherlands.

### Rules for Visitors

| Rule | Details |
|------|---------|
| **Photography** | Forbidden - fines up to EUR 200 |
| **Filming** | Forbidden |
| **Harassment** | Not tolerated |
| **Respectful behavior** | Required |
| **Drugs outside** | Still illegal |

### Safety Tips

- Stay aware of surroundings
- Don't block windows
- Keep valuables secure
- Ignore street dealers
- Stick to lit areas at night

---

##  Cycling Laws

### Rules

| Rule | Fine |
|------|------|
| **Lights at night** | EUR 95 |
| **Phone while cycling** | EUR 140 |
| **Wrong direction** | EUR 95 |
| **Running red light** | EUR 95 |
| **No bell** | EUR 30 |
| **Drunk cycling** | Up to EUR 450 |

### Right of Way

- **Right-hand priority** - Traffic from right goes first (unless marked)
- **Trams always have priority**
- **Bikes often have priority over cars** (marked)
- **Pedestrians on zebra crossing** - You must stop

---

##  Photography Laws

### Generally Allowed

- Public spaces
- Buildings exteriors
- Street photography (people in public)
- Tourist attractions

### Not Allowed

- Red Light District (windows)
- Military installations
- People who object (remove if asked)
- Private property without permission
- Some museums (check signs)

---

##  Renting & Housing Laws

### Tenant Rights

Dutch law strongly protects tenants:

| Right | Details |
|-------|---------|
| **Rent control** | Some properties regulated |
| **Deposit max** | 2 months (some contracts) |
| **Eviction** | Very difficult for landlord |
| **Maintenance** | Landlord responsible |
| **Service costs** | Must be itemized |

### Common Scams

| Scam | Red Flag |
|------|----------|
| **Fake listings** | Too good to be true price |
| **Advance payment** | Before viewing |
| **Overseas landlord** | Can't show property |
| **No contract** | Informal agreement |

---

##  Employment Laws

### Worker Protections

| Protection | Details |
|------------|---------|
| **Minimum wage (2026)** | ~EUR 14/hour (21+) |
| **Working hours** | Max 60/week (avg 48) |
| **Vacation** | Min 4 weeks/year |
| **Sick leave** | 70-100% salary (2 years) |
| **Notice period** | 1-4 months depending on tenure |
| **Wrongful termination** | Strong protections |

### Discrimination

Protected characteristics:
- Race, nationality
- Religion
- Gender, sexual orientation
- Age, disability
- Political opinion

---

##  Digital Privacy

### GDPR Applies

- Companies must protect your data
- Right to access, delete data
- Cookie consent required
- Strict penalties for violations

### Government Surveillance

- Less than US/UK
- DigiD is tracked
- Camera surveillance in public areas
- Generally privacy-respecting culture

---

##  LGBTQ+ Rights

### Legal Status

| Right | Status |
|-------|--------|
| Same-sex marriage | Legal (first country, 2001) |
| Adoption | Legal |
| Anti-discrimination | Strong protections |
| Gender change | Legal (simplified 2014) |
| Social acceptance | Very high |

### LGBTQ+ Scene

- Reguliersdwarsstraat (main gay street)
- Amsterdam Pride (first August weekend)
- COC Amsterdam (community organization)
- Very visible and accepted

---

##  Legal System Notes

### Police Behavior

- Generally professional
- English widely spoken
- Less confrontational than US
- Fines often preferred over arrest

### If Arrested

1. **Right to lawyer** - Request one
2. **Right to interpreter** - If needed
3. **Right to contact embassy** - If non-Dutch
4. **Right to silence** - Don't self-incriminate

### Common Fines

| Offense | Fine |
|---------|------|
| Littering | EUR 140 |
| Urinating in public | EUR 140 |
| Cycling violation | EUR 30-140 |
| Cannabis in public | EUR 100 |
| Fare evasion | EUR 50 + fare |

---

##  Driving Laws

| Rule | Details |
|------|---------|
| Drive on | Right side |
| Speed limits | 30-50 (city), 100-130 (highway) |
| License | EU or exchange required |
| Insurance | Mandatory |
| Parking | Strictly enforced |

### Foreign License

- EU licenses valid
- Non-EU: Exchange within 6 months (30% ruling holders)
- Otherwise: Take Dutch test

---

##  Summary: Stay Out of Trouble

### Do

- Register properly (BSN, address)
- Get health insurance
- Follow cycling rules
- Respect the Red Light District
- Keep cannabis in coffeeshops

### Don't

- Buy drugs from street dealers
- Photograph Red Light District
- Leave bike unlocked
- Drive drunk or high
- Swim in canals (water quality)
- Jump barriers at stations

---

*Amsterdam is safe and welcoming, but respect local laws. The tolerant reputation doesn't mean anything goes.*
