# Moving to Amsterdam - Settling Guide

> Everything you need to know about becoming an Amsterdam resident.

---

##  First Steps Checklist

### Within First Week

- [ ] Register at gemeente (BSN number)
- [ ] Activate health insurance
- [ ] Open bank account
- [ ] Get SIM card / phone plan
- [ ] Get a bike

### Within First Month

- [ ] Register with huisarts (GP)
- [ ] Set up DigiD
- [ ] Get OV-chipkaart
- [ ] Complete IND appointment (if applicable)
- [ ] Explore neighborhoods
- [ ] Apply for 30% ruling (if eligible)

### Within First Three Months

- [ ] Complete any visa requirements
- [ ] Set up recurring bills
- [ ] Build local network
- [ ] Learn basic Dutch phrases

---

##  Housing

### The Reality

Amsterdam has the **tightest housing market in Netherlands**:
- Average 100+ applicants per listing
- Prices EUR 25-35/sqm in free sector
- Social housing: 10-15 year waitlist
- Moving fast is essential

### Housing Types

| Type | Description | Price Range |
|------|-------------|-------------|
| **Social housing** | Subsidized, regulated | <EUR 880/month |
| **Free sector rental** | Market rate | EUR 1,500-3,000+ |
| **Anti-kraak** | Property guardian | EUR 200-500 |
| **Room in shared house** | WG/studentenhuis | EUR 500-900 |
| **Buy apartment** | Purchase | EUR 400K-800K+ |

### Finding Housing

| Platform | Type |
|----------|------|
| **Pararius** | Free sector rentals |
| **Funda** | Sales + rentals |
| **Kamernet** | Rooms, short-term |
| **HousingAnywhere** | Expat-focused |
| **Facebook groups** | Direct from owners |

### What You Need

| Document | Purpose |
|----------|---------|
| Passport/ID | Identity |
| Work contract | Income proof |
| 3x salary rule | Must earn 3-4x rent |
| Bank statements | Financial stability |
| References | Previous landlord |

### Scam Warning Signs

- Landlord is "abroad" and can't show property
- Payment requested before viewing
- Price too good to be true
- Western Union or crypto payment
- No contract offered

---

##  BSN (Citizen Service Number)

### What It Is

Your Dutch social security number, required for:
- Working legally
- Health insurance
- Banking
- Taxes
- Everything official

### How to Get

1. **Book appointment** at gemeente Amsterdam
2. **Bring documents:**
   - Passport
   - Birth certificate (apostilled)
   - Rental contract
3. **Attend in person**
4. **Receive BSN** same day or by mail

### Timeline

- Appointments available within 1-2 weeks
- BSN issued immediately or within days
- Can start work pending BSN in some cases

---

##  Banking

### Main Options

| Bank | Type | Best For |
|------|------|----------|
| **ING** | Traditional | Full service |
| **ABN AMRO** | Traditional | Full service |
| **Rabobank** | Traditional | Full service |
| **bunq** | Digital | Fast setup |
| **N26** | Digital | EU-wide |
| **Revolut** | Digital | Multi-currency |

### Opening Account

**Requirements:**
- BSN number
- Passport/ID
- Proof of address
- Some banks need appointment

**Timeline:**
- Digital banks: Same day
- Traditional banks: 1-2 weeks

### Dutch Payment Culture

- **Debit cards (Maestro)** preferred everywhere
- **iDEAL** - Online payment standard
- **Tikkie** - Mobile payment app for splitting
- **Cash** - Decreasingly common

---

##  Phone & Internet

### Mobile Options

| Provider | Type | Price |
|----------|------|-------|
| **KPN** | Traditional | EUR 15-40/month |
| **Vodafone** | Traditional | EUR 15-35/month |
| **T-Mobile/Odido** | Traditional | EUR 15-35/month |
| **Simyo** | Budget | EUR 8-20/month |
| **Ben** | Budget | EUR 10-25/month |

### Home Internet

| Provider | Price | Notes |
|----------|-------|-------|
| **Ziggo** | EUR 40-70 | Cable, most common |
| **KPN** | EUR 40-65 | Fiber where available |
| **T-Mobile** | EUR 35-55 | Growing fiber network |

---

##  Health Insurance

### Mandatory System

**All residents must have basic health insurance (basiszorgverzekering).**

| Component | Cost | Coverage |
|-----------|------|----------|
| Basic insurance | EUR 140-170/month | GP, hospital, meds |
| Eigen risico (deductible) | EUR 385/year | First costs you pay |
| Aanvullend (supplementary) | EUR 20-100/month | Dental, physio, etc. |

### Major Insurers

- Zilveren Kruis
- CZ
- VGZ
- Menzis
- OHRA

### Important

- Must sign up within 4 months of arrival
- Compare on Independer.nl or Zorgwijzer.nl
- Can switch every January
- Zorgtoeslag (subsidy) available for low income

---

##  DigiD

### What It Is

Digital identity for accessing government services online:
- Taxes (Belastingdienst)
- Healthcare allowance
- Municipal services
- Pension overview

### How to Get

1. Apply at digid.nl
2. Receive activation code by mail (3-5 days)
3. Activate account
4. Optional: Set up app authentication

---

##  Getting a Bike

### First Priority

Seriously - get a bike within first week.

### Options

| Option | Cost | Notes |
|--------|------|-------|
| **Marktplaats** | EUR 100-300 | Used, private sellers |
| **Bike shops** | EUR 200-500 | Used, some warranty |
| **New bike** | EUR 400-1,000 | City bike |
| **Swapfiets** | EUR 20/month | Subscription |

### Essential Accessories

| Item | Cost | Why |
|------|------|-----|
| Two locks | EUR 60-100 | Theft prevention |
| Lights | EUR 20-40 | Legal requirement |
| Panniers | EUR 30-60 | Groceries |
| Rain gear | EUR 50-100 | Weather |

---

##  Learning Dutch

### Required for Integration?

| Situation | Dutch Required |
|-----------|----------------|
| HSM visa | Not required initially |
| Permanent residence | A2 level exam |
| Dutch citizenship | B1 level exam |
| Daily life | Helpful but not essential |

### Learning Options

| Option | Cost | Format |
|--------|------|--------|
| **Gemeente courses** | EUR 0-3,000 | In-person |
| **Private language school** | EUR 300-600/course | In-person |
| **Duolingo** | Free | App |
| **Dutch courses UvA/VU** | EUR 500-1,500 | Academic |
| **Private tutor** | EUR 30-50/hour | Personalized |

### Reality

- 95% of Amsterdam speaks English
- Dutch helps socially and professionally
- Not strictly necessary for work in tech/international
- Required for citizenship

---

##  Building Community

### Expat Networks

| Group | Type |
|-------|------|
| **Internations** | Global expat network |
| **Meetup.com** | Interest-based groups |
| **Facebook groups** | Various communities |
| **Bumble BFF** | Friendship app |
| **Sports clubs** | Social + activity |

### Making Dutch Friends

**The challenge:** Dutch have established social circles.

**Strategies:**
1. Join a sports club (vereniging)
2. Take Dutch classes (meet other learners + Dutch teachers)
3. Workplace connections
4. Neighborhood involvement
5. Parent networks (if applicable)

---

##  Important Documents to Bring

| Document | Use |
|----------|-----|
| Passport | ID, visa |
| Birth certificate (apostilled) | Registration |
| Marriage certificate (if applicable) | Registration |
| University degrees (apostilled) | 30% ruling, some jobs |
| Driver's license | Exchange for Dutch |
| Medical records | New doctor |
| Proof of no criminal record | Some situations |

---

##  Cost Expectations

### Initial Setup Costs

| Item | Cost |
|------|------|
| Housing deposit (1-2 months) | EUR 2,000-5,000 |
| First month rent | EUR 1,500-2,500 |
| Bike + locks | EUR 300-500 |
| Health insurance (first month) | EUR 150-200 |
| SIM/phone | EUR 0-50 |
| **Total** | **EUR 4,000-8,000** |

### Monthly Budget

See `cost.md` for detailed breakdown.

---

##  Common Mistakes

1. **Not registering quickly** - Delays BSN, banking, everything
2. **Waiting for "perfect" apartment** - Take what you can get
3. **Skipping health insurance** - Mandatory, fines apply
4. **Buying cheap bike** - Often stolen or poor quality
5. **Not learning any Dutch** - Limits social integration
6. **Expecting quick friendships** - Dutch take time to warm up
7. **Underestimating housing costs** - Budget 40-50% of income

---

*Moving to Amsterdam requires patience with bureaucracy but rewards with quality of life. Prepare documents in advance and be ready to act fast on housing.*
