# Amsterdam West - Oud-West, Westerpark, Bos en Lommer

> Creative, green, and increasingly popular - West Amsterdam offers the best of local life.

---

## Oud-West

### Character
- **Vibe:** Hip, local, creative but established
- **Architecture:** 19th-century with renovation, mixed
- **Crowd:** Young professionals, creatives, young families
- **Best for:** Those wanting De Pijp vibes with slightly more space

### Rental Prices (Feb 2026)
| Type | Price Range | Notes |
|------|-------------|-------|
| Studio | EUR 1,300-1,600 | Competitive |
| 1-Bedroom | EUR 1,600-2,300 | Most available |
| 2-Bedroom | EUR 2,200-3,200 | Good for couples |
| 3-Bedroom | EUR 3,000-4,200 | Family options |

### Key Areas Within Oud-West
| Area | Character | Rent |
|------|-----------|------|
| **Kinkerbuurt** | Kinkerstraat shopping, lively | Base |
| **Bellamybuurt** | Quieter, residential | Base |
| **Helmersbuurt** | Near Vondelpark, upscale | +15% |
| **Da Costabuurt** | Local feel, authentic | -5% |
| **Overtoomse Veld** | Edge of area, more affordable | -10% |

### Highlights
- **Ten Katemarkt** - Authentic local market (Mon-Sat)
- **Kinkerstraat** - High street with shops, restaurants
- **De Hallen** - Cultural center in former tram depot
- **Foodhallen** - Indoor food market (touristy but good)
- **Vondelpark** - Eastern edge accessible

### Pros
- Local Amsterdam feel
- Good food scene (less crowded than De Pijp)
- De Hallen cultural complex
- Easy bike to center (10 min)
- Better value than De Pijp
- Green spaces nearby

### Cons
- Less central than De Pijp
- Some areas still rough around edges
- Parking difficult
- Can feel far from east Amsterdam

### Transport
- **Tram:** 7, 17, 19
- **Metro:** Nearby at Lelylaan
- **Bike:** 10-15 min to Centrum

---

## Westerpark

### Character
- **Vibe:** Creative, green, post-industrial cool
- **Architecture:** Mix of old housing and converted industrial
- **Crowd:** Creatives, young families, entrepreneurs
- **Best for:** Those wanting green space and creative energy

### Rental Prices (Feb 2026)
| Type | Price Range | Notes |
|------|-------------|-------|
| Studio | EUR 1,200-1,500 | Some new builds |
| 1-Bedroom | EUR 1,500-2,000 | Good variety |
| 2-Bedroom | EUR 2,000-2,800 | Family-friendly |
| 3-Bedroom | EUR 2,800-3,800 | Available |

### The Westerpark
The park is the neighborhood's heart:
- **Westergasfabriek** - Converted gas factory now cultural hub
- Restaurants, theaters, festivals
- Sunday market (monthly)
- Large green spaces
- Playgrounds for kids

### Key Areas
| Area | Character |
|------|-----------|
| **Along Westerpark** | Premium, park views |
| **Spaarndammerbuurt** | Working class heritage, authentic |
| **Zeeheldenbuurt** | Near Haarlemmerplein, connected |
| **Staatsliedenbuurt** | Mixed, some social housing |

### Pros
- Westerpark - excellent urban park
- Westergasfabriek - culture, restaurants, events
- More space than central neighborhoods
- Creative community
- Good schools developing
- Affordable-ish for Amsterdam

### Cons
- Less central
- Some areas still transitioning
- Limited shopping
- Not as well-connected by tram

### Transport
- **Tram:** 3, 10
- **Bus:** Lines to center
- **Bike:** 12-15 min to Centrum

---

## Bos en Lommer

### Character
- **Vibe:** Multicultural, working class, changing rapidly
- **Architecture:** Post-war housing, some 19th century
- **Crowd:** Diverse - Moroccan, Turkish, Surinamese, students, young professionals
- **Best for:** Budget-conscious people who appreciate diversity

### Rental Prices (Feb 2026)
| Type | Price Range | Notes |
|------|-------------|-------|
| Studio | EUR 1,000-1,300 | Best value |
| 1-Bedroom | EUR 1,200-1,600 | Competitive |
| 2-Bedroom | EUR 1,500-2,200 | Family options |
| 3-Bedroom | EUR 2,000-2,800 | Available |

### Key Areas
| Area | Character |
|------|-----------|
| **Bos en Lommerweg** | Main street, shops, changing |
| **Erasmuspark area** | Nicer, park proximity |
| **Near Bos en Lommer metro** | Well-connected |

### Pros
- **Most affordable in West**
- Authentic multicultural Amsterdam
- Excellent Middle Eastern/Turkish food
- Metro access (Bos en Lommer station)
- Large apartments
- Rapid gentrification = investment potential

### Cons
- Still rough in parts
- Not everyone's aesthetic
- Language barriers in some shops
- Some social issues
- Less international expat community

### Transport
- **Metro:** Line 50/51 (Bos en Lommer station)
- **Tram:** 7
- **Bike:** 15 min to Centrum

---

## Nieuw-West (New West)

### Character
- **Vibe:** Post-war suburbs, diverse, affordable
- **Architecture:** 1950s-70s social housing, some new development
- **Crowd:** Diverse communities, families, budget-conscious
- **Best for:** Families needing space and affordability

### Areas in Nieuw-West
| Area | Character | Price Range (1BR) |
|------|-----------|-------------------|
| **Slotermeer** | Working class, diverse | EUR 1,000-1,400 |
| **Geuzenveld** | Quiet, family | EUR 1,000-1,400 |
| **Osdorp** | Large, suburban feel | EUR 1,100-1,500 |
| **Slotervaart** | Mixed, improving | EUR 1,100-1,500 |
| **De Aker** | Newer, more upscale | EUR 1,300-1,700 |

### Pros
- Most affordable in Amsterdam
- Large apartments
- Sloterplas (lake) and parks
- Space for families
- Metro connected
- Improving amenities

### Cons
- Not "Amsterdam" feeling
- Car more useful
- Limited nightlife/dining
- Social challenges in some blocks
- Stigma (often unfair)

### Transport
- **Metro:** Line 50 runs through
- **Tram:** Limited
- **Bike:** 20-25 min to Centrum

---

## West Amsterdam Comparison

| Factor | Oud-West | Westerpark | Bos en Lommer | Nieuw-West |
|--------|----------|------------|---------------|------------|
| **Rent (1BR)** | EUR 1,600-2,300 | EUR 1,500-2,000 | EUR 1,200-1,600 | EUR 1,000-1,500 |
| **Character** | Hip, local | Creative, green | Multicultural | Suburban |
| **Safety** |  |  |  |  |
| **Families** |  |  |  |  |
| **Transit** |  |  |  |  |
| **Nightlife** |  |  |  |  |

---

## Practical Tips

### Finding Housing
- **Oud-West:** Similar competition to De Pijp. Prepare documents, act fast.
- **Westerpark:** Slightly easier. New builds coming online.
- **Bos en Lommer:** Much easier to find. Don't dismiss based on reputation.
- **Nieuw-West:** Easiest in Amsterdam. Social housing options possible.

### Daily Life
| Service | Oud-West | Westerpark | Bos en Lommer |
|---------|----------|------------|---------------|
| Supermarkets | Excellent | Good | Excellent |
| Restaurants | Very good | Good | Basic + ethnic |
| Gyms | Yes | Yes | Yes |
| Parks | Vondelpark nearby | Westerpark | Erasmuspark |

---

## Who Should Live Where

**Oud-West:**
- Young professionals
- Couples
- Those wanting local Amsterdam feel
- Food lovers

**Westerpark:**
- Creative types
- Young families
- Nature lovers
- Event/festival enthusiasts

**Bos en Lommer:**
- Budget-conscious
- Adventurous types
- Those appreciating diversity
- Students

**Nieuw-West:**
- Families needing space
- Budget priority
- Those with cars
- People okay with suburban feel

---

*West Amsterdam offers the best value for money while maintaining authentic Amsterdam character. Consider looking beyond the obvious choices.*
