# Local Services in Amsterdam

> Banking, BSN, utilities, and essential services guide.

---

##  BSN Registration

### What It Is

BSN (Burgerservicenummer) = Your Dutch citizen service number.

**Required for:**
- Working legally
- Health insurance
- Banking
- Taxes
- Government services

### How to Register

1. **Book appointment** at gemeente Amsterdam (amsterdam.nl)
2. **Wait time:** Usually 1-2 weeks
3. **Bring:**
   - Valid passport
   - Birth certificate (apostilled if non-EU)
   - Proof of address (rental contract)
   - Marriage certificate (if applicable)
4. **Duration:** 15-30 minutes
5. **Receive BSN:** Same day or by mail within days

### Tips

- Book earliest available slot
- Documents in English/Dutch preferred
- Apostille needed for some countries
- Can apply before starting work

---

##  Banking

### Main Banks

| Bank | Type | App Quality | English Support |
|------|------|-------------|-----------------|
| **ING** | Traditional | Excellent | Yes |
| **ABN AMRO** | Traditional | Good | Yes |
| **Rabobank** | Traditional | Good | Limited |
| **bunq** | Digital | Excellent | Yes |
| **N26** | Digital | Excellent | Yes |

### Opening an Account

**Requirements:**
- BSN number (some exceptions)
- Valid ID/passport
- Proof of address
- Employment contract (some banks)

**Timeline:**
- Digital banks: Same day
- Traditional banks: 1-2 weeks

### Dutch Payment Methods

| Method | Usage |
|--------|-------|
| **Maestro/Debit** | Primary payment method |
| **iDEAL** | Online payments |
| **Tikkie** | Person-to-person |
| **Contactless** | Widespread |
| **Credit cards** | Accepted but less common |
| **Cash** | Decreasing, still works |

---

##  Healthcare Registration

### Step 1: Get Health Insurance

**Mandatory** - Must sign up within 4 months.

| Provider | Type |
|----------|------|
| Zilveren Kruis | Traditional |
| CZ | Traditional |
| VGZ | Traditional |
| Menzis | Traditional |

### Step 2: Register with Huisarts (GP)

**Critical** - Your first point of healthcare access.

**How:**
1. Find nearby huisarts (check Zorgkaart Nederland)
2. Call to ask if accepting patients (waiting lists common)
3. Register with BSN and insurance
4. May need to visit in person

**Tip:** Some areas have long waiting lists. Start searching immediately.

### Step 3: Register with Pharmacy

Usually near your huisarts. Register with insurance card.

---

##  Phone & Internet

### Mobile Plans

| Provider | Type | Monthly |
|----------|------|---------|
| KPN | Network | EUR 15-40 |
| Vodafone | Network | EUR 15-35 |
| T-Mobile/Odido | Network | EUR 15-35 |
| Simyo | Budget MVNO | EUR 8-20 |
| Ben | Budget MVNO | EUR 10-25 |
| Lebara | Budget | EUR 10-20 |

### Getting a SIM

| Option | Requirements |
|--------|--------------|
| **Prepaid** | Just passport |
| **Postpaid** | BSN, Dutch bank, address |
| **eSIM** | Phone support, varies |

### Home Internet

| Provider | Technology | Price |
|----------|------------|-------|
| Ziggo | Cable | EUR 40-70 |
| KPN | Fiber/DSL | EUR 40-65 |
| T-Mobile | Fiber | EUR 35-55 |

**Timeline:** 1-2 weeks for installation

---

##  Utilities (DEWA)

### Energy Providers

| Provider | Type |
|----------|------|
| Vattenfall | Large |
| Eneco | Large |
| Essent | Large |
| Greenchoice | Green |
| Budget Energie | Budget |

### Setting Up

1. Check who supplies building (ask landlord)
2. Compare on Pricewise.nl or Gaslicht.com
3. Sign up online with BSN
4. Provide meter reading

### Costs (2026)

| Utility | Monthly (avg apartment) |
|---------|------------------------|
| Electricity + Gas | EUR 150-300 |
| Water | EUR 30-50 |
| **Total** | EUR 180-350 |

### Water

Always **Waternet** in Amsterdam (no choice).

---

##  Mail & Packages

### PostNL

| Service | Details |
|---------|---------|
| Mail delivery | Mon-Sat (most areas) |
| Package pickup | PostNL points, lockers |
| Sending | PostNL offices, Albert Heijn |

### Package Lockers

| Service | Where |
|---------|-------|
| PostNL | Various locations |
| DHL | Service points |
| Amazon Lockers | Limited |

### Address Registration

Ensure your address is correctly registered at gemeente - affects mail delivery.

---

##  Driving & Vehicle Registration

### Dutch License

| Situation | What to Do |
|-----------|------------|
| EU license | Valid indefinitely |
| 30% ruling (non-EU) | Exchange within 6 months |
| Other non-EU | Take Dutch exam |

### License Exchange (30% Ruling)

1. Apply at gemeente (driving license desk)
2. Bring: passport, BSN, current license, photos
3. Health declaration
4. Pay fee (~EUR 40)
5. Receive within 2 weeks

### Car Registration

| Step | Where |
|------|-------|
| Buy car | Private/dealer |
| Register | RDW (online) |
| Insurance | Required before registration |
| Road tax | Automatic after registration |

---

##  Schools Registration

### Dutch Schools

| Type | Registration |
|------|--------------|
| Primary (basisschool) | Contact school directly, waitlists |
| Secondary (middelbare) | Through school, some selection |
| International | Direct application |

### International Schools

| School | Curriculum |
|--------|------------|
| ISA Amsterdam | IB |
| British School Amsterdam | British |
| Amsterdam International Community School | IB |
| European School | European Bac |

---

##  Taxes

### Tax Authority

**Belastingdienst** - Dutch IRS equivalent.

### Key Taxes

| Tax | Rate/Amount |
|-----|-------------|
| Income tax | 36.97% - 49.5% |
| BTW (VAT) | 21% (9% reduced) |
| Municipal tax | ~EUR 300-500/year |

### Filing

| When | Deadline |
|------|----------|
| Tax year | Calendar year |
| Filing deadline | May 1 (following year) |
| Refund timeline | Usually July-September |

### DigiD

Required for:
- Online tax filing
- Healthcare allowances
- Government services

**Get it:** digid.nl (activation code by mail)

---

##  Housing Services

### Tenant Rights Organizations

| Organization | Purpose |
|--------------|---------|
| !WOON | Tenant support |
| Huurteam | Rent advice |
| Juridisch Loket | Free legal advice |

### Rent Check

Check if your rent is fair:
- Huurprijscheck.nl
- Points system determines max rent

### Repairs

| Issue | Who Pays |
|-------|----------|
| Major repairs | Landlord |
| Minor (wear) | Usually landlord |
| Your damage | You |
| Appliances (built-in) | Landlord |

---

##  Useful Government Sites

| Site | Purpose |
|------|---------|
| amsterdam.nl | Municipality services |
| belastingdienst.nl | Taxes |
| uwv.nl | Employment agency |
| svb.nl | Social insurance |
| rijksoverheid.nl | National government |
| ind.nl | Immigration |
| duo.nl | Education/student finance |

---

##  Home Services

### Finding Help

| Service | Where to Find |
|---------|---------------|
| Plumber | Werkspot.nl, Google |
| Electrician | Werkspot.nl |
| Cleaner | Helpling, Facebook |
| Handyman | Werkspot.nl |

### Typical Costs

| Service | Hourly Rate |
|---------|-------------|
| Plumber | EUR 50-100 |
| Electrician | EUR 50-80 |
| Cleaner | EUR 15-25 |
| Handyman | EUR 40-60 |

---

##  Essential Stores

### Supermarkets

| Store | Type | Hours |
|-------|------|-------|
| Albert Heijn | Standard | 8:00-22:00 |
| Jumbo | Standard | 8:00-22:00 |
| Lidl | Budget | 8:00-21:00 |
| Aldi | Budget | 8:00-21:00 |

### Other Essentials

| Store | Type |
|-------|------|
| Kruidvat | Drugstore |
| Etos | Drugstore |
| Action | Budget goods |
| HEMA | Dutch department store |
| Blokker | Household goods |

---

*Setting up life in Amsterdam requires patience with bureaucracy, but the systems work well once established. Start with BSN, then everything else follows.*
