# Healthcare in Amsterdam

> Understanding the Dutch healthcare system: insurance, GPs, and medical care.

---

##  System Overview

### How It Works

Dutch healthcare is **insurance-based but regulated**:
- Basic insurance is mandatory
- Insurers must accept everyone
- Same basic package for all
- Competition keeps quality high

### Key Principles

| Principle | Meaning |
|-----------|---------|
| **Huisarts first** | GP is gatekeeper to specialists |
| **Referral required** | Can't go directly to specialist |
| **Universal coverage** | Everyone must be insured |
| **Regulated prices** | Government sets basic rates |

---

##  Health Insurance

### Mandatory Coverage

**All residents must have basic insurance** (basiszorgverzekering):

| Coverage | What's Included |
|----------|-----------------|
| GP (huisarts) | Full coverage |
| Hospital care | Full coverage |
| Prescription drugs | Full coverage (after eigen risico) |
| Mental health | Covered (with referral) |
| Maternity | Full coverage |
| Emergency care | Full coverage |

### Costs (2026)

| Component | Monthly Cost |
|-----------|--------------|
| Basic insurance | EUR 140-170 |
| Eigen risico (deductible) | EUR 385/year (mandatory) |
| Supplementary (aanvullend) | EUR 20-100 (optional) |

### Eigen Risico (Deductible)

**EUR 385/year** - You pay the first EUR 385 of most care costs.

**Exempt from eigen risico:**
- GP visits
- Maternity care
- Children under 18

**Applies to:**
- Prescription medications
- Hospital stays
- Specialist visits
- Mental health care

### Supplementary Insurance

| Coverage Type | What It Adds |
|---------------|--------------|
| Dental (tandarts) | Partial coverage |
| Physiotherapy | Extra sessions |
| Alternative medicine | Acupuncture, etc. |
| Glasses/contacts | Partial coverage |
| Travel insurance | Foreign healthcare |

### Major Insurers

| Insurer | Notes |
|---------|-------|
| Zilveren Kruis | Largest |
| CZ | Good customer service |
| VGZ | Major insurer |
| Menzis | Competitive |
| OHRA | Digital-focused |

### Choosing Insurance

Compare on:
- **Independer.nl**
- **Zorgwijzer.nl**
- **Poliswijzer.nl**

**Switch:** Every January (deadline: January 1)

---

##  Huisarts (GP)

### The Gatekeeper

Your huisarts is **essential**:
- First point of contact for everything
- Refers to specialists
- Prescribes medications
- Manages ongoing conditions

### Finding a Huisarts

**Challenge:** Waiting lists in popular areas.

| Step | How |
|------|-----|
| 1. Search | Zorgkaart Nederland |
| 2. Call practices | Ask if accepting patients |
| 3. Register | May need to visit |
| 4. Confirm | Insurance card + ID |

### What to Expect

| Aspect | Dutch Reality |
|--------|---------------|
| Appointment length | 10-15 minutes |
| Phone consultations | Common |
| Prescriptions | Conservative approach |
| Antibiotics | Not given easily |
| Referrals | Only when needed |

### Hours

| Type | Hours |
|------|-------|
| Regular | Mon-Fri, 8:00-17:00 |
| Evening/weekend | Huisartsenpost (emergency GP) |
| Emergency | 112 or Huisartsenpost |

### Huisartsenpost

After-hours GP service:
- Call your huisarts number
- Redirected to huisartsenpost
- For urgent but non-emergency care
- Located at major hospitals

---

##  Hospitals

### Major Amsterdam Hospitals

| Hospital | Location | Type |
|----------|----------|------|
| **Amsterdam UMC (AMC)** | Zuidoost | Academic |
| **Amsterdam UMC (VUmc)** | Buitenveldert | Academic |
| **OLVG** | Oost/West | General |
| **BovenIJ Ziekenhuis** | Noord | General |
| **Sint Lucas Andreas** | West | General |

### Emergency Care (Spoedeisende Hulp)

| Situation | What to Do |
|-----------|------------|
| Life-threatening | Call 112 |
| Urgent but not emergency | Huisartsenpost |
| Minor injury | Huisarts or wait |

### Hospital Care

| Process | Notes |
|---------|-------|
| Referral | Usually needed from huisarts |
| Waiting times | Can be weeks for non-urgent |
| Quality | High throughout |
| English | Widely spoken |

---

##  Dental Care

### Coverage

**Not included in basic insurance** - Need supplementary or pay yourself.

### Costs (Without Insurance)

| Service | Approximate Cost |
|---------|-----------------|
| Check-up | EUR 30-50 |
| Cleaning | EUR 40-80 |
| Filling | EUR 50-150 |
| Root canal | EUR 200-500 |
| Extraction | EUR 50-150 |
| X-ray | EUR 30-50 |

### Finding a Dentist

- Register like huisarts
- Waiting lists in popular areas
- Private practices common
- Some English-speaking dentists

---

##  Mental Health

### Coverage

**Included in basic insurance** with referral from huisarts.

### Pathway

1. **Huisarts** - First discussion
2. **POH-GGZ** - Practice nurse for mental health
3. **Psychologist** - If needed
4. **Psychiatrist** - For medication/serious conditions

### Waiting Times

| Type | Typical Wait |
|------|--------------|
| POH-GGZ | 1-4 weeks |
| Psychologist | 4-12 weeks |
| Psychiatrist | 8-20 weeks |

### Private Options

Faster access but expensive:
- EUR 100-150/session
- Not covered by basic insurance
- English-speaking options available

### Mental Health Resources

| Resource | Purpose |
|----------|---------|
| 113 Zelfmoordpreventie | Suicide prevention |
| GGD Amsterdam | Public mental health |
| Arkin | Mental health organization |
| PsyQ | Mental health clinics |

---

##  Maternity Care

### Coverage

**Fully covered** by basic insurance.

### Dutch Birth Culture

Unique features:
- Midwife-led care standard
- Home births common (~13%)
- Kraamzorg (postnatal care at home)
- Hospital for complications only

### Pathway

| Stage | Care Provider |
|-------|---------------|
| Pregnancy | Verloskundige (midwife) |
| Routine checks | Midwife |
| Complications | Gynecologist |
| Birth | Midwife or hospital |
| After birth | Kraamzorg (7-8 days) |

### Kraamzorg

Post-natal care at home:
- Daily visits for ~8 days
- Baby care assistance
- Mother recovery support
- Breastfeeding help
- Household assistance

---

##  Pharmacies

### Apotheek

| Service | Details |
|---------|---------|
| Prescription pick-up | With huisarts prescription |
| OTC medications | Available |
| Health advice | Pharmacists can advise |
| Repeat prescriptions | Automatic system |

### Common Medications

| Dutch Name | English |
|------------|---------|
| Paracetamol | Acetaminophen |
| Ibuprofen | Ibuprofen |
| Ontstekingsremmer | Anti-inflammatory |
| Antibiotica | Antibiotics |

### OTC vs Prescription

Dutch approach is **conservative**:
- Many medications require prescription
- Antibiotics not given easily
- Stronger painkillers restricted

---

##  Zorgtoeslag (Healthcare Allowance)

### What It Is

Government subsidy for health insurance costs.

### Eligibility

| Factor | Requirement |
|--------|-------------|
| Income | Below threshold (~EUR 38,000 single) |
| Age | 18+ |
| Insurance | Must have basic insurance |

### Amount

| Status | Max Monthly |
|--------|-------------|
| Single | ~EUR 154 |
| Couple | ~EUR 297 |

### How to Apply

1. Get DigiD
2. Apply at Belastingdienst.nl
3. Provide income information
4. Receive monthly payment

---

##  Emergency Services

### When to Call 112

- Life-threatening situations
- Severe accidents
- Heart attack symptoms
- Severe bleeding
- Unconsciousness

### When NOT to Call 112

- General illness -> Huisarts
- Minor injuries -> Huisarts
- After-hours non-emergency -> Huisartsenpost

### What Happens

| Step | Process |
|------|---------|
| Call | 112, answer questions |
| Dispatch | Ambulance sent if needed |
| Hospital | Taken to nearest appropriate hospital |
| Follow-up | Huisarts informed |

---

##  Healthcare for Expats

### English-Speaking Options

| Service | Options |
|---------|---------|
| GPs | Several English-speaking practices |
| Hospitals | English widely spoken |
| Specialists | Most speak English |

### Expat-Focused Practices

- ACCESS (expat center)
- International health centers
- Some huisartsen specialize in expats

### EHIC / UK (Post-Brexit)

| Situation | What Applies |
|-----------|--------------|
| EU citizen | EHIC for emergency |
| UK citizen | GHIC for emergency |
| Tourist | Travel insurance needed |
| Resident | Dutch insurance required |

---

##  Summary

| Aspect | Dutch System |
|--------|--------------|
| **Quality** | High |
| **Cost** | EUR 150-200/month average |
| **Access** | Universal |
| **Speed** | Can be slow for non-urgent |
| **GP role** | Central gatekeeper |
| **Approach** | Conservative, practical |

---

*The Dutch healthcare system is excellent but requires adjustment to the gatekeeper model. Register with a huisarts immediately upon arrival.*
