# Practical Food Guide - Dietary, Alcohol & Considerations

> Special diets, halal options, alcohol, and cultural food considerations in Amsterdam.

---

##  Vegetarian & Vegan

### Vegetarian-Friendly Level

Amsterdam is **very vegetarian-friendly**:
- Most restaurants have vegetarian options
- Vegan options increasingly common
- Dedicated vegan restaurants exist

### Best Vegetarian/Vegan Restaurants

| Restaurant | Type | Location | Price |
|------------|------|----------|-------|
| **De Kas** | Farm-to-table | Oost | EUR EUR EUR EUR  |
| **Meatless District** | Vegan | Various | EUR EUR  |
| **Betty's** | Vegan | Various | EUR EUR  |
| **Mr. & Mrs. Watson** | Vegan cheese | Centrum | EUR EUR  |
| **TerraZen Centre** | Macrobiotic | Jordaan | EUR EUR  |
| **Vegan Junk Food Bar** | Vegan fast food | Various | EUR EUR  |
| **Gartine** | Seasonal | Centrum | EUR EUR  |

### Vegan by Cuisine

| Cuisine | Vegan Options |
|---------|---------------|
| **Indonesian** | Tempeh, tofu dishes common |
| **Surinamese** | Vegetable roti, bara |
| **Middle Eastern** | Falafel, hummus |
| **Indian** | Many options |
| **Asian** | Varies widely |

### Supermarket Vegan Options

| Store | Vegan Range |
|-------|-------------|
| **Albert Heijn** | Good range, Terra brand |
| **Ekoplaza** | Excellent organic/vegan |
| **Marqt** | Premium options |
| **Jumbo** | Basic range |

---

##  Halal

### Halal Scene

Amsterdam has a significant Muslim community:
- Many halal restaurants
- Halal butchers available
- Halal options in mainstream restaurants

### Halal Restaurants

| Restaurant | Cuisine | Location |
|------------|---------|----------|
| **Many Surinamese** | Ask to confirm | Various |
| **Turkish restaurants** | Most are halal | Various |
| **Middle Eastern** | Most are halal | Various |
| **Indonesian** | Some (ask) | Various |
| **Indian** | Some (ask) | Various |

### Halal Chains & Fast Food

| Chain | Halal Status |
|-------|--------------|
| **McDonalds** | Not halal |
| **Burger King** | Not halal |
| **KFC** | Not halal (NL) |
| **Turkish doner shops** | Usually halal |
| **Shawarma places** | Usually halal |

### Halal Butchers/Shops

- Concentrated in Oost, West, Bos en Lommer
- Dappermarkt area
- New West neighborhoods

---

##  Alcohol

### Legal Framework

| Rule | Details |
|------|---------|
| Legal age | 18+ for all alcohol |
| Purchase | Supermarkets, liquor stores, bars |
| Public drinking | Banned in some areas |
| Driving | 0.5% limit (0.2% new drivers) |

### Where to Buy

| Type | Where |
|------|-------|
| **Beer** | Supermarkets (Albert Heijn, Jumbo) |
| **Wine** | Supermarkets, Gall & Gall |
| **Spirits** | Gall & Gall, specialty stores |
| **Craft beer** | Beer shops, breweries |

### Drinking Culture

- Beer is primary social drink
- "Borrel" = after-work drinks
- Brown cafes are social hubs
- Wine bars growing in popularity
- Cocktail bars in trendy areas

### Alcohol-Free Options

Growing selection:
- Most bars have 0% beer (Heineken 0.0, etc.)
- Mocktails at cocktail bars
- Specialty alcohol-free spirits appearing

---

##  Gluten-Free

### Gluten-Free Availability

**Moderate to good** - awareness is growing:
- Most restaurants understand "gluten-vrij"
- Dedicated options less common than vegan
- Supermarkets have GF sections

### Best for Gluten-Free

| Type | Options |
|------|---------|
| **Indonesian** | Rice-based, naturally GF options |
| **Thai/Vietnamese** | Rice noodles, rice dishes |
| **Surinamese** | Some dishes GF (ask about roti) |
| **Fine dining** | Can accommodate |

### Supermarket GF Products

| Store | Range |
|-------|-------|
| **Ekoplaza** | Best selection |
| **Albert Heijn** | Good basics |
| **Marqt** | Premium options |

---

##  Allergies

### Allergy Awareness

- Dutch law requires allergen labeling
- Most restaurants can accommodate
- "Ik heb een allergie voor..." = "I have an allergy to..."

### Common Allergen Concerns

| Allergen | Dutch Term | Common In |
|----------|------------|-----------|
| Nuts | Noten | Desserts, Indonesian |
| Peanuts | Pinda's | Indonesian (satay sauce) |
| Dairy | Zuivel | Most Dutch food |
| Shellfish | Schelpdieren | Seafood restaurants |
| Soy | Soja | Asian cuisines |
| Gluten | Gluten | Bread, pastries |

### Tips

1. Communicate clearly (in English is fine)
2. Card with allergies in Dutch helps
3. Indonesian has peanuts in many sauces
4. Dutch love butter and cream

---

##  Kosher

### Kosher in Amsterdam

Amsterdam has historic Jewish community with kosher options:

### Kosher Restaurants

| Restaurant | Type | Location |
|------------|------|----------|
| **HaCarmel** | Middle Eastern | Amstelveenseweg |
| **Sal Meijer** | Sandwiches | Buitenveldert |
| **Cohen's Deli** | Deli | Buitenveldert |

### Kosher Shops

- Concentrated in Buitenveldert area
- Some products in regular supermarkets
- Kosher section in larger Albert Heijn

---

##  Ramadan Considerations

### Eating During Ramadan

- Many restaurants in Muslim areas open late
- Iftar dinners available at some restaurants
- Respect fasting Muslims during day
- Supermarkets stock dates, special items

### Areas with Ramadan Activity

- Oost (Dapperbuurt)
- West (Bos en Lommer)
- Nieuw-West
- Zuidoost

---

##  Coffee & Tea Culture

### Coffee Culture

| Type | What to Order |
|------|---------------|
| **Koffie** | Filter coffee |
| **Koffie verkeerd** | "Wrong coffee" = latte |
| **Cappuccino** | Standard cappuccino |
| **Espresso** | Single/double |

### Tea

- Dutch drink a lot of tea
- Usually served with cookie
- Herbal teas widely available

### Important Distinction

- **Coffee shop** (two words) = Cafe for coffee
- **Coffeeshop** (one word) = Cannabis shop

---

##  Ordering & Reservations

### How to Book

| Method | When to Use |
|--------|-------------|
| **Direct call** | Traditional restaurants |
| **Online (website)** | Most restaurants |
| **TheFork** | Common booking platform |
| **Google Maps** | Quick bookings |
| **Walk-in** | Casual spots, weekday lunch |

### Reservation Tips

1. Book weekend dinners Thu-Sat
2. Popular spots need 1+ week advance
3. Michelin restaurants need months
4. Specify dietary needs when booking

---

##  Paying & Tipping

### Payment Methods

| Method | Acceptance |
|--------|------------|
| **Debit card (Maestro)** | Preferred |
| **Credit card** | Most places |
| **Cash** | Accepted, bring some |
| **Apple/Google Pay** | Growing |

### Tipping Guide

| Service | Tip |
|---------|-----|
| **Restaurants** | Round up or 5-10% max |
| **Cafes** | Round up |
| **Bars** | Round up |
| **Food delivery** | EUR 1-2 |

**Note:** Service is included. Tips are appreciated but not expected.

### Splitting Bills

- **Tikkie** app - Dutch standard for splitting
- Most places can split bills
- Common to pay separately

---

##  Meal Times

### Dutch Eating Schedule

| Meal | Time |
|------|------|
| **Ontbijt** (breakfast) | 7:00-9:00 |
| **Koffiepauze** (coffee break) | 10:00-11:00 |
| **Lunch** | 12:00-13:00 |
| **Borrel** (drinks) | 17:00-19:00 |
| **Diner** (dinner) | 18:00-20:00 |

### Kitchen Hours

- Most kitchens close by 22:00
- Late-night options limited (except fast food)
- Sunday brunch popular (book ahead)

---

##  Useful Phrases

| English | Dutch |
|---------|-------|
| The bill, please | De rekening, alstublieft |
| I'm vegetarian | Ik ben vegetarier |
| I'm vegan | Ik ben veganist |
| I have an allergy | Ik heb een allergie |
| No nuts please | Geen noten, alstublieft |
| Is this halal? | Is dit halal? |
| Gluten-free | Glutenvrij |
| Tap water | Kraanwater |
| Cheers! | Proost! |

---

*Amsterdam accommodates most dietary needs. When in doubt, ask - English is widely spoken.*
