# Amsterdam Food Scene Overview

> A guide to eating in Amsterdam: Dutch cuisine, international diversity, and food culture.

---

##  Food Culture Overview

### Amsterdam's Food Identity

Amsterdam's food scene reflects its history as a trading hub and modern multicultural city:

- **Dutch cuisine** - Hearty, simple, comfort food
- **Indonesian** - Colonial legacy, now integral
- **Surinamese** - Large community, incredible flavors
- **International** - Everything from Michelin to street food
- **Modern Dutch** - Farm-to-table, seasonal focus

### Dining Culture

| Aspect | Dutch Reality |
|--------|---------------|
| Meal times | Lunch 12-13:00, Dinner 18:00-20:00 |
| Portions | Smaller than US, similar to EU |
| Reservations | Essential for popular spots |
| Tipping | Round up or 5-10% max |
| Service | Efficient, not overly attentive |
| Split bills | Common, use Tikkie app |

---

##  Dutch Cuisine

### Must-Try Dutch Foods

| Food | What It Is | Where to Try |
|------|------------|--------------|
| **Bitterballen** | Deep-fried meat ragout balls | Any brown cafe |
| **Stroopwafel** | Caramel syrup waffle | Markets (fresh) |
| **Haring** | Raw herring with onions | Stubbe's Haring |
| **Kibbeling** | Fried fish pieces | Fish stalls |
| **Kroket** | Deep-fried meat roll | FEBO, cafes |
| **Poffertjes** | Mini fluffy pancakes | Markets |
| **Stamppot** | Mashed potato + veg | Moeders |
| **Erwtensoep** | Split pea soup | Winter cafes |
| **Pannenkoeken** | Dutch pancakes | Pancakes! |
| **Kaas** | Dutch cheese | Markets, Henri Willig |

### Best for Dutch Food

| Restaurant | Style | Price |
|------------|-------|-------|
| **Moeders** | Traditional, walls of photos | EUR EUR  |
| **De Silveren Spiegel** | Upscale Dutch | EUR EUR EUR EUR  |
| **Restaurant Greetje** | Traditional elevated | EUR EUR EUR  |
| **Haesje Claes** | Tourist but authentic | EUR EUR  |

---

##  Indonesian (Essential)

### Why Indonesian is Essential

- 350+ years of colonial history
- Indonesian food is as Dutch as cheese
- Rijsttafel (rice table) is quintessential experience
- Available everywhere from street food to fine dining

### Rijsttafel Explained

| Type | Dishes | Price | Time |
|------|--------|-------|------|
| Small | 8-12 dishes | EUR 25-35 | 1.5h |
| Regular | 15-20 dishes | EUR 35-50 | 2h |
| Large | 20-30 dishes | EUR 50-70 | 2.5h |

### Best Indonesian

| Restaurant | Style | Price |
|------------|-------|-------|
| **Blauw** | Modern Indonesian | EUR EUR EUR  |
| **Restaurant Rijsel** | Elegant | EUR EUR EUR  |
| **Tempo Doeloe** | Classic, spicy | EUR EUR EUR  |
| **Warung Mini** | Casual, authentic | EUR EUR  |
| **Kantjil & de Tijger** | Popular, central | EUR EUR  |

---

##  Surinamese (Don't Miss)

### Surinamese Food 101

| Dish | What It Is |
|------|------------|
| **Roti** | Flatbread with curry (chicken, lamb, veg) |
| **Bami/Nasi** | Noodles/rice with meat |
| **Moksi Meti** | Mixed meat plate |
| **Pom** | Chicken-taro casserole |
| **Saoto soup** | Javanese chicken soup |

### Best Surinamese

| Restaurant | Area | Price |
|------------|------|-------|
| **Spang Makandra** | Oost | EUR EUR  |
| **Roopram Roti** | De Pijp | EUR  |
| **Warung Swietie** | Noord | EUR  |
| **Albina** | Centrum | EUR EUR  |

---

##  International Scene

### By Cuisine

| Cuisine | Quality | Best For |
|---------|---------|----------|
| **Japanese** | Excellent | Sushi, ramen |
| **Italian** | Good | Pizza, pasta |
| **Turkish** | Great | Doner, mezze |
| **Chinese** | Good | Dim sum, Cantonese |
| **Thai** | Good | Curries, noodles |
| **Middle Eastern** | Excellent | Falafel, shawarma |
| **Indian** | Average | Better in London |
| **Mexican** | Improving | Still limited |
| **American** | Growing | Burgers, BBQ |

### Food Halls

| Hall | Location | Best For |
|------|----------|----------|
| **Foodhallen** | Oud-West | Variety, atmosphere |
| **De Hallen** | Same building | Markets, events |
| **Markthal** | Rotterdam (day trip) | Architecture, food |

---

##  Coffee Culture

### Coffee Scene

Amsterdam has excellent specialty coffee:

| Shop | Location | Known For |
|------|----------|-----------|
| **Lot Sixty One** | Oost | Best in city |
| **Screaming Beans** | Various | Consistent quality |
| **Coffee Virus** | West | Roasts own beans |
| **Bocca** | Various | Pioneer |
| **Headfirst** | Centrum | Central location |

### Coffee Terms

| Dutch | English |
|-------|---------|
| Koffie | Filter coffee |
| Espresso | Espresso |
| Cappuccino | Cappuccino |
| Koffie verkeerd | "Wrong coffee" = latte |

---

##  Drinks

### Beer

| Type | Examples |
|------|----------|
| **Pilsner** | Heineken, Amstel, Grolsch |
| **Craft** | Brouwerij 't IJ, Oedipus |
| **Belgian-style** | La Trappe, Westmalle |
| **Local IPAs** | Growing scene |

### Best Beer Spots

| Place | Type |
|-------|------|
| **Brouwerij 't IJ** | Brewery, windmill |
| **Oedipus** | Taproom, creative |
| **Arendsnest** | Dutch beer only |
| **Proeflokaal De Ooievaar** | Jenever tasting |
| **In de Wildeman** | Historic beer cafe |

### Jenever

Traditional Dutch gin:
- **Wynand Fockink** - Historic tasting house
- Drink from full glass, bent over (tradition)
- Jonge (young) vs Oude (old) styles

---

##  Food by Area

| Area | Best For |
|------|----------|
| **De Pijp** | Everything, best food neighborhood |
| **Jordaan** | Brown cafes, Dutch classics |
| **Centrum** | Tourist spots (avoid Damrak) |
| **Oost** | Indonesian, Surinamese |
| **Noord** | Creative restaurants, waterfront |
| **Oud-West** | Trendy, Foodhallen |
| **Oud-Zuid** | Fine dining, upscale |

---

##  Price Guide

| Type | Per Person |
|------|------------|
| Street food | EUR 5-10 |
| Casual lunch | EUR 12-18 |
| Casual dinner | EUR 20-35 |
| Mid-range dinner | EUR 40-60 |
| Fine dining | EUR 80-150+ |
| Tasting menu | EUR 75-200 |

---

##  Food Tips

### Do

- Book ahead for popular restaurants
- Try Indonesian (not just "Dutch")
- Eat at markets for lunch
- Ask for tap water (free)
- Explore De Pijp food scene

### Don't

- Eat on Damrak or Leidseplein (tourist traps)
- Skip Dutch specialties
- Expect American portions
- Tip more than 10%
- Miss market stroopwafels (fresh > packaged)

---

*See detailed guides: `food-local.md`, `food-international.md`, `food-areas.md`, `food-practical.md`*
