# Dutch & Local Cuisine in Amsterdam

> Traditional Dutch food, Indonesian staples, and Surinamese favorites.

---

##  Traditional Dutch

### Snacks & Street Food

| Food | Description | Best Spot |
|------|-------------|-----------|
| **Bitterballen** | Crispy fried meat ragout balls | Cafe Luxembourg |
| **Kroket** | Fried meat roll (croquette) | FEBO, Van Dobben |
| **Kibbeling** | Battered fried fish pieces | Volendammer Vishandel |
| **Haring** | Raw herring, onions, pickles | Stubbe's Haring, Frens |
| **Stroopwafel** | Caramel waffle cookie | Albert Cuyp (fresh) |
| **Poffertjes** | Mini fluffy pancakes | De Drie Graefjes |
| **Oliebollen** | Dutch doughnuts (NYE tradition) | Winter markets |
| **Kaassouffle** | Cheese pastry | FEBO |

### Main Dishes

| Dish | Description | Best Restaurant |
|------|-------------|-----------------|
| **Stamppot** | Mashed potato with veg (kale, carrots, endive) | Moeders |
| **Hutspot** | Carrot/onion/potato mash | Moeders |
| **Erwtensoep** | Split pea soup (winter) | De Blaffende Vis |
| **Pannenkoeken** | Dutch pancakes (sweet or savory) | Pancakes! Amsterdam |
| **Broodje kroket** | Kroket sandwich | Van Dobben |
| **Hollandse nieuwe** | First catch herring (May-June) | Fish stalls |

### Cheese Guide

| Cheese | Age | Flavor |
|--------|-----|--------|
| **Jong** (young) | 4 weeks | Mild, creamy |
| **Jong belegen** | 8-10 weeks | Slightly firmer |
| **Belegen** | 16-18 weeks | Medium, balanced |
| **Oud** (old) | 10-12 months | Sharp, crystalline |
| **Overjarig** | 18+ months | Very sharp, crumbly |

**Best cheese shops:** Henri Willig, Kaaskamer

---

##  Indonesian (Essential Eating)

### Key Dishes

| Dish | Description | Spice Level |
|------|-------------|-------------|
| **Nasi goreng** | Fried rice with egg | Mild-Medium |
| **Bami goreng** | Fried noodles | Mild-Medium |
| **Satay** | Grilled meat skewers, peanut sauce | Mild |
| **Rendang** | Slow-cooked beef curry | Medium-Hot |
| **Gado-gado** | Vegetables with peanut sauce | Mild |
| **Sambal goreng** | Spicy fried dish | Hot |
| **Soto ayam** | Chicken soup | Mild |
| **Nasi rawon** | Black soup with rice | Mild |
| **Tempeh** | Fermented soybean cake | Mild |
| **Perkedel** | Potato patties | Mild |

### Rijsttafel Experience

The ultimate Indonesian meal - rice with 12-30 small dishes:

| Component | Examples |
|-----------|----------|
| Rice | Steamed white rice, nasi kuning |
| Proteins | Satay, rendang, ayam, ikan |
| Vegetables | Sayur lodeh, gado-gado |
| Sides | Sambal, krupuk, atjar |
| Eggs | Telur balado |
| Condiments | Various sambals |

**Recommended:** Start with regular size (15-20 dishes) at EUR 35-50.

### Best Indonesian Restaurants

| Restaurant | Location | Price | Notes |
|------------|----------|-------|-------|
| **Blauw** | De Pijp | EUR EUR EUR  | Modern, popular |
| **Tempo Doeloe** | Jordaan | EUR EUR EUR  | Traditional, spicy |
| **Restaurant Rijsel** | Oost | EUR EUR EUR  | Elegant |
| **Kantjil & de Tijger** | Centrum | EUR EUR  | Central, reliable |
| **Warung Mini** | Centrum | EUR EUR  | Casual, authentic |
| **Ron Gastrobar Indonesia** | Oud-Zuid | EUR EUR EUR EUR  | Upscale modern |
| **Toko Joyce** | De Pijp | EUR  | Takeaway/casual |

---

##  Surinamese (Hidden Gem)

### Background

Surinamese cuisine blends:
- African
- Indian (Hindustani)
- Indonesian (Javanese)
- Chinese
- Dutch
- Indigenous

### Essential Dishes

| Dish | Description | Price Range |
|------|-------------|-------------|
| **Roti** | Flatbread with curry (chicken/lamb/veg) | EUR 8-15 |
| **Bami/Nasi** | Noodles/rice with meat and salad | EUR 8-12 |
| **Moksi meti** | Mixed meat plate | EUR 12-18 |
| **Pom** | Chicken-taro root casserole | EUR 12-15 |
| **Saoto soup** | Javanese chicken soup | EUR 8-12 |
| **Bakabana** | Fried plantain | EUR 3-5 |
| **Bara** | Lentil fritters | EUR 3-5 |
| **Kousenband** | Long beans | EUR 5-8 |

### Best Surinamese Restaurants

| Restaurant | Location | Price | Notes |
|------------|----------|-------|-------|
| **Spang Makandra** | Oost | EUR EUR  | Best overall |
| **Roopram Roti** | De Pijp | EUR  | Legendary roti |
| **Warung Swietie** | Noord | EUR  | Authentic |
| **Albina** | Centrum | EUR EUR  | Central location |
| **Kam Yin** | Centrum | EUR  | Chinese-Surinamese |
| **Tokoman** | Various | EUR  | Quick service |

---

##  Breakfast & Brunch

### Dutch Breakfast

| Item | Description |
|------|-------------|
| **Beschuit met muisjes** | Dry toast with anise sprinkles (for baby birth) |
| **Hagelslag** | Chocolate sprinkles on bread (really) |
| **Ontbijtkoek** | Spiced breakfast cake |
| **Uitsmijter** | Bread with ham/cheese, fried eggs |
| **Broodje kaas** | Cheese sandwich |

### Best Breakfast/Brunch

| Place | Location | Style | Price |
|-------|----------|-------|-------|
| **Bakers & Roasters** | De Pijp | Kiwi-Brazilian | EUR EUR  |
| **CT Coffee & Coconuts** | De Pijp | Trendy | EUR EUR  |
| **Dignita** | Various | Cafe | EUR EUR  |
| **Pluk** | Centrum | Instagram-worthy | EUR EUR  |
| **Cafe George** | Jordaan | Dutch | EUR EUR  |

---

##  Sweets & Desserts

### Dutch Sweets

| Sweet | Description | Where |
|-------|-------------|-------|
| **Stroopwafel** | Caramel waffle | Markets (fresh) |
| **Appeltaart** | Apple pie with cream | Cafe Winkel 43 |
| **Poffertjes** | Mini pancakes | De Drie Graefjes |
| **Speculaas** | Spiced cookies | Bakeries |
| **Tompouce** | Orange-topped pastry | Patisseries |
| **Limburgse vlaai** | Fruit pie | Bakeries |

### Best Apple Pie

The great debate:
| Cafe | Location | Style |
|------|----------|-------|
| **Winkel 43** | Jordaan | Classic, huge portions |
| **Papeneiland** | Jordaan | Traditional |
| **Villa Zeezicht** | Centrum | Cozy |

---

##  Bakeries

### Dutch Bakeries

| Bakery | Location | Known For |
|--------|----------|-----------|
| **Le Fournil de Sebastien** | Jordaan | French pastry |
| **Gebroeders Niemeijer** | Jordaan | Artisan bread |
| **Hartog's** | Centrum | Jewish bakery |
| **Brood** | De Pijp | Sourdough |

---

##  Markets for Local Food

### Albert Cuyp Market

**Best stalls:**
- Stroopwafels (several, go to longest line)
- Kibbeling at Volendammer
- Cheese tasting
- Indonesian takeaway
- Fresh produce

### Noordermarkt (Saturday)

**Best for:**
- Organic produce
- Artisan cheese
- Fresh bread
- Food trucks

### Dappermarkt

**Best for:**
- Surinamese food
- Turkish/Moroccan
- Cheap produce
- Authentic atmosphere

---

##  Traditional Dutch Restaurants

### Recommended

| Restaurant | Location | Price | Notes |
|------------|----------|-------|-------|
| **Moeders** | Jordaan | EUR EUR  | Mothers' recipes |
| **De Silveren Spiegel** | Centrum | EUR EUR EUR EUR  | Upscale Dutch |
| **Greetje** | Centrum | EUR EUR EUR  | Traditional elevated |
| **Haesje Claes** | Centrum | EUR EUR  | Tourist-friendly |
| **Cafe de Klos** | Centrum | EUR EUR  | Ribs, casual |
| **D'Vijff Vlieghen** | Centrum | EUR EUR EUR  | Historic setting |

---

##  Tips for Local Food

1. **Fresh stroopwafels only** - Packaged ones are inferior
2. **Try herring Dutch-style** - Hold by tail, tilt head back
3. **Indonesian lunch set** - Better value than dinner rijsttafel
4. **Surinamese for lunch** - Big portions, cheap
5. **Brown cafe for bitterballen** - Authentic experience
6. **Market for best prices** - Especially Albert Cuyp
7. **Cheese tasting free** - Most shops offer samples

---

*Local food is the soul of Amsterdam. Skip the tourist restaurants and eat where the Dutch eat.*
