# Education in Amsterdam

> Schools, universities, and the Dutch education system.

---

##  Dutch Education System

### Structure Overview

| Age | Level | Dutch Name |
|-----|-------|------------|
| 0-4 | Daycare | Kinderopvang |
| 2-4 | Preschool | Peuterspeelzaal |
| 4-12 | Primary | Basisonderwijs |
| 12-18 | Secondary | Voortgezet onderwijs |
| 18+ | Higher | Hoger onderwijs |

---

##  Childcare (0-4)

### Types

| Type | Age | Description |
|------|-----|-------------|
| **Kinderopvang** | 0-4 | Full daycare |
| **Gastouder** | 0-4 | Home-based childcare |
| **Peuterspeelzaal** | 2-4 | Playgroup (part-time) |
| **Buitenschoolse opvang (BSO)** | 4-12 | After-school care |

### Costs

| Type | Gross Cost | After Subsidy |
|------|-----------|---------------|
| Full-time daycare | EUR 1,800-2,700/month | EUR 200-800/month |
| Part-time (3 days) | EUR 1,000-1,500/month | EUR 100-400/month |

### Kinderopvangtoeslag (Childcare Benefit)

Government reimburses **33-96%** depending on income:
- Lower income = higher subsidy
- Applied via Belastingdienst
- Both parents must work/study
- Registered daycare only

### Finding Childcare

| Platform | Purpose |
|----------|---------|
| Kinderopvang.nl | Search database |
| Gemeente Amsterdam | Local information |
| Word of mouth | Important in NL |

**Waitlists:** Start searching during pregnancy.

---

##  Primary School (4-12)

### Starting Age

- **4 years old** - Can start
- **5 years old** - Must start (compulsory)

### School Types

| Type | Description |
|------|-------------|
| **Openbaar** | Public, non-religious |
| **Bijzonder** | Religious or philosophical basis |
| **Montessori** | Montessori method |
| **Dalton** | Dalton method |
| **Jenaplan** | Mixed-age groups |

### Dutch vs International

| Factor | Dutch School | International School |
|--------|--------------|---------------------|
| Language | Dutch | English |
| Cost | Free | EUR 15,000-22,000/year |
| Integration | Better for settling | Easier transition |
| Availability | Good | Limited |

### International Primary Schools

| School | Curriculum | Fees/Year |
|--------|------------|-----------|
| ISA Amsterdam | IB PYP | ~EUR 19,000 |
| British School Amsterdam | British | ~EUR 18,000 |
| AICS (International Community School) | IB PYP | ~EUR 16,000 |
| Amity International | IB | ~EUR 15,000 |

### Registration

| School Type | How to Register |
|-------------|-----------------|
| Dutch public | Contact school directly |
| Dutch special | Contact school directly |
| International | Application, often competitive |

**Timing:** Register early (1+ year ahead for popular schools).

---

##  Secondary School (12-18)

### Dutch System Tracks

| Track | Duration | Leads To |
|-------|----------|----------|
| **VMBO** | 4 years | MBO (vocational) |
| **HAVO** | 5 years | HBO (applied university) |
| **VWO** | 6 years | WO (research university) |

### Track Selection

At age 12, students are placed based on:
- Primary school advice (crucial)
- Test scores (CITO)
- Teacher assessment

### International Secondary Schools

| School | Curriculum | Fees/Year |
|--------|------------|-----------|
| ISA Amsterdam | IB MYP/DP | ~EUR 22,000 |
| British School Amsterdam | IGCSE/A-Level | ~EUR 22,000 |
| AICS | IB MYP/DP | ~EUR 18,000 |
| European School | European Bac | Lower (EU-funded) |

---

##  Higher Education

### University Types

| Type | Dutch | Description |
|------|-------|-------------|
| **Research University** | WO | Academic, theory-focused |
| **Applied University** | HBO | Practical, career-focused |

### Amsterdam Universities

| University | Type | Notable For |
|------------|------|-------------|
| **UvA** (University of Amsterdam) | WO | Largest in NL, research |
| **VU Amsterdam** | WO | Research, medical |
| **HvA** (Amsterdam University of Applied Sciences) | HBO | Applied programs |
| **Inholland** | HBO | Applied sciences |

### Tuition Fees (2025-2026)

| Student Type | Annual Fee |
|--------------|------------|
| EU/EEA students | ~EUR 2,500 |
| Non-EU students | EUR 10,000-25,000 |

### English Programs

Many programs taught in English:
- Most master's programs
- Some bachelor's programs
- Growing international focus

---

##  Dutch Language Requirements

### For Students

| Level | Dutch Required? |
|-------|-----------------|
| Dutch primary | Yes |
| Dutch secondary | Yes |
| International schools | No |
| Dutch university (Dutch programs) | Yes |
| Dutch university (English programs) | No |

### Language Integration

| For | Recommendation |
|-----|----------------|
| Short-term stay | International school |
| Long-term/permanent | Consider Dutch school |
| Teenagers | Harder to integrate linguistically |
| Young children | Adapt faster |

---

##  Education Costs Summary

### Public/Dutch Education

| Level | Cost |
|-------|------|
| Primary | Free |
| Secondary | Free |
| University (EU) | ~EUR 2,500/year |

### International Schools

| Level | Annual Range |
|-------|--------------|
| Primary | EUR 15,000-22,000 |
| Secondary | EUR 18,000-28,000 |

### Additional Costs

| Item | Estimate |
|------|----------|
| Books/materials | EUR 300-600/year |
| School trips | EUR 200-500/year |
| Uniforms (if required) | EUR 200-400/year |
| After-school activities | EUR 300-1,000/year |
| Transport | Varies |

---

##  Choosing a School

### Factors to Consider

| Factor | Question |
|--------|----------|
| Duration of stay | <3 years? International better |
| Child's age | Younger = easier integration |
| Dutch plans | Staying permanently? Dutch helpful |
| Budget | International is expensive |
| Location | Commute matters |
| Social network | Expat or local friends? |

### Research Tips

1. Visit schools in person
2. Talk to current parents
3. Check inspection reports (onderwijsinspectie.nl)
4. Consider catchment areas
5. Start early (waitlists are real)

---

##  Academic Calendar

### School Year

| Period | Dates |
|--------|-------|
| Start | Late August/Early September |
| End | Early-Mid July |
| Total | ~40 weeks |

### Holidays

| Holiday | Typical Duration |
|---------|-----------------|
| Autumn (Herfstvakantie) | 1 week (October) |
| Christmas | 2 weeks |
| Spring (Voorjaarsvakantie) | 1 week (February) |
| May/Pentecost | 1-2 weeks |
| Summer | 6 weeks |

---

##  Practical Tips

### For Dutch Schools

- Learn basic Dutch (parents too)
- Engage with school community
- Birthday treats are parent-provided
- Parent volunteering expected

### For International Schools

- Apply early (very competitive)
- Prepare for high costs
- Community is often transient
- Good preparation for global moves

### General Tips

- BSN needed for registration
- Proof of address required
- Vaccination records helpful
- Previous school records may be requested

---

##  Key Contacts

| Organization | Purpose |
|--------------|---------|
| **Gemeente Amsterdam** | School registration info |
| **Onderwijsinspectie** | School quality reports |
| **ACCESS** | Expat education advice |
| **DUO** | Student finance |

---

*Education in Amsterdam offers excellent options from free Dutch schools to premium international institutions. Plan early, especially for international schools or popular Dutch schools.*
