# Cycling in Amsterdam

> The definitive guide to bike culture, ownership, and survival.

---

##  Why Cycling is Essential

### Statistics

| Fact | Number |
|------|--------|
| Bikes in Amsterdam | 880,000+ |
| Population | ~900,000 |
| Daily bike trips | 2 million |
| % of trips by bike | 44% |
| Bike paths | 400+ km |
| Bike parking spots | 1 million |

### Why Bike?

| Reason | Reality |
|--------|---------|
| **Fastest transport** | For trips under 7km |
| **Cheapest** | After initial purchase |
| **Most convenient** | Park anywhere |
| **Healthiest** | Daily exercise |
| **Most Dutch** | Cultural identity |

---

##  Getting a Bike

### Options

| Option | Cost | Pros | Cons |
|--------|------|------|------|
| **Used (Marktplaats)** | EUR 100-300 | Cheapest | Risk of stolen bikes |
| **Used (bike shop)** | EUR 200-500 | Warranty, legitimate | Pricier |
| **New (city bike)** | EUR 400-1,000 | Quality, choice | Theft risk |
| **New (e-bike)** | EUR 1,500-4,000 | Effortless | Expensive, theft target |
| **Swapfiets** | EUR 20/month | Hassle-free | Ongoing cost |
| **OV-fiets** | EUR 4.55/24h | Occasional use | Not your own |

### Bike Types

| Type | Best For | Description |
|------|----------|-------------|
| **Omafiets** | Most people | Classic "granny bike," upright |
| **Stadsfiets** | Commuters | City bike, slightly sportier |
| **Bakfiets** | Families | Cargo bike, kids up front |
| **Elektrische fiets** | Long distances | Electric assist |
| **Racefiets** | Sport | Road bike, not for city |

### Where to Buy Used

| Source | Notes |
|--------|-------|
| **Marktplaats** | Like eBay, buyer beware |
| **RecycledBikes** | Tourist bikes, OK quality |
| **Waterlooplein** | Some legitimate sellers |
| **Local bike shops** | Best option, warranty |

### Where to Buy New

| Shop | Type |
|------|------|
| **Fietsenwinkel.nl** | Chain, good selection |
| **Decathlon** | Budget, decent |
| **Local dealers** | Personal service |
| **Gazelle** | Dutch brand, quality |
| **Batavus** | Dutch brand |

---

##  Bike Security (Critical)

### Theft Reality

| Fact | Number |
|------|--------|
| Bikes stolen/year | 60,000-80,000 |
| Recovery rate | Very low |
| Hotspots | Train stations, nightlife areas |

### Essential: TWO Locks

**Always use TWO locks:**

| Lock Type | Purpose | Cost |
|-----------|---------|------|
| **U-lock** | Frame to fixed object | EUR 30-80 |
| **Chain lock** | Wheel + frame | EUR 30-60 |
| **Cafe lock** | Built-in wheel lock | Often included |

### Locking Rules

1. **Frame to fixed object** - Not just wheel
2. **Both wheels** - Use chain through wheel + frame
3. **Fixed object** - Not removable post
4. **Lit areas** - Better at night
5. **Inside when possible** - Overnight

### Insurance

| Option | Cost | Coverage |
|--------|------|----------|
| **Bike insurance** | EUR 5-15/month | Theft, damage |
| **Home insurance add-on** | Varies | Sometimes included |
| **Swapfiets** | Included | Replacement provided |

---

##  Rules & Laws

### Traffic Rules

| Rule | Details | Fine |
|------|---------|------|
| **Lights at night** | Front + rear required | EUR 95 |
| **No phone** | While cycling | EUR 140 |
| **Hand signals** | For turns | EUR 95 |
| **Right side** | Stay right | EUR 95 |
| **Red lights** | Must stop | EUR 95 |
| **Bell** | Required | EUR 30 |
| **Reflectors** | Required | EUR 30 |

### Right of Way

| Situation | Rule |
|-----------|------|
| **Right-hand priority** | Traffic from right goes first (unless marked) |
| **Trams** | Always have priority |
| **Sharks' teeth** | Give way to traffic on main road |
| **Pedestrian crossings** | Stop for pedestrians |
| **Bike boxes** | Bikes wait ahead of cars |

### Drunk Cycling

Technically illegal but:
- Rarely enforced for bikes
- Can be fined up to EUR 450
- Use good judgment
- Walk if truly impaired

---

##  Cycling Infrastructure

### What to Know

| Feature | Description |
|---------|-------------|
| **Fietspaden** | Separated bike paths (red surface) |
| **Fietsstrook** | Bike lanes on road |
| **Fietsstraat** | Bike street (cars guest) |
| **Fietsverkeerslicht** | Bike traffic lights |
| **Fietsenstalling** | Bike parking garage |

### Navigation

| Tool | Notes |
|------|-------|
| **Google Maps (cycling)** | Best routes, directions |
| **Apple Maps** | Cycling mode available |
| **Signage** | Green ANWB signs with destinations |

### Route Tips

1. **Main roads have bike paths** - Usually next to road
2. **Canals** - Often good routes
3. **Parks** - Usually have paths through
4. **Avoid tram tracks** - Wheels can get stuck

---

##  Cycling in Weather

### Rain (Most Days)

| Strategy | Details |
|----------|---------|
| **Rain jacket** | Essential, breathable |
| **Rain pants** | Over regular clothes |
| **Mudguards** | Prevent spray |
| **Waterproof bag** | For belongings |
| **Skip umbrella** | Doesn't work with wind |

### Wind

| Direction | Experience |
|-----------|------------|
| **Headwind** | Exhausting, slower |
| **Tailwind** | Glorious, fast |
| **Crosswind** | Be careful |

### Winter

| Condition | Advice |
|-----------|--------|
| **Cold** | Layers, gloves, warm headwear |
| **Ice** | Cycle carefully or walk |
| **Snow** | Paths usually cleared |
| **Dark** | Good lights essential |

---

##  Cycling Culture

### Dutch Norms

| Norm | Reality |
|------|---------|
| **No helmets** | Almost no one wears them |
| **Normal clothes** | Not cycling gear |
| **Talking while riding** | Standard |
| **Carrying things** | On bike, not backpack |
| **Kids on bike** | Normal, various setups |
| **Elderly cycling** | Very common |

### Kids & Bikes

| Age | Setup |
|-----|-------|
| **Baby** | Front seat (Maxi-Cosi) |
| **Toddler** | Front or back seat |
| **Child** | Back seat or own bike |
| **Multiple kids** | Bakfiets (cargo bike) |

### Family Cycling

| Bike Type | Kids Capacity |
|-----------|---------------|
| **Bakfiets** | 2-4 in front box |
| **Longtail** | 1-2 on back |
| **Seats** | 1 front + 1 back |

---

##  Maintenance

### DIY Basics

| Task | Frequency |
|------|-----------|
| **Tire pressure** | Monthly |
| **Chain oil** | Monthly |
| **Brake check** | Monthly |
| **Light batteries** | As needed |

### Bike Shops (Fietsenmaker)

| Service | Cost |
|---------|------|
| Flat tire repair | EUR 15-25 |
| Chain replacement | EUR 20-40 |
| Full service | EUR 40-80 |
| Brake adjustment | EUR 10-20 |

### Common Issues

| Issue | Solution |
|-------|----------|
| **Flat tire** | Repair kit or shop |
| **Rusty chain** | Replace |
| **Squeaky brakes** | Adjustment |
| **Stuck gears** | Cable adjustment |

---

##  Parking

### Where to Park

| Location | Type |
|----------|------|
| **Street racks** | Free, everywhere |
| **Fietsenstalling** | Guarded parking |
| **Centraal Station** | 11,000 spots free 24h |
| **Major stations** | Usually have garages |
| **Your building** | Varies |

### Parking Tips

1. Use designated racks when possible
2. Don't block pedestrians
3. Avoid hazardous spots (canal edges)
4. Check for "no parking" signs
5. Some areas remove illegally parked bikes

### Bike Removal

If your bike is removed:
- Call 14020 (gemeente Amsterdam)
- Describe your bike
- Pay EUR 22.50 retrieval fee
- Collect from depot

---

##  Bike-Sharing

### Options

| Service | Type | Cost |
|---------|------|------|
| **OV-fiets** | NS train integration | EUR 4.55/24h |
| **Swapfiets** | Subscription | EUR 20/month |
| **Donkey Republic** | App-based sharing | ~EUR 1/hour |

### OV-fiets

Best for occasional use:
- Pick up at train stations
- Return to any station
- Need OV-chipkaart + subscription
- EUR 4.55 per 24 hours

### Swapfiets

Best for hassle-free ownership:
- Fixed monthly fee
- Repair/replace included
- Theft partially covered
- Various bike types

---

##  Common Mistakes

| Mistake | Consequence |
|---------|-------------|
| **One lock** | Bike stolen |
| **No lights** | Fine + danger |
| **Phone use** | Fine + danger |
| **Wrong side** | Accidents |
| **Ignoring trams** | Dangerous |
| **Cheap bike** | Constant issues |
| **Not signaling** | Accidents |
| **Tram tracks** | Wheel stuck = crash |

---

##  Useful Apps

| App | Purpose |
|-----|---------|
| **Google Maps** | Cycling navigation |
| **9292** | If bike fails, public transport |
| **Buienradar** | Avoid rain |
| **Marktplaats** | Buy/sell bikes |

---

##  Pro Tips

1. **Get a Dutch-style bike** - More comfortable than road/hybrid
2. **Invest in good locks** - More than the bike if needed
3. **Lights are non-negotiable** - Police do ticket
4. **Rain gear pays off** - Good gear = year-round cycling
5. **Watch for tourists** - They don't know the rules
6. **Ring your bell** - Politely warn pedestrians
7. **Go with the flow** - Follow Dutch cyclists
8. **Accept bike will age** - Don't baby it
9. **Learn basic repairs** - Flat tire fix is essential
10. **Embrace it** - Cycling is the best way to live here

---

*Cycling isn't just transport in Amsterdam-it's identity. Invest in a decent bike, good locks, and proper gear. It will transform your experience.*
