# Amsterdam Cost of Living Guide 2025-2026

> Last updated: February 2026 | Currency: EUR (EUR ) | Tax: 36.97%-49.5% income tax

---

## Overview

Amsterdam ranks **#8 globally** for expat cost of living (Mercer 2025). It's expensive by European standards but offers excellent quality of life, efficient public services, and good work-life balance.

### Quick Summary

| Profile | Monthly Cost (EUR) |
|---------|-------------------|
| **Single person** (excl. rent) | EUR 1,400-1,800 |
| **Family of 4** (excl. rent) | EUR 3,500-4,500 |
| **Single person** (total) | EUR 2,800-4,500 |
| **Couple** (total) | EUR 4,000-6,000 |
| **Family of 4** (total) | EUR 6,000-9,000 |

---

##  Housing (Biggest Expense: 35-50% of budget)

### Rental Prices (Monthly Average - Feb 2026)

| Property Type | City Center | Outside Center |
|---------------|-------------|----------------|
| **Studio** | EUR 1,400-1,800 | EUR 1,000-1,400 |
| **1 Bedroom** | EUR 1,800-2,500 | EUR 1,400-1,800 |
| **2 Bedroom** | EUR 2,500-3,800 | EUR 1,800-2,600 |
| **3 Bedroom** | EUR 3,500-5,500 | EUR 2,400-3,500 |

**Average from Numbeo (Feb 2026):**
- 1BR City Center: **EUR 2,204**
- 1BR Outside Center: **EUR 1,717**
- 3BR City Center: **EUR 3,479**
- 3BR Outside Center: **EUR 2,655**

### Rent by Neighborhood (1BR Monthly)

| Neighborhood | Price Range |
|--------------|-------------|
| Centrum | EUR 1,800-2,800 |
| Jordaan | EUR 2,000-2,800 |
| De Pijp | EUR 1,700-2,400 |
| Oud-Zuid | EUR 2,000-3,000 |
| Oud-West | EUR 1,600-2,300 |
| Oost | EUR 1,500-2,100 |
| Noord | EUR 1,200-1,600 |
| Zuidoost | EUR 1,000-1,500 |
| Amstelveen | EUR 1,300-1,800 |

### Housing Market Reality

The Amsterdam housing market is **extremely tight**:

| Factor | Reality |
|--------|---------|
| Vacancy rate | <2% |
| Applications per listing | 50-200 |
| Required income | 3-4x monthly rent |
| Social housing waitlist | 10-15+ years |

### Housing Costs Beyond Rent

| Expense | Cost | Notes |
|---------|------|-------|
| **Deposit** | 1-2 months rent | Refundable |
| **Agency fee** | 0-1 month rent | Often illegal to charge tenants |
| **Administration** | EUR 50-150 | One-time |
| **Contract stamp** | EUR 0-50 | Sometimes required |

### Buying vs Renting

| Factor | Buy | Rent |
|--------|-----|------|
| Price/sqm (city) | EUR 9,000-11,000 | EUR 25-35/sqm monthly |
| Price/sqm (suburbs) | EUR 5,500-8,000 | EUR 18-25/sqm monthly |
| Mortgage rate | 3.5-4.5% (2026) | - |
| Down payment | Usually 0-10% | - |
| Transaction costs | ~5% of price | - |

---

##  Utilities

### Monthly Bills (85sqm Apartment)

| Utility | Cost | Notes |
|---------|------|-------|
| **Electricity + Gas** | EUR 180-280 | Energy crisis impact lingering |
| **Water** | EUR 40-60 | Waternet |
| **Total** | EUR 220-340 | Varies by usage and insulation |

**Average from Numbeo:** EUR 268/month for 85sqm apartment

### Internet & Phone

| Service | Monthly Cost |
|---------|--------------|
| **Broadband (60+ Mbps)** | EUR 40-60 |
| **Mobile (10GB+)** | EUR 15-35 |
| **Bundle (internet + TV)** | EUR 60-100 |

**Providers:** KPN, Ziggo, T-Mobile, Odido (formerly T-Mobile), Vodafone

---

##  Food & Groceries

### Grocery Prices (Feb 2026)

| Item | Price (EUR) |
|------|-------------|
| Milk (1L) | EUR 1.46 |
| Bread (500g) | EUR 2.41 |
| Eggs (12) | EUR 4.54 |
| Rice (1kg) | EUR 2.54 |
| Chicken (1kg) | EUR 12.55 |
| Beef (1kg) | EUR 20.74 |
| Apples (1kg) | EUR 3.11 |
| Bananas (1kg) | EUR 2.46 |
| Tomatoes (1kg) | EUR 3.50 |
| Potatoes (1kg) | EUR 1.83 |
| Cheese local (1kg) | EUR 12.69 |
| Water (1.5L) | EUR 1.36 |
| Wine (mid-range bottle) | EUR 6.00 |
| Beer domestic (0.5L) | EUR 1.61 |
| Cigarettes (Marlboro) | EUR 12.50 |

### Monthly Grocery Budget

| Profile | Budget (EUR) |
|---------|--------------|
| Single (budget) | EUR 200-300 |
| Single (comfortable) | EUR 300-400 |
| Couple | EUR 400-600 |
| Family of 4 | EUR 600-900 |

### Supermarket Tiers

| Tier | Stores | Price Level |
|------|--------|-------------|
| Budget | Lidl, Aldi, Dirk | Cheapest |
| Mid-range | Albert Heijn, Jumbo | Standard, good quality |
| Premium | AH XL, Marqt, Ekoplaza | Organic, specialty |

### Dining Out (Feb 2026)

| Type | Cost per person |
|------|----------------|
| Inexpensive restaurant | EUR 15-25 |
| Mid-range (2-course) | EUR 35-50 |
| Fine dining | EUR 80-150+ |
| Fast food combo | EUR 12-15 |
| Coffee (cappuccino) | EUR 3.50-5.00 |
| Beer (restaurant, 0.5L) | EUR 5-7 |
| Cocktail | EUR 12-18 |

---

##  Transportation

### Cycling (Primary Mode)

| Item | Cost |
|------|------|
| Good used bike | EUR 200-500 |
| New city bike | EUR 400-1,000 |
| Electric bike (new) | EUR 1,500-4,000 |
| Annual maintenance | EUR 50-100 |
| Good locks (essential) | EUR 50-100 |
| Bike insurance | EUR 5-15/month |

### Public Transport (GVB + NS)

| Pass | Monthly Cost |
|------|--------------|
| GVB Amsterdam only | EUR 99 |
| GVB (anonymous OV-chip) | EUR 3.20 per ride |
| NS Dal Voordeel (off-peak train) | EUR 5.40/month + 40% discount |
| NS Flex (all trains) | EUR 40/month + cheaper rides |

**From Numbeo:** Monthly pass EUR 90

### Car Ownership

| Expense | Annual Cost |
|---------|-------------|
| Insurance | EUR 500-1,200 |
| Road tax (wegenbelasting) | EUR 300-600 |
| Parking permit | EUR 400-600 (if available) |
| Parking (center) | EUR 5-8/hour, EUR 40-80/day |
| Fuel (per liter) | EUR 1.97 |

**Verdict:** Car ownership is expensive and often unnecessary in Amsterdam. Most residents don't own one.

### Taxi/Ride-Hailing

| Service | Base + Per km |
|---------|---------------|
| Taxi | EUR 4.15 + EUR 3.00/km |
| Uber/Bolt | Slightly cheaper |

---

##  Healthcare

### Mandatory Health Insurance

**Required for all residents:** Basic health insurance (basiszorgverzekering)

| Item | Cost |
|------|------|
| Basic insurance | EUR 140-170/month |
| Own risk (eigen risico) | EUR 385/year (mandatory excess) |
| Supplementary (aanvullend) | EUR 20-100/month extra |

### Out-of-Pocket Costs (After Insurance)

| Service | Cost |
|---------|------|
| GP (huisarts) visit | EUR 0 (covered) |
| Specialist (after referral) | EUR 0 (covered, after eigen risico) |
| Dental (basic) | Not covered - EUR 50-150/visit |
| Physiotherapy | Partly covered - EUR 30-60/session |
| Prescription drugs | Usually covered after eigen risico |

### Healthcare Allowance

Low-income residents can receive zorgtoeslag:
- Max ~EUR 154/month (single) or EUR 297/month (couple)
- Income-dependent
- Apply via Belastingdienst

---

##  Family Costs

### Childcare

| Type | Monthly Cost (Gross) |
|------|---------------------|
| Daycare (full-time) | EUR 1,800-2,700 |
| Daycare (3 days/week) | EUR 1,000-1,500 |
| After-school care (BSO) | EUR 400-800 |

**Kinderopvangtoeslag (childcare benefit):**
- Government reimburses 33-96% depending on income
- Actual cost after subsidy: EUR 200-800/month

### Education

| Type | Annual Cost |
|------|-------------|
| Public school | EUR 0 |
| Dutch private school | EUR 3,000-8,000 |
| International primary school | EUR 15,000-22,000 |
| International secondary school | EUR 20,000-28,000 |

**From Numbeo:** International primary school ~EUR 17,786/year

### Nursery/Preschool

| Type | Monthly Cost |
|------|--------------|
| Peuterspeelzaal (2-4 years) | EUR 150-400 |
| Private nursery | EUR 2,000-3,000 |

---

##  Lifestyle & Entertainment

### Monthly Costs

| Activity | Cost |
|----------|------|
| Gym membership | EUR 30-80 |
| Cinema ticket | EUR 13-16 |
| Streaming (Netflix) | EUR 13-18 |
| Spotify | EUR 11 |
| Tennis court (1hr) | EUR 25-40 |
| Swimming pool | EUR 5-8/visit |

### Shopping

| Item | Price |
|------|-------|
| Jeans (Levi's) | EUR 70-120 |
| Summer dress (Zara) | EUR 35-60 |
| Nike running shoes | EUR 90-140 |
| Haircut (men) | EUR 20-40 |
| Haircut (women) | EUR 50-100 |

---

##  Monthly Budget Breakdown

### Single Professional (EUR 75K salary)

| Category | Budget | Low | High |
|----------|--------|-----|------|
| Rent (1BR) | EUR 1,900 | EUR 1,500 | EUR 2,300 |
| Utilities + Internet | EUR 150 | EUR 120 | EUR 180 |
| Health insurance | EUR 150 | EUR 140 | EUR 180 |
| Groceries | EUR 350 | EUR 250 | EUR 450 |
| Transport (bike + occasional) | EUR 50 | EUR 20 | EUR 100 |
| Dining/Drinks | EUR 400 | EUR 200 | EUR 600 |
| Entertainment | EUR 200 | EUR 100 | EUR 300 |
| Misc/Savings | EUR 400 | EUR 200 | EUR 600 |
| **Total** | **EUR 3,600** | **EUR 2,530** | **EUR 4,710** |

### Couple (Combined EUR 130K salary)

| Category | Budget |
|----------|--------|
| Rent (2BR) | EUR 2,800 |
| Utilities + Internet | EUR 200 |
| Health insurance (2x) | EUR 300 |
| Groceries | EUR 500 |
| Transport | EUR 80 |
| Dining/Entertainment | EUR 700 |
| Savings/Misc | EUR 800 |
| **Total** | **EUR 5,380** |

### Family of 4 (Combined EUR 150K salary, 2 children)

| Category | Budget |
|----------|--------|
| Rent (3BR) | EUR 3,200 |
| Utilities + Internet | EUR 280 |
| Health insurance | EUR 400 |
| Groceries | EUR 800 |
| Childcare (after subsidy) | EUR 600 |
| Transport | EUR 150 |
| Activities/Entertainment | EUR 400 |
| Savings/Misc | EUR 700 |
| **Total** | **EUR 6,530** |

---

##  Amsterdam vs Other Cities

### Rent Comparison (1BR City Center)

| City | Monthly Rent | vs Amsterdam |
|------|--------------|--------------|
| Amsterdam | EUR 2,204 | - |
| London | EUR 2,400 | +9% |
| Paris | EUR 1,600 | -27% |
| Dublin | EUR 2,200 | 0% |
| Munich | EUR 1,800 | -18% |
| Zurich | EUR 2,800 | +27% |

### Overall Cost Index (NYC = 100)

| City | Index |
|------|-------|
| Amsterdam | 75 |
| London | 80 |
| Paris | 72 |
| NYC | 100 |
| Zurich | 115 |
| Berlin | 62 |

---

##  Money-Saving Tips

1. **Live outside ring:** Noord, Oost, Zuidoost 20-40% cheaper
2. **Bike everywhere:** EUR 0 transport cost, healthier too
3. **Shop at Lidl/Aldi:** 20-30% cheaper than Albert Heijn
4. **Use markets:** Albert Cuyp, Dappermarkt for produce
5. **Apply for allowances:** Zorgtoeslag, huurtoeslag if eligible
6. **Get NS discount card:** EUR 5.40/month = 40% off trains
7. **Happy hours:** Many bars have 2-for-1 before 7pm
8. **Use Tikkie:** Dutch payment app for splitting bills
9. **Second-hand bikes:** Marktplaats or bike shops
10. **Cook at home:** Restaurant portions are small anyway

---

##  Common Financial Traps

1. **Rent upfront:** Budget 2-3 months rent initially
2. **Health insurance:** Mandatory from day 1, fines if not enrolled
3. **Bike theft:** Budget for good locks or bike insurance
4. **Dining out:** Small portions, expensive compared to home cooking
5. **Energy bills:** Old buildings = poor insulation = high bills
6. **Tourist trap restaurants:** Avoid Leidseplein, Rembrandtplein
7. **Speeding/parking fines:** Strict enforcement
8. **Currency exchange:** Use Wise, not banks

---

##  Minimum Salary Recommendations

| Profile | Minimum (Gross/year) | Comfortable |
|---------|---------------------|-------------|
| Single | EUR 50,000 | EUR 70,000+ |
| Couple (1 income) | EUR 70,000 | EUR 100,000+ |
| Couple (2 incomes) | EUR 90,000 combined | EUR 130,000+ |
| Family (2 children) | EUR 100,000 | EUR 140,000+ |

**With 30% ruling:** Reduce requirements by ~20%

---

*Sources: Numbeo (Feb 2026), CBS Statistics Netherlands, Belastingdienst, Pararius, Funda*
