# Business Setup & Freelancing in Amsterdam

> Starting a company, freelancing, and business regulations in the Netherlands.

---

##  Business Structures

### Company Types

| Type | Dutch Name | Liability | Capital | Best For |
|------|------------|-----------|---------|----------|
| **Sole proprietor** | Eenmanszaak | Unlimited | None | Freelancers |
| **Partnership** | VOF | Unlimited | None | Small partnerships |
| **Private company** | BV | Limited | EUR 0.01+ | Most businesses |
| **Public company** | NV | Limited | EUR 45,000 | Large companies |
| **Foundation** | Stichting | Limited | None | Non-profits |

### BV vs Eenmanszaak

| Factor | BV | Eenmanszaak |
|--------|-----|-------------|
| **Liability** | Limited | Personal |
| **Tax rate** | 19%/25.8% corp | Income tax (up to 49.5%) |
| **Setup cost** | EUR 500-2,000 | Free |
| **Administration** | More complex | Simple |
| **Credibility** | Higher | Lower |
| **30% ruling** | Can use | Not applicable |

### When to Choose What

| Situation | Recommended |
|-----------|-------------|
| **Solo freelancer, low risk** | Eenmanszaak |
| **High income (EUR 100K+)** | BV (tax advantage) |
| **External investors** | BV |
| **Employees** | BV |
| **Professional services** | Either |
| **Startup with funding** | BV |

---

##  Setting Up a BV

### Steps

| Step | Timeframe | Cost |
|------|-----------|------|
| 1. Reserve company name | 1 day | Free |
| 2. Draft articles of association | 1-2 weeks | EUR 300-800 |
| 3. Notary deed | 1 day | EUR 500-1,000 |
| 4. Register with KvK | Same day | EUR 75 |
| 5. Register with tax office | Automatic | Free |
| 6. Open bank account | 1-2 weeks | Varies |
| **Total** | 2-4 weeks | EUR 800-2,000 |

### Requirements

| Requirement | Details |
|-------------|---------|
| **Share capital** | EUR 0.01 minimum |
| **Director** | Can be non-resident |
| **Shareholder** | At least one |
| **Registered address** | Dutch address required |
| **Notary** | Required for incorporation |

### Using Formation Agents

| Agent | Cost | Services |
|-------|------|----------|
| **Ligo** | EUR 400-800 | Online, fast |
| **Firm24** | EUR 500-1,000 | Full service |
| **Intercompany Solutions** | EUR 500-1,500 | Expat-focused |
| **Local notary** | EUR 800-1,500 | Traditional |

---

##  Registration (KvK)

### What is KvK?

**Kamer van Koophandel** (Chamber of Commerce) - Mandatory registration for all businesses.

### What You Get

| Item | Purpose |
|------|---------|
| **KvK number** | Company identifier |
| **RSIN** | Tax identification |
| **Trade name** | Official business name |

### Registration Process

1. Visit KvK office or online
2. Bring ID, company documents
3. Receive KvK number
4. Automatic tax registration follows

---

##  Freelancing (ZZP)

### What is ZZP?

**Zelfstandige Zonder Personeel** - Self-employed without employees.

### Setting Up

| Step | Details |
|------|---------|
| 1. Register at KvK | As Eenmanszaak |
| 2. Get BTW number | VAT registration |
| 3. Open business account | Separate from personal |
| 4. Get invoicing setup | Software or templates |
| 5. Start working | Send invoices |

### Tax Obligations

| Tax | Rate/Details |
|-----|--------------|
| **Income tax** | Progressive (36.97%-49.5%) |
| **BTW (VAT)** | 21% (or exempt) |
| **ZVW** | Health insurance contribution |

### Deductions (Aftrekposten)

| Deduction | Amount |
|-----------|--------|
| **Zelfstandigenaftrek** | ~EUR 5,030/year |
| **Startersaftrek** | Extra ~EUR 2,123 (first 3 years) |
| **MKB-winstvrijstelling** | 13.31% of profit |
| **Business expenses** | 100% of eligible costs |

### Freelance Rates

| Role | Typical Hourly |
|------|----------------|
| **Software developer** | EUR 75-150 |
| **Designer** | EUR 60-120 |
| **Consultant** | EUR 80-200 |
| **Marketing** | EUR 50-100 |
| **Writer/Editor** | EUR 40-80 |

---

##  VAT (BTW)

### Rates

| Rate | Applies To |
|------|------------|
| **21%** | Standard goods/services |
| **9%** | Food, books, hotels |
| **0%** | Exports, some services |

### Registration

| Situation | Required |
|-----------|----------|
| **Revenue under EUR 20K** | Optional (Kleineondernemersregeling) |
| **Revenue over EUR 20K** | Mandatory |
| **B2B services EU** | Reverse charge applies |

### Filing

| Type | Frequency |
|------|-----------|
| **Standard** | Quarterly |
| **High volume** | Monthly |
| **Low volume** | Annually |

---

##  Corporate Tax

### Rates (2025-2026)

| Profit | Rate |
|--------|------|
| Up to EUR 200,000 | 19% |
| Above EUR 200,000 | 25.8% |

### Innovatiebox

| Benefit | 9% tax rate on qualifying IP income |
|---------|-------------------------------------|
| **Eligibility** | R&D activities, patents |
| **Application** | Through WBSO first |

---

##  Working From Home

### Office Requirements

| Situation | What You Need |
|-----------|---------------|
| **Freelance/ZZP** | Home office fine |
| **BV** | Registered address (can be home) |
| **Virtual office** | Available from EUR 50/month |
| **Co-working** | Many options |

### Co-working Spaces

| Space | Location | Monthly |
|-------|----------|---------|
| **WeWork** | Various | EUR 400-800 |
| **Spaces** | Various | EUR 350-600 |
| **B. Amsterdam** | Zuidoost | EUR 200-400 |
| **TQ** | Centrum | EUR 300-500 |
| **Zoku** | Oost | EUR 400-600 |

---

##  Hiring Employees

### Obligations

| Requirement | Details |
|-------------|---------|
| **Employment contract** | Required |
| **Minimum wage** | ~EUR 14/hour (2026) |
| **Vacation days** | Min 4 weeks |
| **Sick pay** | 70-100% for 2 years |
| **Pension** | Often mandatory |
| **Payroll admin** | Required |

### Employment Costs

| On Top of Salary | Approximate |
|------------------|-------------|
| **Social security** | ~18% |
| **Pension** | ~10-15% |
| **Holiday pay** | 8% |
| **Admin** | Varies |
| **Total** | +35-45% of gross |

### Hiring Non-EU

| Requirement | Process |
|-------------|---------|
| **HSM visa** | Employer must be recognized sponsor |
| **Application** | IND process |
| **Salary threshold** | Must meet minimum |

---

##  Banking for Business

### Business Accounts

| Bank | Best For | Monthly |
|------|----------|---------|
| **ING** | Traditional | EUR 10-30 |
| **ABN AMRO** | Traditional | EUR 10-35 |
| **Rabobank** | Traditional | EUR 10-30 |
| **bunq** | Digital, fast | EUR 10-20 |
| **Revolut Business** | Multi-currency | EUR 0-25 |

### Opening Requirements

| Document | Needed |
|----------|--------|
| KvK registration | Yes |
| ID of directors | Yes |
| Proof of address | Yes |
| Business plan | Sometimes |

---

##  Invoicing

### Required Elements

| Element | Dutch Term |
|---------|------------|
| Your company name | Bedrijfsnaam |
| Your KvK number | KvK-nummer |
| Your VAT number | BTW-nummer |
| Invoice number | Factuurnummer |
| Invoice date | Factuurdatum |
| Client details | Klantgegevens |
| Description | Omschrijving |
| Amount | Bedrag |
| VAT amount | BTW bedrag |
| Payment terms | Betalingstermijn |

### Tools

| Tool | Cost |
|------|------|
| **Moneybird** | EUR 12-30/month |
| **InvoiceNinja** | Free/paid |
| **Excel/Google Sheets** | Free |
| **Wave** | Free |

---

##  Visa for Business

### Options

| Visa | Best For |
|------|----------|
| **Self-employment** | Established business (difficult) |
| **Startup visa** | New innovative startups |
| **HSM (own BV)** | Pay yourself HSM salary |
| **EU citizen** | Just register |

### Self-Employment Points

Very difficult to obtain:
- 100 points needed from education, experience, business plan
- Most applicants fail
- Better to use startup visa or BV + HSM

---

##  Accountants

### When Needed

| Situation | Recommendation |
|-----------|----------------|
| **Simple ZZP** | DIY or basic accountant |
| **Complex ZZP** | Accountant recommended |
| **BV** | Accountant essential |
| **Employees** | Accountant essential |

### Costs

| Service | Cost |
|---------|------|
| **Basic ZZP admin** | EUR 500-1,500/year |
| **Full ZZP service** | EUR 1,000-2,500/year |
| **BV accounting** | EUR 2,000-5,000/year |
| **BV + payroll** | EUR 3,000-8,000/year |

### Finding Accountants

- Word of mouth
- Expat-focused firms
- Online services (e.g., Tentoo, Ligo)

---

##  Key Deadlines

| Task | Deadline |
|------|----------|
| **VAT filing** | Monthly or quarterly |
| **Income tax** | May 1 (can extend) |
| **Corporate tax** | 5 months after year-end |
| **Annual accounts** | 12 months after year-end |

---

##  Tips

1. **Start as ZZP** - Easier, switch to BV when income justifies
2. **Separate accounts** - Personal and business
3. **Track everything** - Receipts, invoices, expenses
4. **Get an accountant** - Worth it for tax savings
5. **Understand 30% ruling** - If you qualify, use it
6. **Join entrepreneur networks** - Knowledge sharing
7. **Use Dutch contracts** - English OK but Dutch preferred
8. **Plan for taxes** - Set aside 35-40% of income

---

*The Netherlands is business-friendly with reasonable regulations. Start simple, scale as needed, and get professional advice for complex situations.*
