---
name: Amsterdam
slug: amsterdam
version: 1.0.1
homepage: https://clawic.com/skills/amsterdam
description: Navigate Amsterdam as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"AMS","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Amsterdam for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Centrum, Jordaan, De Wallen | `neighborhoods-centrum.md` |
| De Pijp, Oud-Zuid, Rivierenbuurt | `neighborhoods-south.md` |
| Oud-West, Westerpark, Bos en Lommer | `neighborhoods-west.md` |
| Noord, Oost, IJburg | `neighborhoods-east-north.md` |
| Amstelveen, Buitenveldert, Zuidoost | `neighborhoods-suburban.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Dutch & local cuisine | `food-local.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Dietary, alcohol, practical | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (bikes, trams, trains) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & laws | `safety.md` |
| Weather & survival tips | `climate.md` |
| Local services (banking, BSN) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup & freelancing | `business.md` |
| Visas (HSM, 30% ruling, startup) | `visas.md` |
| Startups & funding | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & insurance | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Cycling & transport ownership | `cycling.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. Housing Crisis Reality
Amsterdam has one of Europe's tightest housing markets:
- **Social housing waitlist**: 10-15+ years average
- **Free sector rental**: Extremely competitive, often 100+ applicants per listing
- **Rent regulation**: Properties <142 points = regulated (max ~EUR 880/month in 2026)
- **Average rent**: EUR 22-30/sqm in free sector; 1BR EUR 1,700-2,500/month
See `cost.md` and `resident.md` for strategies.

### 3. Bike Culture (Essential)
Cycling isn't optional in Amsterdam-it's the primary transport:
- **880,000+ bikes** for 900,000 residents
- **44%** of all trips made by bicycle
- **Bike infrastructure**: Separated lanes, bike traffic lights, parking garages
- **Bike theft**: Very common-always use two locks
- **Right of way**: Bikes have priority over cars in most situations
See `cycling.md` and `transport.md` for details.

### 4. Weather Reality
- **Rain**: Expect it year-round, 175 days/year with precipitation
- **Mild winters**: 2-8C, rarely below -5C, occasional snow
- **Cool summers**: 17-22C average, occasional 30C+ heatwaves
- **Wind**: Constant factor, especially near water
- **Essentials**: Waterproof jacket, rain pants, good shoes-NOT umbrella (wind)
See `climate.md` for monthly breakdown and gear advice.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (Centrum) | EUR 1,800-2,800/month |
| 1BR rent (Outside ring) | EUR 1,400-2,000/month |
| Senior SWE salary | EUR 80,000-130,000/year gross |
| GVB monthly pass | EUR 99 (Amsterdam) |
| Dinner for two (mid-range) | EUR 70-120 |
| International school fees | EUR 15,000-28,000/year |
| Highly Skilled Migrant threshold | EUR 5,688/month (30+), EUR 4,171 (<30) |

### 6. Cost Reality
Amsterdam has high costs but also high salaries:
- **Housing**: 35-50% of budget typical
- **Healthcare**: Mandatory insurance ~EUR 140-180/month
- **Childcare**: Subsidized but expensive-EUR 1,500-2,700/month gross before subsidies
- **Food**: Groceries 20-30% cheaper than UK/US
- **Transport**: Cheap if biking (most do); EUR 99/month for unlimited GVB
- **Taxes**: 36.97%-49.5% income tax (but 30% ruling can help)

### 7. Transit Excellence
Unlike most cities, Amsterdam is NOT car-centric:
- **Cycling**: Primary mode, extensive infrastructure
- **Trams/Metro/Buses**: GVB runs frequent service citywide
- **Trains (NS)**: Excellent connections nationwide
- **OV-chipkaart**: Single card for all public transport in NL
- **Car**: Actively discouraged-parking EUR 50-80/day in center
Most residents don't own cars. See `transport.md` and `cycling.md`.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | De Pijp, Oud-West, Oost |
| Families | Oud-Zuid, Amstelveen, IJburg |
| Budget-conscious | Noord, Zuidoost, New West |
| Nightlife seekers | De Pijp, Jordaan, Centrum |
| Tech workers | Zuidoost (tech hub), Oost, Amstelveen |
| Quiet/Upscale | Oud-Zuid, Apollobuurt, Museumkwartier |
| Students | Oost, Noord, De Pijp |

## 30% Ruling Changes (Critical for Expats)

The 30% ruling (tax benefit for highly skilled migrants) is being phased down:
- **2024-2026**: 30% for first 20 months -> 20% for months 21-40 -> 10% for months 41-60
- **Pre-2024 arrivals**: May retain old 30% for full 5 years (grandfathered)
- **Requirements**: HSM visa, recruited from abroad, specific expertise
- **Impact**: Effective tax reduction of EUR 10,000-30,000/year depending on salary
See `visas.md` for detailed eligibility and calculations.

## Amsterdam-Specific Traps

- **Housing scams** - Never pay before viewing. Never wire money abroad. Verify landlord ownership.
- **Tourist tax** - EUR 3/night + 7% of room price. Budget for it.
- **Bike theft** - Use TWO locks (frame + wheel). Budget EUR 500+ for a decent used bike.
- **Coffee vs Coffeeshop** - "Coffee shop" (two words) = cafe. "Coffeeshop" (one word) = cannabis.
- **Hard drugs** - Illegal. Cocaine, MDMA, etc. carry serious penalties despite reputation.
- **Right-hand priority** - Vehicles from right have priority unless marked otherwise. Crucial for cyclists.
- **Canal swimming** - Legal but water quality is poor. Stick to designated swim spots.
- **Tipping** - Not expected. Round up or add 5-10% for exceptional service only.
- **Shop hours** - Many shops close at 6pm. Supermarkets: till 10pm. Sunday closures common.
- **Directness** - Dutch people are famously direct. It's cultural, not rude.
- **Appointments** - Everything requires scheduling. Don't drop by unannounced.

## Legal Awareness

Key laws visitors/residents must know:
- **Cannabis**: Legal to buy/consume in licensed coffeeshops only. Max 5g purchase. No smoking in public.
- **Magic mushrooms**: Illegal since 2008. Truffles (sclerotia) are legal and sold in smart shops.
- **Prostitution**: Legal and regulated in designated areas (De Wallen). Photography prohibited.
- **Alcohol**: Legal at 18+. No public drinking in designated zones. DUI limit: 0.5% (0.2% for new drivers).
- **Cycling laws**: Lights required at night, no phone use, hand signals for turns.
- **Photography**: Legal in public, but respect red-light district rules and ask for portraits.
- **Noise**: Quiet hours 10pm-7am. Neighbors will complain. Dutch take this seriously.
- **Airbnb**: Max 30 nights/year for entire home. Registration required. Fines up to EUR 20,000.

See `safety.md` for comprehensive legal guidance.

## LGBTQ+ Friendliness

Amsterdam is one of the world's most LGBTQ+-friendly cities:
- First country to legalize same-sex marriage (2001)
- Large queer community centered around Reguliersdwarsstraat
- Amsterdam Pride (first weekend of August) is major event
- No legal or social barriers; full acceptance in daily life
- Excellent resources, nightlife, and community organizations
