# Seller Operations

## Listing Optimization

**Title formula:**
```
[Brand] [Product] [Key Feature] [Size/Quantity] [Color/Variant]
```
- 200 characters max
- Front-load important keywords
- No promotional language ("best", "top-rated")

**Bullet points:**
- 5 bullets, each 200-250 characters
- Start with benefit, support with feature
- Include keywords naturally
- Address top customer questions

**Backend keywords:**
- 250 bytes limit
- No repetition of title words
- Include misspellings, synonyms
- No competitor brand names (TOS violation)

## FBA vs FBM Decision

| Factor | FBA Better | FBM Better |
|--------|------------|------------|
| Volume | High, consistent | Low or variable |
| Size | Standard, lightweight | Oversized, heavy |
| Margins | Can absorb fees | Tight margins |
| Prime | Required for category | Less important |
| Control | Less needed | Returns handling critical |

## Inventory Management

**Restock triggers:**
- 30-day supply threshold (adjustable)
- Lead time buffer (supplier → Amazon)
- Seasonal demand spikes planned

**Stockout prevention:**
- FBA storage limits check before shipping
- Split shipments risk assessment
- IPI score monitoring

**Overstock problems:**
- Long-term storage fees (after 365 days)
- Aged inventory surcharge
- Liquidation vs removal decision

## Pricing Strategy

**Competitive pricing:**
- Track Buy Box winner price
- Factor in shipping for FBM competitors
- Don't race to bottom — consider margin floors

**Dynamic pricing rules:**
- Match competitor floor (with min margin)
- Reduce aged inventory gradually
- Seasonal adjustments automated

## Review Management

**Soliciting reviews (TOS compliant):**
- Use "Request a Review" button (official)
- Amazon Vine for new products (paid program)
- Product inserts: thank + support info only (no review solicitation)

**Responding to negatives:**
- Acknowledge issue professionally
- Offer resolution path
- Don't argue, don't offer compensation in public
- Fix root cause if pattern emerges

## Hijacker Detection

**Signs of hijacking:**
- Sudden negative reviews about "wrong product"
- Price dramatically undercut by unknown seller
- Buy Box lost to new seller

**Response:**
- Test buy to document
- Report to Amazon with evidence
- Brand Registry for ongoing protection

## PPC Advertising Basics

**Campaign types:**
- Sponsored Products: Product-level, keyword targeting
- Sponsored Brands: Brand awareness, headline search
- Sponsored Display: Retargeting, competitor targeting

**Optimization:**
- Start auto campaigns, harvest converting keywords
- Negative exact match for wasted spend
- ACoS targets by product lifecycle stage
