# Buying Workflows

## Product Research Process

1. **Understand need** — What problem? Budget? Timeline?
2. **Initial search** — Broad terms, note top categories
3. **Filter ruthlessly** — Prime, rating ≥4.0, price range
4. **Deep-dive top 3** — Full review analysis, Q&A section
5. **Price check** — Is current price good historically?
6. **Recommend** — One pick with reasoning, alternatives noted

## Review Analysis — Detecting Real Quality

**Red flags for fake reviews:**
- Burst of 5-star reviews in short period
- Generic praise without specific product details
- Reviewer has only reviewed products from one brand
- "I received this product for free" disclaimers
- Broken English with excessive enthusiasm

**Finding real signal:**
- Focus on 3-4 star reviews (balanced perspectives)
- Look for verified purchases
- Check reviewer history (real people buy diverse products)
- Read the negative reviews — are complaints about the product or shipping?

## Comparison Framework

When comparing products, build matrix:

| Factor | Product A | Product B | Weight |
|--------|-----------|-----------|--------|
| Price | $X | $Y | High |
| Rating | 4.3 (2k) | 4.5 (500) | Medium |
| Key feature | Has X | Missing X | Critical |
| Warranty | 2 year | 1 year | Low |

Weight factors by user priority. Don't just pick highest rating — context matters.

## Reorder Workflow

1. **Find previous order** — Order history, identify exact product
2. **Check current price** — Compare to what was paid
3. **Price changed?** — Alert if >10% increase
4. **Subscribe & Save** — Suggest if recurring (usually 5-15% off)
5. **Confirm** — Show total, delivery estimate, get approval
6. **Execute** — Place order, confirm order number

## Consumables Management

Track recurring purchases:
- Estimated depletion date based on last order interval
- Proactive reminder before running out
- Price watch for deals before scheduled reorder

## Deal Evaluation

Before recommending a "deal":

1. **Check price history** — Was it this price 2 weeks ago?
2. **Calculate real discount** — From typical price, not "list price"
3. **Lightning deal?** — Time pressure real or artificial?
4. **Coupon stacking** — Any applicable coupons?
5. **Subscribe & Save** — Often beats "sale" price

**Never trust:**
- "List price" claims (often inflated)
- "X% claimed" percentages
- Lightning deal urgency alone
