# Amazon Associates

## Link Generation

**Standard affiliate link format:**
```
https://www.amazon.com/dp/[ASIN]?tag=[your-tag]
```

**Shortened format:**
```
https://amzn.to/[short-code]
```
Use Amazon's link shortener from Associates dashboard.

## Commission Tiers

**Higher commission categories (typically 4-10%):**
- Amazon Games
- Luxury Beauty
- Luxury Stores Fashion
- Digital Music
- Physical Books

**Lower commission categories (1-3%):**
- Electronics
- Computers
- TV & Video
- Video Games (physical)

**Strategy:** Guide content toward higher-commission categories when authentic.

## Disclosure Requirements

**FTC mandates clear disclosure:**
- "As an Amazon Associate, I earn from qualifying purchases"
- Must be visible BEFORE affiliate links
- Not buried in footer — near content with links

**Platform-specific:**
- YouTube: Verbal + description
- Blog: Header or inline before first link
- Social: In post, not just bio

## Content Strategies

**What converts:**
- Comparison posts ("X vs Y")
- Best-of lists ("Best Z under $100")
- Problem-solution ("How to fix X")
- Reviews with real usage

**What doesn't convert:**
- Generic product dumps
- Outdated recommendations
- Products you haven't used/researched
- Over-linking (every word a link)

## Tracking & Optimization

**Key metrics:**
- Click-through rate by content/placement
- Conversion rate by product category
- Earnings per click
- Bounce products (clicked but not bought)

**Optimization tactics:**
- Test link placement (inline vs buttons)
- Update old posts with current prices
- Remove discontinued products
- Seasonal content refresh

## Common Violations (Account Risk)

**Don't do:**
- Cloaking links
- Incentivizing clicks ("click here for surprise")
- Using links in email (prohibited)
- Masking affiliate nature
- Links in PDFs (often prohibited)

**Safe practices:**
- Clear disclosure every time
- Links only on approved platforms
- No price guarantees (prices change)
- Update content quarterly minimum
