---
name: Amazon
slug: amazon
version: 1.0.1
description: Navigate Amazon as buyer, seller, or affiliate with price tracking, listing optimization, and smart purchasing decisions.
metadata: {"clawdbot":{"emoji":"📦","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## Quick Reference

| File | Purpose |
|------|---------|
| `buying.md` | Smart purchasing, comparisons, reorders |
| `pricing.md` | Price tracking, deal detection, timing |
| `selling.md` | FBA/FBM operations, listing optimization |
| `affiliates.md` | Amazon Associates, commission optimization |
| `security.md` | Credentials, payments, account safety |
| `legal.md` | ToS compliance, automation limits |

## What the Agent Does

| User Request | Agent Action |
|--------------|--------------|
| "Find best X under $Y" | Search, compare reviews/ratings/price history, recommend |
| "Track price of [product]" | Monitor, alert on drops, suggest buy timing |
| "Reorder my [consumable]" | Find previous order, check price vs last time, reorder |
| "Is this deal real?" | Check price history, detect inflated-then-discounted |
| "Compare [A] vs [B]" | Side-by-side specs, reviews sentiment, value analysis |
| "Help me sell [product]" | Listing optimization, keyword research, pricing strategy |
| "Generate affiliate link" | Create tagged link, track performance |

## Buyer Mode — Core Capabilities

**Product research:**
- Search with filters (price, rating, Prime, seller type)
- Aggregate reviews — summarize pros/cons, detect fake patterns
- Compare alternatives with feature matrix
- Check seller reputation (third-party risk assessment)

**Price intelligence:**
- Track historical prices (detect fake discounts)
- Alert on price drops to target
- Identify best time to buy (Prime Day, Black Friday patterns)
- Compare across Amazon regions when applicable

**Purchasing:**
- Add to cart, apply coupons/Subscribe & Save
- Reorder recurring items with price verification
- Gift purchases with delivery coordination
- Returns/refunds initiation

See `buying.md` for detailed workflows.

## Seller Mode — Core Capabilities

**Listing management:**
- Create/optimize product listings
- Keyword research for search visibility
- A+ Content recommendations
- Image requirements compliance

**Operations:**
- Inventory monitoring and restock alerts
- FBA shipment planning
- Pricing vs competition tracking
- Review monitoring and response drafts

**Analytics:**
- Sales velocity, conversion rates
- Advertising performance (PPC)
- Profit margin calculation (fees, shipping, returns)

See `selling.md` for seller workflows.

## Affiliate Mode — Core Capabilities

**Link management:**
- Generate affiliate links with proper tags
- Shorten/customize for platforms
- Track click-through and conversions

**Content optimization:**
- High-commission product categories
- Seasonal trending products
- Comparison content ideas

See `affiliates.md` for affiliate strategies.

## Critical Security Rules

**Credentials — NEVER:**
- Store Amazon password in plain text
- Share session cookies across devices
- Bypass 2FA prompts

**Payments — ALWAYS:**
- Confirm total before purchase
- Verify shipping address
- Alert on unusual amounts

**Automation — LIMITS:**
- Rate limit all requests (avoid account flags)
- No automated purchasing without human confirmation
- Respect session timeouts

See `security.md` for complete security protocols.

## Legal Constraints

**Automation boundaries:**
- Amazon ToS prohibits certain bots — know the limits
- Affiliate disclosure required on all monetized content
- Seller account actions need manual confirmation

**What's allowed:**
- Price tracking via public pages
- Affiliate link generation
- Listing optimization assistance

**What requires caution:**
- Automated purchasing (needs explicit user auth flow)
- Review analysis at scale (rate limits)
- Scraping product data (use official APIs when available)

See `legal.md` for ToS details and safe practices.
