# Amazon Product Scraper

> 亚马逊竞品分析工具 - 使用 OpenClaw 内置浏览器抓取亚马逊产品Listing信息

## 概述

这个 Skill 用于抓取亚马逊产品页面的完整信息，包括标题、价格、排名、五点描述、规格参数等，生成结构化的竞品分析报告。

## 触发方式

当用户要求：
- "抓取亚马逊竞品"
- "分析亚马逊产品"
- "查找ASIN信息"
- "竞品报告"
- 提供 ASIN (如 B0D3ZBFMW6)
- 提供亚马逊链接 (如 https://www.amazon.com/dp/B0XXXXX)

## 执行流程

### 1. 打开产品页面

使用 browser 工具打开亚马逊产品页面：
```
targetUrl: https://www.amazon.com/dp/{ASIN}
```

### 2. 等待页面加载

等待 3-5 秒让页面完全加载

### 3. 获取页面快照

使用 browser snapshot 获取完整页面结构

### 4. 提取关键信息

从快照中提取以下信息：

| 信息类型 | 提取位置 |
|----------|----------|
| ASIN | 产品详情页 |
| 标题 | heading 标题 |
| 价格 | 价格区域 |
| 评分 | review 区域 |
| 评论数 | review count |
| BSR 大类 | Best Sellers Rank |
| BSR 小类 | Best Sellers Rank |
| 五点描述 | About this item |
| 规格参数 | Technical Specifications |
| 套餐变体 | Variant 区域 |
| 品牌 | Brand 字段 |
| 上架日期 | Date First Available |
| 卖家 | Seller 信息 |

### 5. 生成报告

按照以下模板生成竞品分析报告：

```markdown
# 亚马逊竞品分析报告

**ASIN**: {ASIN}  
**抓取时间**: {时间}  
**产品类别**: {类别}

---

## 一、产品基本信息

| 字段 | 内容 |
|------|------|
| **ASIN** | {ASIN} |
| **标题** | {标题} |
| **品牌** | {品牌} |
| **Manufacturer** | {Manufacturer} |
| **上架日期** | {上架日期} |
| **店铺** | {店铺} |
| **卖家** | {卖家} |

---

## 二、价格信息

| 项目 | 数值 |
|------|------|
| **当前售价** | {价格} |
| **原价** | {原价} |
| **折扣** | {折扣} |
| **Prime 配送** | {配送} |

### 套餐变体

| 套餐 | 价格 | 库存 |
|------|------|------|
| {套餐1} | {价格1} | {库存1} |
| ... | ... | ... |

---

## 三、排名信息

| 排名维度 | 数据 |
|----------|------|
| **BSR 大类** | {大类排名} |
| **BSR 小类** | {小类排名} |
| **月销量** | {月销量} |
| **Amazon's Choice** | {是否} |
| **评分** | {评分} ({评论数} reviews) |
| **返回率** | {返回率} |

---

## 四、规格参数

| 参数 | 值 |
|------|-----|
| {参数1} | {值1} |
| ... | ... |

---

## 五、五点描述 (完整版)

从快照的 "About this item" 部分提取所有五点描述，**完整输出每一行的完整内容**，不要省略。

格式：
```markdown
1. **{标题1}**  
   {完整描述1}

2. **{标题2}**  
   {完整描述2}

3. **{标题3}**  
   {完整描述3}

... (按实际数量完整列出)
```

**重要**：每一行的完整文本都要保留，包括emoji、完整句子等，不要截断或省略。

---

## 六、竞品分析总结

### 优势
- {优势1}
- {优势2}

### 弱点
- {弱点1}
- {弱点2}

### 机会
- {机会1}
- {机会2}

---

## 七、定价参考

| 竞品套餐 | 价格 | 你的定价建议 |
|----------|------|-------------|
| {套餐} | {价格} | {建议} |

---

**文件保存位置**: memory/竞品分析报告-{ASIN}.md
```

### 6. 保存文件

将报告保存到 `memory/竞品分析报告-{ASIN}.md`

### 7. 输出给用户

将完整报告输出给用户审阅

## 重要提示

- 使用 OpenClaw 内置的 browser 工具，不需要额外 API
- 亚马逊可能有反爬机制，如果第一次失败可以多试几次
- 某些信息（如 BSR 大类排名）可能在页面下方，需要滚动查看
- **五点描述可能不止 5 条，有些产品有 6-8 条，必须完整提取每一行，不要省略**
- **所有文本都要完整保留，包括 emoji、完整句子，不要截断**

## 示例

用户输入：`B0D3ZBFMW6`

执行结果：生成完整的竞品分析报告并保存到文件
