# Amadeus Hotel Amenity Codes

Use these codes with `--amenities` filter in search.

## Room Amenities

| Code | Description |
|------|-------------|
| AIR_CONDITIONING | Air conditioning |
| BABY_SITTING | Babysitting service |
| BUSINESS_CENTER | Business center |
| DISABLED_FACILITIES | Disabled facilities |
| CASINO | Casino |
| CONFERENCE_ROOM | Conference room |
| DIRECT_DIAL_TELEPHONE | Direct dial telephone |
| DRIVING_RANGE | Driving range |
| DRY_CLEANING | Dry cleaning service |
| ELEVATOR | Elevator |
| EXCHANGE_FACILITY | Currency exchange |
| EXECUTIVE_FLOOR | Executive floor |
| FREE_LOCAL_CALLS | Free local calls |
| GYM | Fitness center/gym |
| HAIRDRESSER | Hairdresser/salon |
| HEALTH_SPA | Health spa |
| INDOOR_POOL | Indoor swimming pool |
| JACUZZI | Jacuzzi/hot tub |
| KITCHEN | Kitchen/kitchenette |
| LOUNGE | Lounge area |
| MASSAGE | Massage service |
| MINIBAR | Minibar |
| NO_SMOKING_ROOM | Non-smoking rooms |
| OUTDOOR_POOL | Outdoor swimming pool |
| PARKING | Parking |
| PETS_ALLOWED | Pet-friendly |
| POOL | Swimming pool (general) |
| RESTAURANT | Restaurant |
| ROOM_SERVICE | Room service |
| SAFE | In-room safe |
| SAUNA | Sauna |
| SPA | Spa |
| SOLARIUM | Solarium |
| TELEVISION | Television |
| TENNIS | Tennis court |
| VALET_PARKING | Valet parking |
| WAKE_UP_CALL | Wake-up call service |
| WIFI | WiFi (free or paid) |

## Board Types (Meal Plans)

| Code | Description |
|------|-------------|
| ROOM_ONLY | Room only, no meals |
| BREAKFAST | Breakfast included |
| HALF_BOARD | Breakfast + dinner |
| FULL_BOARD | All meals included |
| ALL_INCLUSIVE | All-inclusive |

## Rating Classes

| Value | Stars |
|-------|-------|
| 1 | ★ |
| 2 | ★★ |
| 3 | ★★★ |
| 4 | ★★★★ |
| 5 | ★★★★★ |

## Example Combinations

```bash
# Luxury beach resort
--amenities POOL,SPA,RESTAURANT,GYM --ratings 4,5

# Business traveler
--amenities WIFI,BUSINESS_CENTER,CONFERENCE_ROOM,GYM

# Family vacation
--amenities POOL,KITCHEN,BABY_SITTING,PETS_ALLOWED

# Budget-conscious
--amenities WIFI,PARKING --ratings 3,4
```
