---
name: amadeus-hotels
description: Search hotel prices and availability via Amadeus API. Find vacation hotels by city, coordinates, or amenities. Compare prices, view ratings, get offer details. Track prices with alerts. Use when user asks to "find hotels", "search hotels in [city]", "hotel prices", "vacation accommodation", "hotel deals", "track hotel price".
homepage: https://github.com/kesslerio/amadeus-hotels-clawhub-skill
metadata:
  {
    "openclaw":
      {
        "emoji": "🏨",
        "requires":
          {
            "bins": ["python3"],
            "env": ["AMADEUS_API_KEY", "AMADEUS_API_SECRET"],
          },
        "primaryEnv": "AMADEUS_API_KEY",
        "install":
          [
            {
              "id": "pip-requests",
              "kind": "pip",
              "packages": ["requests"],
              "label": "Install requests (pip)",
            },
          ],
      },
  }
---

# Amadeus Hotels Skill 🏨

Search hotel prices, availability, and ratings via the Amadeus Self-Service API. Perfect for vacation planning and deal hunting.

## Setup

1. **Get API credentials** at https://developers.amadeus.com/self-service
   - Create account → My Apps → Create new app
   - Copy API Key and API Secret

2. **Set environment variables:**
```bash
export AMADEUS_API_KEY="your-api-key"
export AMADEUS_API_SECRET="your-api-secret"
export AMADEUS_ENV="test"  # or "production" for real bookings
```

3. **Install dependency:**
```bash
pip install requests
```

**Free tier:** ~2,000 requests/month in test, pay-per-use after in production.

## Quick Reference

| Task | Script | Example |
|------|--------|---------|
| Search by city | `scripts/search.py` | `--city PAR --checkin 2026-03-15 --checkout 2026-03-20` |
| Get offers | `scripts/offers.py` | `--hotels HTPAR123,HTPAR456 --adults 2` |
| Offer details | `scripts/details.py` | `--offer-id ABC123` |
| Track price | `scripts/track.py` | `--add --hotel HTPAR123 --target 150` |
| Check tracked | `scripts/track.py` | `--check` |

## Capabilities

### 1. Hotel Search

Find hotels by city code (IATA) or coordinates:

```bash
# By city
python3 <skill>/scripts/search.py --city PAR --checkin 2026-03-15 --checkout 2026-03-20

# By coordinates (near a landmark)
python3 <skill>/scripts/search.py --lat 48.8584 --lon 2.2945 --radius 5 --checkin 2026-03-15 --checkout 2026-03-20

# With filters
python3 <skill>/scripts/search.py --city NYC --amenities WIFI,POOL,SPA --ratings 4,5
```

**Common city codes:** PAR (Paris), NYC (New York), TYO (Tokyo), BCN (Barcelona), LON (London), LAX (Los Angeles), SFO (San Francisco)

### 2. Get Pricing & Availability

Once you have hotel IDs from search:

```bash
python3 <skill>/scripts/offers.py \
  --hotels HTPAR001,HTPAR002 \
  --checkin 2026-03-15 \
  --checkout 2026-03-20 \
  --adults 2 \
  --rooms 1
```

Returns: Room types, prices, cancellation policies, board types.

### 3. Offer Details

Get full details for a specific offer before booking:

```bash
python3 <skill>/scripts/details.py --offer-id <offer-id-from-search>
```

Returns: Detailed room info, full cancellation policy, payment terms, hotel contact.

### 4. Hotel Ratings & Sentiment

Get aggregated review sentiment:

```bash
python3 <skill>/scripts/details.py --hotel-id HTPAR001 --ratings
```

Returns: Overall score (0-100), category scores (Staff, Location, WiFi, Cleanliness, etc.)

### 5. Price Tracking

Track hotels and get alerts when prices drop:

```bash
# Add hotel to tracking
python3 <skill>/scripts/track.py --add \
  --hotel HTPAR001 \
  --checkin 2026-03-15 \
  --checkout 2026-03-20 \
  --adults 2 \
  --target 150  # Alert if price drops below $150/night

# Check all tracked hotels (run via cron)
python3 <skill>/scripts/track.py --check

# List tracked hotels
python3 <skill>/scripts/track.py --list

# Remove from tracking
python3 <skill>/scripts/track.py --remove --hotel HTPAR001
```

### Cron Setup for Price Alerts

Add to OpenClaw cron for automatic price monitoring:

```yaml
# Check hotel prices twice daily
- schedule: "0 9,18 * * *"
  task: "Run hotel price tracker and alert on drops"
  command: "python3 <skill>/scripts/track.py --check"
```

When prices drop below target, the script outputs alert text. Configure your notification channel in the cron task.

## Output Formatting

Scripts output JSON by default. Add `--format human` for readable output:

```bash
python3 <skill>/scripts/search.py --city PAR --format human
```

Human format example:
```
🏨 Hotel & Spa Paris Marais ★★★★
   📍 15 Rue du Temple, Paris
   💰 €189/night (was €220)
   ✨ WIFI, SPA, RESTAURANT
   📊 Rating: 87/100 (Staff: 92, Location: 95)
```

## Amenity Codes

Common filters for `--amenities`:

| Code | Meaning |
|------|---------|
| WIFI | Free WiFi |
| POOL | Swimming pool |
| SPA | Spa/wellness |
| GYM | Fitness center |
| RESTAURANT | On-site restaurant |
| PARKING | Parking available |
| PETS_ALLOWED | Pet-friendly |
| AIR_CONDITIONING | A/C |
| KITCHEN | Kitchen/kitchenette |

Full list in `references/amenities.md`.

## ⚠️ Important: Pricing Disclaimer

**Amadeus API prices are NOT retail prices.** The API returns negotiated, net, or wholesale rates — not the public prices you see on Booking.com, Expedia, or hotel websites.

Key differences:
- **Net vs Retail:** API returns "net rates" (raw cost), not marked-up retail prices
- **B2B Pricing:** Designed for travel agencies/developers to add their own markup
- **Negotiated Rates:** May include corporate or consortia rates unavailable to consumers
- **Tax Breakdown:** Prices often show base + taxes separately

**Use these prices for comparison and tracking trends**, not as exact retail quotes. Actual booking prices on consumer sites will differ.

## Limitations & Notes

- **Test environment:** Limited/cached data, not real-time. Good for development.
- **Production:** Real prices but requires "Move to Production" in Amadeus dashboard.
- **No direct booking:** API returns offer details; actual booking requires payment handling (PCI compliance).
- **Rate limits:** 10 TPS (test), 40 TPS (production). Scripts include backoff.
- **Data freshness:** Prices change frequently. Always re-check before booking elsewhere.
- **Not retail prices:** See pricing disclaimer above.

## Error Handling

| Error | Meaning | Action |
|-------|---------|--------|
| 401 | Auth failed | Check API key/secret |
| 429 | Rate limited | Wait and retry (auto-handled) |
| 400 | Bad request | Check parameters (dates, codes) |
| No results | No availability | Try different dates or expand search |

## References

- `references/amenities.md` — Full amenity code list
- https://developers.amadeus.com/self-service/apis-docs — Official API docs
