# Amadeus Hotels Skill 🏨

An OpenClaw skill for searching hotel prices and availability via the Amadeus Self-Service API. Perfect for vacation planning and deal hunting.

## Features

- **Hotel Search**: Find hotels by city code or coordinates
- **Pricing**: Get room rates and availability
- **Details**: Full offer info, cancellation policies, ratings
- **Price Tracking**: Monitor hotels and alert on price drops

## Installation

### For OpenClaw

Clone to your skills directory:

```bash
git clone https://github.com/kesslerio/amadeus-hotels-clawhub-skill.git ~/.openclaw/skills/amadeus-hotels
```

Or add to your workspace's `skills/` folder.

### Dependencies

```bash
pip install requests
```

### Amadeus API Setup

1. Create account at https://developers.amadeus.com/self-service
2. Create a new app to get API credentials
3. Set environment variables:

```bash
export AMADEUS_API_KEY="your-api-key"
export AMADEUS_API_SECRET="your-api-secret"
export AMADEUS_ENV="test"  # or "production"
```

## Usage

### Search Hotels

```bash
# By city
python3 scripts/search.py --city PAR --format human

# By coordinates
python3 scripts/search.py --lat 48.8584 --lon 2.2945 --radius 5 --format human

# With filters
python3 scripts/search.py --city NYC --amenities WIFI,POOL --ratings 4,5
```

### Get Pricing

```bash
python3 scripts/offers.py \
  --hotels HTPAR001,HTPAR002 \
  --checkin 2026-03-15 \
  --checkout 2026-03-20 \
  --adults 2 \
  --format human
```

### Track Prices

```bash
# Add to tracking
python3 scripts/track.py --add \
  --hotel HTPAR001 \
  --checkin 2026-03-15 \
  --checkout 2026-03-20 \
  --target 150

# Check all tracked (for cron)
python3 scripts/track.py --check

# List tracked
python3 scripts/track.py --list
```

## Free Tier

- ~2,000 requests/month in test environment
- Pay-per-use in production after quota

## License

MIT

## Links

- [Amadeus Self-Service APIs](https://developers.amadeus.com/self-service)
- [OpenClaw](https://openclaw.ai)
- [ClawdHub](https://clawhub.com)
