# 阿里云 OSS 配置指南

## 环境变量配置

在使用 OSS 上传功能前，需要设置以下环境变量：

| 环境变量 | 说明 | 示例 |
|---------|------|------|
| `ALIYUN_OSS_ACCESS_KEY_ID` | 阿里云 AccessKey ID | `LTAI5t8Z3y8Y7Z7Z7Z7Z7Z7Z` |
| `ALIYUN_OSS_ACCESS_KEY_SECRET` | 阿里云 AccessKey Secret | `your-secret-key` |
| `ALIYUN_OSS_ENDPOINT` | OSS 地域 Endpoint | `https://oss-cn-hangzhou.aliyuncs.com` |
| `ALIYUN_OSS_BUCKET` | 存储空间名称 | `my-bucket-name` |

## 获取 AccessKey

1. 登录 [阿里云控制台](https://www.aliyun.com/)
2. 进入 **AccessKey 管理** 页面
3. 创建或使用现有的 AccessKey
4. **注意**：AccessKey Secret 只在创建时显示一次，请妥善保存

## 常用 Endpoint

| 地域 | Endpoint |
|------|----------|
| 华东1（杭州） | `https://oss-cn-hangzhou.aliyuncs.com` |
| 华东2（上海） | `https://oss-cn-shanghai.aliyuncs.com` |
| 华北1（青岛） | `https://oss-cn-qingdao.aliyuncs.com` |
| 华北2（北京） | `https://oss-cn-beijing.aliyuncs.com` |
| 华南1（深圳） | `https://oss-cn-shenzhen.aliyuncs.com` |

完整列表参见：[OSS 地域和访问域名](https://help.aliyun.com/document_detail/31837.html)

## 设置环境变量

### Linux/macOS
```bash
export ALIYUN_OSS_ACCESS_KEY_ID="your-access-key-id"
export ALIYUN_OSS_ACCESS_KEY_SECRET="your-access-key-secret"
export ALIYUN_OSS_ENDPOINT="https://oss-cn-hangzhou.aliyuncs.com"
export ALIYUN_OSS_BUCKET="your-bucket-name"
```

### Windows (PowerShell)
```powershell
$env:ALIYUN_OSS_ACCESS_KEY_ID="your-access-key-id"
$env:ALIYUN_OSS_ACCESS_KEY_SECRET="your-access-key-secret"
$env:ALIYUN_OSS_ENDPOINT="https://oss-cn-hangzhou.aliyuncs.com"
$env:ALIYUN_OSS_BUCKET="your-bucket-name"
```

### 永久配置（推荐）

将上述 export 命令添加到 `~/.bashrc` 或 `~/.zshrc` 文件中。

## Bucket 权限设置

确保你的 Bucket 设置为 **私有**（推荐），通过生成的临时链接访问文件：

1. 进入 OSS 控制台
2. 选择你的 Bucket
3. 进入 **权限控制** → **Bucket ACL**
4. 选择 **私有**

## 依赖安装

```bash
pip install oss2
```
