---
name: aliyun-oss-upload
description: 阿里云 OSS 文件上传工具，支持上传文件到阿里云对象存储并生成临时访问链接。使用场景：将本地文件上传到 OSS 并获得可分享的临时 URL。需要配置 ALIYUN_OSS_ACCESS_KEY_ID、ALIYUN_OSS_ACCESS_KEY_SECRET、ALIYUN_OSS_ENDPOINT、ALIYUN_OSS_BUCKET 环境变量。
---

# 阿里云 OSS 文件上传

这个技能提供阿里云 OSS（对象存储服务）的文件上传功能，支持生成带签名的临时访问链接。

## 快速开始

### 1. 配置环境变量

使用前必须配置以下环境变量（详见 [references/config.md](references/config.md)）：

```bash
export ALIYUN_OSS_ACCESS_KEY_ID="your-access-key-id"
export ALIYUN_OSS_ACCESS_KEY_SECRET="your-access-key-secret"
export ALIYUN_OSS_ENDPOINT="https://oss-cn-hangzhou.aliyuncs.com"
export ALIYUN_OSS_BUCKET="your-bucket-name"
```

### 2. 安装依赖

```bash
pip install oss2
```

## 使用方法

### 上传文件

```bash
python scripts/oss-upload.py upload --file /path/to/local/file.txt
```

可选参数：
- `--key`：指定 OSS 中的文件名（默认使用本地文件名）
- `--expire`：链接有效期（秒，默认 3600）

示例：
```bash
# 上传到指定路径
python scripts/oss-upload.py upload --file photo.jpg --key images/photo.jpg --expire 7200
```

### 生成临时访问链接

```bash
python scripts/oss-upload.py url --key images/photo.jpg --expire 3600
```

## 工作流程

1. 用户请求上传文件时：
   - 确认本地文件路径
   - 运行上传脚本
   - 返回上传结果和临时访问链接

2. 用户已有 OSS 文件需要访问链接时：
   - 运行 url 命令生成签名链接
   - 返回临时访问 URL

## 注意事项

- 临时链接有效期默认 1 小时，可根据需求调整
- Bucket 建议设置为私有，通过签名链接安全访问
- 上传大文件时脚本会自动处理，无需额外配置
