---
name: aliyun-asr
description: "Pure Aliyun ASR skill for voice message transcription, supports multiple channels including Feishu"
metadata:
  {
    "openclaw":
      {
        "emoji": "🎙️",
        "requires": { "bins": ["python3"] },
        "install": [],
      },
  }
---

# 阿里云语音识别 (Aliyun ASR) 技能

**纯语音识别，无语音合成** - 这是一个专门为OpenClaw设计的轻量级阿里云语音识别技能，只做一件事：将语音消息转换为文本。

## 🎯 核心功能

- **✅ 纯ASR识别**: 只进行语音到文本的转换，**不生成任何语音回复**
- **✅ 多通道支持**: 支持飞书(Feishu)、Telegram、WhatsApp等所有OpenClaw支持的语音消息通道
- **✅ 自动集成**: 无需额外配置，语音消息自动被识别并作为文本消息处理

## ⚙️ 快速配置

### 1. 阿里云准备
- 开通 [智能语音交互(NLS)](https://nls-portal.console.aliyun.com/) 服务
- 在RAM控制台创建子用户并分配 `AliyunNLSFullAccess` 权限
- 在NLS控制台创建应用，获取 **AppKey**

### 2. 配置文件
创建配置文件 `/root/.openclaw/aliyun-asr-config.json`:

```json
{
  "access_key_id": "your-access-key-id",
  "access_key_secret": "your-access-key-secret",
  "app_key": "your-app-key",
  "region": "cn-shanghai"
}
```

### 3. 安全设置
```bash
chmod 600 /root/.openclaw/aliyun-asr-config.json
```

## 🚀 使用方法

### 自动模式（推荐）
1. 用户向任何支持的通道发送语音消息
2. OpenClaw自动调用此技能识别语音内容
3. **识别的文本作为用户消息传递给AI**
4. **AI生成纯文本回复（不是语音）**

## 🔧 技术细节

- **依赖**: `requests` (Python包)
- **支持格式**: MP3, WAV, OGG, FLAC, AMR, OPUS
- **API区域**: 默认 `cn-shanghai`（可配置）

## 🛡️ 安全与合规

- **无数据存储**: 语音数据不存储在本地
- **最小权限**: 使用RAM子账号，避免主账号密钥
- **配置分离**: 敏感信息与代码完全分离

## 💡 开发规范

此技能严格遵循以下开发准则：
1. ✅ 完全符合开源skills的配置要求
2. ✅ 完全符合当地的法律法规要求  
3. ✅ 未开发或未实现的功能，不包含在源码中
4. ✅ 本地测试代码，测试用例不包含在源码中
5. ✅ 密钥/认证隐私信息，不包含在源代码中