# Dropshipping — Aliexpress

## Supplier Requirements

Minimum criteria for dropshipping supplier:

| Metric | Minimum | Ideal |
|--------|---------|-------|
| Positive feedback | 98% | 99%+ |
| Store age | 2 years | 4+ years |
| Response time | <24h | <6h |
| ePacket/Standard Shipping | Required | — |
| Order volume | >500 orders on product | >2000 |

## Margin Calculation

```
Selling Price - Landed Cost = Gross Margin

Landed Cost:
+ Product price
+ Shipping (to customer's country)
+ Payment processing (2.9% + $0.30 typical)
+ Platform fees (if Shopify, Etsy, etc.)
+ Return reserve (5-10%)

Target: >30% gross margin after ALL costs
```

## Product Selection

### Green Flags
- High order count, stable over months
- Photo reviews showing quality
- Multiple vendors = competitive pricing
- Lightweight (cheap shipping)
- No brand names (avoid counterfeits)

### Red Flags
- Single supplier only
- Seasonal spike then drop
- Heavy/fragile (shipping kills margin)
- Brand lookalikes (legal risk)
- Complex sizing (high return rate)

## Shipping Strategy

| Method | Time | Cost | Tracking |
|--------|------|------|----------|
| AliExpress Standard | 15-25 days | $2-5 | Yes |
| ePacket | 12-20 days | $3-7 | Yes |
| Cainiao | 20-40 days | $0-3 | Limited |
| Private Line | 10-15 days | $5-15 | Yes |

Rule: Never use untracked shipping for dropshipping.

## Order Management

1. **Test order first**: Buy sample to verify quality
2. **Track spreadsheet**: Order ID, tracking, customer, status
3. **Auto-sync tools**: DSers, Oberlo alternatives, Spocket
4. **Dispute window**: Mark calendar for protection expiry

## Common Mistakes

- Not testing product before selling
- Ignoring shipping time in customer expectations
- Using "free shipping" (40-60 day wait)
- Calculating margin without all fees
- No return reserve (disputes happen)
