---
name: alicloud-ai-video-wan-r2v
description: Generate reference-based videos with Alibaba Cloud Model Studio Wan R2V (wan2.6-r2v-flash). Use when creating multi-shot videos from reference video/image material, preserving character style, or documenting reference-to-video request/response flows.
---

Category: provider

# Model Studio Wan R2V

Use Wan R2V for reference-to-video generation. This is different from i2v (single image to video).

## Critical model name

Use ONLY this exact model string:
- `wan2.6-r2v-flash`

## Prerequisites

- Install SDK in a virtual environment:

```bash
python3 -m venv .venv
. .venv/bin/activate
python -m pip install dashscope
```
- Set `DASHSCOPE_API_KEY` in your environment, or add `dashscope_api_key` to `~/.alibabacloud/credentials`.

## Normalized interface (video.generate_reference)

### Request
- `prompt` (string, required)
- `reference_video` (string | bytes, required)
- `reference_image` (string | bytes, optional)
- `duration` (number, optional)
- `fps` (number, optional)
- `size` (string, optional)
- `seed` (int, optional)

### Response
- `video_url` (string)
- `task_id` (string, when async)
- `request_id` (string)

## Async handling

- Prefer async submission for production traffic.
- Poll task result with 15-20s intervals.
- Stop polling when `SUCCEEDED` or terminal failure status is returned.

## Local helper script

Prepare a normalized request JSON and validate response schema:

```bash
.venv/bin/python skills/ai/video/alicloud-ai-video-wan-r2v/scripts/prepare_r2v_request.py \
  --prompt "Generate a short montage with consistent character style" \
  --reference-video "https://example.com/reference.mp4"
```

## Output location

- Default output: `output/ai-video-wan-r2v/videos/`
- Override base dir with `OUTPUT_DIR`.

## References

- `references/sources.md`
