# Prompt Guide (Qwen Image)

Five practical prompt patterns to improve image generation quality.

## Core principle

Describe a scene, not just keywords.

```
Bad: cat, cute, window, sunlight
Good: a white cat napping on a sunny windowsill, soft afternoon light, shallow depth of field
```

## 1) Photorealistic

Include camera and lighting details.

Example:
```
portrait photo, 85mm lens, f/1.8, golden hour rim light, natural skin texture, soft bokeh background
```

## 2) Illustration / Sticker

Call out a clear style and line treatment.

Example:
```
flat vector sticker of a smiling coffee mug, pastel palette, thick black outline, clean white background
```

## 3) Text-in-image

Be explicit about font, placement, and size.

Example:
```
birthday card with the text "HAPPY BIRTHDAY", bold sans-serif, centered, large type, pastel balloons background
```

## 4) Product photo

Use studio lighting and a specific angle.

Example:
```
product photo of wireless earbuds on a white sweep, softbox lighting, 45 degree angle, minimal shadow, high detail
```

## 5) Minimal design

Emphasize negative space and limited palette.

Example:
```
minimal abstract wallpaper, light blue gradient background, small geometric shape in bottom-right, lots of whitespace
```

## Editing prompts (when using reference_image)

Add:
```
add a rainbow in the background
```

Remove:
```
remove the person in the background
```

Change:
```
change the hair color to blonde
```

Style transfer:
```
convert to watercolor style
```
